/*
 * Decompiled with CFR 0.152.
 */
package dev.sam.signs_and_signals.block;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import dev.sam.keys_and_leds_core.KeysAndLedsCore;
import dev.sam.signs_and_signals.SignsAndSignals;
import dev.sam.signs_and_signals.block.GenericSteelPostBlock;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SteelPostBaseBlock
extends GenericSteelPostBlock {
    protected final BiMap<String, String> boxToBaseMap = HashBiMap.create();
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;

    public SteelPostBaseBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.boxToBaseMap.put((Object)"control_cabinet", (Object)"steel_post_signal_base");
        this.boxToBaseMap.put((Object)"junction_box", (Object)"steel_post_crossing_base");
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)13.5, (double)11.0), Block.func_208617_a((double)6.0, (double)13.5, (double)6.0, (double)10.0, (double)16.0, (double)10.0)});
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, WATERLOGGED});
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext use) {
        FluidState fluidstate = use.func_195991_k().func_204610_c(use.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)use.func_195992_f().func_176734_d())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    protected Optional<Block> tryGetBaseFromItem(Item item) {
        ResourceLocation itemName = item.getRegistryName();
        if (itemName == null) {
            return Optional.empty();
        }
        String baseName = (String)this.boxToBaseMap.get((Object)itemName.func_110623_a());
        return Optional.ofNullable(SignsAndSignals.BLOCKS.get(baseName));
    }

    protected Optional<Item> tryGetBoxFromBlock(Block block) {
        ResourceLocation blockName = block.getRegistryName();
        if (blockName == null) {
            return Optional.empty();
        }
        String boxName = (String)this.boxToBaseMap.inverse().get((Object)blockName.func_110623_a());
        return Optional.ofNullable(KeysAndLedsCore.ITEMS.get(boxName));
    }

    protected void setupData(BlockState state, World world, BlockPos pos, BlockPos neighborPos) {
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        ItemStack stack = player.func_184586_b(hand);
        Direction direction = result.func_216354_b().func_176734_d();
        DirectionalPlaceContext context = new DirectionalPlaceContext(world, pos, direction, stack, direction);
        Optional<SteelPostBaseBlock> optional = this.tryGetBaseFromItem(stack.func_77973_b()).filter(block -> block instanceof SteelPostBaseBlock).map(base -> (SteelPostBaseBlock)base);
        if (!optional.isPresent()) {
            return ActionResultType.PASS;
        }
        SteelPostBaseBlock base2 = optional.get();
        BlockState baseState = base2.func_196258_a((BlockItemUseContext)context);
        if (baseState == null) {
            return ActionResultType.PASS;
        }
        world.func_175656_a(pos, baseState);
        world.func_205220_G_().func_205360_a(pos, (Object)baseState.func_177230_c(), 0);
        base2.setupData(state, world, pos, pos);
        if (!player.func_184812_l_()) {
            stack.func_190918_g(1);
        }
        world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 1.0f, 1.0f);
        return ActionResultType.CONSUME;
    }

    @Override
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Override
    public BlockState func_196271_a(BlockState state, Direction direction, BlockState neighborState, IWorld world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(state, direction, neighborState, world, pos, neighborPos);
    }

    protected void screwSpecialBase(ItemUseContext use) {
        PlayerEntity player = use.func_195999_j();
        if (player == null || !player.func_225608_bj_()) {
            return;
        }
        World world = use.func_195991_k();
        BlockPos pos = use.func_195995_a();
        Direction direction = player.func_174811_aO();
        DirectionalPlaceContext context = new DirectionalPlaceContext(world, pos, direction, use.func_195996_i(), direction);
        Block postBlock = (Block)SignsAndSignals.BLOCKS.get("steel_post");
        BlockState postState = postBlock.func_196258_a((BlockItemUseContext)context);
        if (postState == null) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        world.func_175656_a(pos, postState);
        world.func_205220_G_().func_205360_a(pos, (Object)postState.func_177230_c(), 0);
        if (player.func_184812_l_()) {
            return;
        }
        Optional<Item> box = this.tryGetBoxFromBlock(state.func_177230_c());
        if (!box.isPresent()) {
            return;
        }
        this.addItemToPlayerInventory(player, use.func_221531_n(), new ItemStack((IItemProvider)box.get()));
    }

    @Override
    public void screw(ItemUseContext use) {
    }
}

