/*
 * Decompiled with CFR 0.152.
 */
package dev.sam.signs_and_signals.block;

import dev.falsegamemaster.ihatecores.registration.events.InGameEventHandler;
import dev.sam.keys_and_leds_core.block.interfaces.IScrewable;
import dev.sam.signs_and_signals.SignsAndSignals;
import dev.sam.signs_and_signals.block.PostBlock;
import dev.sam.signs_and_signals.item.SignItem;
import dev.sam.signs_and_signals.stats.ModStats;
import dev.sam.signs_and_signals.tileentity.SignPostBlockEntity;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SignPostBlock
extends PostBlock
implements IScrewable,
InGameEventHandler {
    protected final String postName;

    public SignPostBlock(String postName, AbstractBlock.Properties properties) {
        super(null, properties);
        this.postName = postName;
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208138_am, (Comparable)Integer.valueOf(0))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208138_am, WATERLOGGED});
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext use) {
        FluidState fluidstate = use.func_195991_k().func_204610_c(use.func_195995_a());
        PlayerEntity player = use.func_195999_j();
        float yRot = player == null ? 0.0f : player.field_70177_z;
        int rotation = MathHelper.func_76128_c((double)((double)(yRot * 16.0f / 360.0f) + 0.5)) & 0xF;
        BlockState state = (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208138_am, (Comparable)Integer.valueOf(rotation))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
        use.func_195991_k().func_205220_G_().func_205360_a(use.func_195995_a(), (Object)state.func_177230_c(), 1);
        return state;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)SignsAndSignals.BLOCK_ENTITIES.get("sign_post")).func_200968_a();
    }

    @SubscribeEvent
    protected void onRightClick(PlayerInteractEvent.RightClickBlock e) {
        World world = e.getWorld();
        BlockPos pos = e.getPos();
        PlayerEntity player = e.getPlayer();
        if (world.func_180495_p(pos).func_177230_c().func_235332_a_((Block)this) && player.func_225608_bj_()) {
            e.setResult(Event.Result.ALLOW);
        }
    }

    protected ActionResultType useStanding(World world, BlockPos pos, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        Item item = stack.func_77973_b();
        if (!(item instanceof SignItem)) {
            return ActionResultType.PASS;
        }
        Block signBlock = ((SignItem)item).func_179223_d();
        TileEntity blockEntity = world.func_175625_s(pos);
        if (!(blockEntity instanceof SignPostBlockEntity)) {
            return ActionResultType.PASS;
        }
        SignPostBlockEntity signPostBlockEntity = (SignPostBlockEntity)blockEntity;
        if (signPostBlockEntity.getSignBlock().isPresent()) {
            return ActionResultType.PASS;
        }
        signPostBlockEntity.setSignBlock(signBlock, false);
        if (!player.func_184812_l_()) {
            stack.func_190918_g(1);
        }
        world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 1.0f, 1.0f);
        player.func_195066_a(ModStats.SIGNS_PLACED);
        return ActionResultType.CONSUME;
    }

    protected ActionResultType useCrouching(World world, BlockPos pos, PlayerEntity player, Hand hand) {
        TileEntity blockEntity = world.func_175625_s(pos);
        if (!(blockEntity instanceof SignPostBlockEntity)) {
            return ActionResultType.PASS;
        }
        SignPostBlockEntity signPostBlockEntity = (SignPostBlockEntity)blockEntity;
        signPostBlockEntity.getSignBlock().ifPresent(signBlock -> this.addItemToPlayerInventory(player, hand, new ItemStack((IItemProvider)signBlock)));
        signPostBlockEntity.setSignBlock(null, false);
        return ActionResultType.CONSUME;
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        return player.func_225608_bj_() ? this.useCrouching(world, pos, player, hand) : this.useStanding(world, pos, player, hand);
    }

    protected void setPostInWorld(ItemUseContext use) {
        PlayerEntity player = use.func_195999_j();
        if (player == null) {
            return;
        }
        World world = use.func_195991_k();
        BlockPos pos = use.func_195995_a();
        Direction direction = player.func_174811_aO();
        DirectionalPlaceContext context = new DirectionalPlaceContext(world, pos, direction, use.func_195996_i(), direction);
        BlockState postState = ((Block)SignsAndSignals.BLOCKS.get(this.postName)).func_196258_a((BlockItemUseContext)context);
        if (postState == null) {
            return;
        }
        world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 1.0f, 1.0f);
        world.func_175656_a(pos, postState);
    }

    protected void screwStanding(ItemUseContext use, SignPostBlockEntity signPostBlockEntity, PlayerEntity player) {
        if (signPostBlockEntity.getSignBlock().isPresent()) {
            return;
        }
        World world = use.func_195991_k();
        world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 1.0f, 1.0f);
        this.addItemToPlayerInventory(player, use.func_221531_n(), new ItemStack((IItemProvider)Items.field_191525_da));
        this.setPostInWorld(use);
    }

    protected void screwCrouching(ItemUseContext use, SignPostBlockEntity signPostBlockEntity, PlayerEntity player) {
        Hand hand = use.func_221531_n();
        signPostBlockEntity.getSignBlock().ifPresent(signBlock -> {
            this.addItemToPlayerInventory(player, hand, new ItemStack((IItemProvider)signBlock));
            signPostBlockEntity.setSignBlock(null, false);
        });
        World world = use.func_195991_k();
        world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 1.0f, 1.0f);
        this.addItemToPlayerInventory(player, hand, new ItemStack((IItemProvider)Items.field_191525_da));
        this.setPostInWorld(use);
    }

    @Nullable
    protected SignPostBlockEntity getBlockEntity(IBlockReader world, BlockPos pos) {
        TileEntity blockEntity = world.func_175625_s(pos);
        if (!(blockEntity instanceof SignPostBlockEntity)) {
            return null;
        }
        return (SignPostBlockEntity)blockEntity;
    }

    @Nullable
    protected SignPostBlockEntity getBlockEntity(ItemUseContext use) {
        return this.getBlockEntity((IBlockReader)use.func_195991_k(), use.func_195995_a());
    }

    public void screw(ItemUseContext use) {
        PlayerEntity player = use.func_195999_j();
        if (player == null) {
            return;
        }
        SignPostBlockEntity blockEntity = this.getBlockEntity(use);
        if (blockEntity == null) {
            return;
        }
        if (use.func_195999_j().func_225608_bj_()) {
            this.screwCrouching(use, blockEntity, player);
        } else {
            this.screwStanding(use, blockEntity, player);
        }
    }

    protected void addItemToPlayerInventory(PlayerEntity player, Hand hand, ItemStack stack) {
        if (player.func_184586_b(hand).func_190926_b()) {
            player.func_184611_a(hand, stack);
        } else if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_71019_a(stack, false);
        }
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        SignPostBlockEntity blockEntity = this.getBlockEntity(world, pos);
        if (blockEntity == null || !blockEntity.getSignBlock().isPresent()) {
            return new ItemStack((IItemProvider)this);
        }
        return new ItemStack((IItemProvider)blockEntity.getSignBlock().get());
    }
}

