/*
 * Decompiled with CFR 0.152.
 */
package dev.sam.signs_and_signals.block;

import dev.sam.keys_and_leds_core.block.interfaces.ISmashable;
import dev.sam.signs_and_signals.SignsAndSignals;
import dev.sam.signs_and_signals.block.SignPostBlock;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PostBlock
extends Block
implements ISmashable,
IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected final Supplier<SignPostBlock> signPost = () -> (SignPostBlock)SignsAndSignals.BLOCKS.get(signPostName);
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);

    public PostBlock(String signPostName, AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED});
    }

    public BlockState func_196258_a(BlockItemUseContext use) {
        FluidState fluidstate = use.func_195991_k().func_204610_c(use.func_195995_a());
        return (BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_77973_b() != Items.field_191525_da) {
            return ActionResultType.PASS;
        }
        BlockItemUseContext context = new BlockItemUseContext(player, hand, heldItem, result);
        BlockState signPostState = this.signPost.get().func_196258_a(context);
        if (signPostState == null) {
            return ActionResultType.PASS;
        }
        world.func_175656_a(pos, signPostState);
        world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!player.func_184812_l_()) {
            heldItem.func_190918_g(1);
        }
        return ActionResultType.CONSUME;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState neighborState, IWorld world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(state, direction, neighborState, world, pos, neighborPos);
    }

    protected int getPostLength(World world, BlockPos pos) {
        Block nextBlock;
        int length = 1;
        BlockPos nextPos = pos.func_177984_a();
        int i = 1;
        while (!World.func_217405_b((int)i) && (nextBlock = world.func_180495_p(nextPos).func_177230_c()) instanceof PostBlock) {
            ++length;
            nextPos = nextPos.func_177984_a();
            ++i;
        }
        return length;
    }

    public float getSmashSpeed(PlayerEntity player, BlockPos pos, BlockState state, float originalSpeed) {
        int length = this.getPostLength(player.field_70170_p, pos);
        float extraDurationPercentPerBlock = 0.2f;
        return originalSpeed / (extraDurationPercentPerBlock * (float)(length - 1) + 1.0f);
    }

    protected void destroyBlock(PlayerEntity player, BlockPos pos) {
        World world = player.field_70170_p;
        BlockState state = world.func_180495_p(pos);
        TileEntity blockEntity = world.func_175625_s(pos);
        world.func_225521_a_(pos, false, (Entity)player);
        state.func_177230_c().func_180657_a(world, player, pos, state, blockEntity, ItemStack.field_190927_a);
    }

    public boolean smash(PlayerEntity player, BlockPos pos) {
        World world = player.field_70170_p;
        BlockPos nextPos = pos.func_177984_a();
        Function<BlockPos, Block> blockAt = p -> world.func_180495_p(p).func_177230_c();
        while (blockAt.apply(nextPos) instanceof PostBlock) {
            this.destroyBlock(player, nextPos);
            nextPos = nextPos.func_177984_a();
        }
        return false;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType path) {
        return false;
    }
}

