/*
 * Decompiled with CFR 0.152.
 */
package dev.sam.signs_and_signals.block;

import dev.sam.keys_and_leds_core.util.EpilepsyUtil;
import dev.sam.signs_and_signals.SignsAndSignals;
import dev.sam.signs_and_signals.block.GenericSteelPostBlock;
import dev.sam.signs_and_signals.state.properties.ModBlockStateProperties;
import dev.sam.signs_and_signals.tileentity.interfaces.INBTTunnel;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class GenericSteelPostSignalBlock
extends GenericSteelPostBlock {
    public GenericSteelPostSignalBlock(AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)ModBlockStateProperties.field_208138_am, (Comparable)Integer.valueOf(0))).func_206870_a((Property)ModBlockStateProperties.SIGNAL_POWER, (Comparable)Integer.valueOf(0))).func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> state) {
        state.func_206894_a(new Property[]{ModBlockStateProperties.field_208138_am, ModBlockStateProperties.SIGNAL_POWER, BlockStateProperties.field_208190_q, WATERLOGGED});
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)SignsAndSignals.BLOCK_ENTITIES.get("steel_post_position_signal")).func_200968_a();
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext use) {
        World world = use.func_195991_k();
        BlockPos pos = use.func_195995_a();
        int signalPower = INBTTunnel.Block.tryGetData(world, pos.func_177977_b()).map(d -> d.func_74762_e("Power")).orElse(0);
        FluidState fluidstate = use.func_195991_k().func_204610_c(use.func_195995_a());
        PlayerEntity player = use.func_195999_j();
        float yRot = player == null ? 0.0f : player.field_70177_z;
        int rotation = MathHelper.func_76128_c((double)((double)(yRot * 16.0f / 360.0f) + 0.5)) & 0xF;
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)ModBlockStateProperties.field_208138_am, (Comparable)Integer.valueOf(rotation))).func_206870_a((Property)ModBlockStateProperties.SIGNAL_POWER, (Comparable)Integer.valueOf(signalPower))).func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(signalPower > 0))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
        world.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), 1);
        return state;
    }

    @Override
    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        int signalPowerBelow = INBTTunnel.Block.tryGetData((World)world, pos.func_177977_b()).map(data -> data.func_74762_e("Power")).orElse(0);
        world.func_180501_a(pos, this.getLightPosition(state, signalPowerBelow), 2);
        this.tryPullDataUp(state, (World)world, pos, pos.func_177977_b());
    }

    @Override
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos neighborPos, boolean bool) {
        int signalPower = (Integer)state.func_177229_b((Property)ModBlockStateProperties.SIGNAL_POWER);
        int signalPowerBelow = INBTTunnel.Block.tryGetData(world, pos.func_177977_b()).map(data -> data.func_74762_e("Power")).orElse(0);
        EpilepsyUtil.BlockUpdater.of((World)world, (BlockPos)pos, (BlockState)((BlockState)this.getLightPosition(state, signalPowerBelow).func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(signalPowerBelow > 0))), (int)4).shouldSkipIf(signalPower == signalPowerBelow).shouldDelayIf(signalPower != 0).run();
        this.tryPullDataUp(state, world, pos, neighborPos);
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        return ActionResultType.PASS;
    }

    @Override
    public boolean tryPullDataUp(World world, BlockPos pos) {
        boolean hasData = super.tryPullDataUp(world, pos);
        int signalPower = INBTTunnel.Block.tryGetData(world, pos).map(data -> data.func_74762_e("Power")).orElse(0);
        BlockState state = world.func_180495_p(pos);
        world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)ModBlockStateProperties.SIGNAL_POWER, (Comparable)Integer.valueOf(signalPower)));
        world.func_190524_a(pos.func_177984_a(), state.func_177230_c(), pos);
        return hasData;
    }

    @Override
    public void tryClearData(World world, BlockPos pos) {
        super.tryClearData(world, pos);
        BlockState state = world.func_180495_p(pos);
        world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)ModBlockStateProperties.SIGNAL_POWER, (Comparable)Integer.valueOf(0)));
    }

    protected abstract BlockState getLightPosition(BlockState var1, int var2);

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType path) {
        return false;
    }

    public abstract Block getSignalBlock();

    public abstract Property<?> getSignalProperty();

    @Override
    public void screw(ItemUseContext use) {
        PlayerEntity player = use.func_195999_j();
        if (player == null || !player.func_225608_bj_()) {
            return;
        }
        World world = use.func_195991_k();
        BlockPos pos = use.func_195995_a();
        Direction direction = player.func_174811_aO();
        DirectionalPlaceContext context = new DirectionalPlaceContext(world, pos, direction, use.func_195996_i(), direction);
        Block postBlock = (Block)SignsAndSignals.BLOCKS.get("steel_post");
        BlockState postState = postBlock.func_196258_a((BlockItemUseContext)context);
        if (postState == null) {
            return;
        }
        world.func_175656_a(pos, postState);
        world.func_205220_G_().func_205360_a(pos, (Object)postState.func_177230_c(), 0);
        if (player.func_184812_l_()) {
            return;
        }
        this.addItemToPlayerInventory(player, use.func_221531_n(), new ItemStack((IItemProvider)this.getSignalBlock()));
    }
}

