/*
 * Decompiled with CFR 0.152.
 */
package dev.sam.signs_and_signals.block;

import dev.falsegamemaster.ihatecores.registration.events.InGameEventHandler;
import dev.sam.keys_and_leds_core.block.interfaces.IScrewable;
import dev.sam.keys_and_leds_core.block.interfaces.ISmashable;
import dev.sam.keys_and_leds_core.util.SafeBlockState;
import dev.sam.signs_and_signals.SignsAndSignals;
import dev.sam.signs_and_signals.state.properties.ModBlockStateProperties;
import dev.sam.signs_and_signals.tileentity.interfaces.INBTTunnel;
import java.util.Random;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class GenericSteelPostBlock
extends Block
implements IScrewable,
ISmashable,
INBTTunnel.Block,
InGameEventHandler {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public GenericSteelPostBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j(SafeBlockState.of((BlockState)this.func_176223_P()).setValue((Property)ModBlockStateProperties.INDICATOR, (Comparable)Boolean.valueOf(false)).setValue((Property)ModBlockStateProperties.ON, (Comparable)Boolean.valueOf(false)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)).get());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return GenericSteelPostBlock.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{ModBlockStateProperties.INDICATOR, ModBlockStateProperties.ON, WATERLOGGED});
    }

    @Nullable
    protected BlockState getBase(BlockItemUseContext use) {
        FluidState fluidstate = use.func_195991_k().func_204610_c(use.func_195995_a());
        return (BlockState)((Block)SignsAndSignals.BLOCKS.get("steel_post_base")).func_196258_a(use).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext use) {
        BlockState state;
        BlockPos pos;
        World world = use.func_195991_k();
        boolean shouldPlaceBase = !(world.func_180495_p((pos = use.func_195995_a()).func_177977_b()).func_177230_c() instanceof GenericSteelPostBlock);
        FluidState fluidstate = use.func_195991_k().func_204610_c(use.func_195995_a());
        BlockState blockState = shouldPlaceBase ? this.getBase(use) : (state = (BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a)));
        if (state == null) {
            return null;
        }
        world.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), 1);
        return state;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        this.tryPullDataUp(state, (World)world, pos, pos.func_177977_b());
        this.updateIndicator(state, (World)world, pos);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)SignsAndSignals.BLOCK_ENTITIES.get("steel_post")).func_200968_a();
    }

    protected void onStateChanged(@Nullable Entity entity, Block block, BlockPos pos, BiPredicate<Entity, BlockPos> predicate) {
        if (entity == null) {
            return;
        }
        BlockPos abovePos = pos.func_177984_a();
        World world = entity.field_70170_p;
        if (!predicate.test(entity, abovePos)) {
            return;
        }
        Direction direction = entity.func_174811_aO();
        DirectionalPlaceContext context = new DirectionalPlaceContext(world, abovePos, direction, ItemStack.field_190927_a, direction);
        BlockState updated = block.func_196258_a((BlockItemUseContext)context);
        if (updated == null) {
            return;
        }
        world.func_175656_a(abovePos, updated);
    }

    @SubscribeEvent
    protected void onEntityPlace(BlockEvent.EntityPlaceEvent event) {
        this.onStateChanged(event.getEntity(), (Block)SignsAndSignals.BLOCKS.get("steel_post"), event.getPos(), (entity, abovePos) -> {
            Block base = (Block)SignsAndSignals.BLOCKS.get("steel_post_base");
            return entity.field_70170_p.func_180495_p(abovePos).func_177230_c().func_235332_a_(base);
        });
    }

    @SubscribeEvent
    protected void onEntityBreak(BlockEvent.BreakEvent event) {
        this.onStateChanged((Entity)event.getPlayer(), (Block)SignsAndSignals.BLOCKS.get("steel_post_base"), event.getPos(), (entity, abovePos) -> {
            Block post = (Block)SignsAndSignals.BLOCKS.get("steel_post");
            return entity.field_70170_p.func_180495_p(abovePos).func_177230_c().func_235332_a_(post);
        });
    }

    protected void tryPullDataUp(BlockState state, World world, BlockPos pos, BlockPos neighborPos) {
        if (!neighborPos.equals((Object)pos.func_177977_b())) {
            return;
        }
        BlockState neighborState = world.func_180495_p(neighborPos);
        if (neighborState.func_177230_c() instanceof GenericSteelPostBlock) {
            this.tryPullDataUp(world, pos);
        } else {
            this.tryClearData(world, pos);
        }
        world.func_190524_a(pos.func_177984_a(), state.func_177230_c(), pos);
    }

    protected void updateIndicator(BlockState state, World world, BlockPos pos) {
        boolean on = INBTTunnel.Block.tryGetData(world, pos).map(data -> data.func_74767_n("IndicatorOn")).orElse(false);
        world.func_175656_a(pos, SafeBlockState.of((BlockState)state).setValue((Property)ModBlockStateProperties.ON, (Comparable)Boolean.valueOf(on)).get());
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos neighborPos, boolean wtf) {
        this.tryPullDataUp(state, world, pos, neighborPos);
        this.updateIndicator(state, world, pos);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_77973_b() != Items.field_191525_da) {
            return ActionResultType.PASS;
        }
        BlockItemUseContext context = new BlockItemUseContext(player, hand, heldItem, result);
        BlockState signPostState = ((Block)SignsAndSignals.BLOCKS.get("steel_sign_post")).func_196258_a(context);
        if (signPostState == null) {
            return ActionResultType.PASS;
        }
        world.func_175656_a(pos, signPostState);
        world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!player.func_184812_l_()) {
            heldItem.func_190918_g(1);
        }
        return ActionResultType.CONSUME;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState neighborState, IWorld world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(state, direction, neighborState, world, pos, neighborPos);
    }

    public void screw(ItemUseContext use) {
        World world = use.func_195991_k();
        BlockPos pos = use.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        BlockState updated = SafeBlockState.of((BlockState)state).cycle((Property)ModBlockStateProperties.INDICATOR).get();
        world.func_175656_a(pos, updated);
    }

    protected int getPostLength(World world, BlockPos pos) {
        Block nextBlock;
        int length = 1;
        BlockPos nextPos = pos.func_177984_a();
        int i = 1;
        while (!World.func_217405_b((int)i) && (nextBlock = world.func_180495_p(nextPos).func_177230_c()) instanceof GenericSteelPostBlock) {
            ++length;
            nextPos = nextPos.func_177984_a();
            ++i;
        }
        return length;
    }

    public float getSmashSpeed(PlayerEntity player, BlockPos pos, BlockState state, float originalSpeed) {
        int length = this.getPostLength(player.field_70170_p, pos);
        float extraDurationPercentPerBlock = 0.2f;
        return originalSpeed / (extraDurationPercentPerBlock * (float)(length - 1) + 1.0f);
    }

    protected void destroyBlock(PlayerEntity player, BlockPos pos) {
        World world = player.field_70170_p;
        BlockState state = world.func_180495_p(pos);
        TileEntity blockEntity = world.func_175625_s(pos);
        world.func_225521_a_(pos, false, (Entity)player);
        if (player.func_184812_l_()) {
            return;
        }
        state.func_177230_c().func_180657_a(world, player, pos, state, blockEntity, ItemStack.field_190927_a);
    }

    public boolean smash(PlayerEntity player, BlockPos pos) {
        if (player.func_225608_bj_()) {
            return false;
        }
        World world = player.field_70170_p;
        BlockPos nextPos = pos.func_177984_a();
        Function<BlockPos, Block> blockAt = p -> world.func_180495_p(p).func_177230_c();
        while (blockAt.apply(nextPos) instanceof GenericSteelPostBlock) {
            this.destroyBlock(player, nextPos);
            nextPos = nextPos.func_177984_a();
        }
        return false;
    }

    protected void addItemToPlayerInventory(PlayerEntity player, Hand hand, ItemStack stack) {
        if (player.func_184586_b(hand).func_190926_b()) {
            player.func_184611_a(hand, stack);
        } else if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_71019_a(stack, false);
        }
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)SignsAndSignals.BLOCKS.get("steel_post"));
    }
}

