/*
 * Decompiled with CFR 0.152.
 */
package dev.sam.signs_and_signals.block;

import dev.sam.keys_and_leds_core.block.interfaces.IScrewable;
import dev.sam.signs_and_signals.SignsAndSignals;
import dev.sam.signs_and_signals.block.GenericSteelPostBlock;
import dev.sam.signs_and_signals.state.properties.BellTypes;
import dev.sam.signs_and_signals.state.properties.ModBlockStateProperties;
import dev.sam.signs_and_signals.tileentity.interfaces.INBTTunnel;
import java.util.Optional;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ElectronicBellBlock
extends Block
implements IScrewable {
    public ElectronicBellBlock(AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(ModBlockStateProperties.BELL_TYPES, (Comparable)((Object)BellTypes.NONE))).func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.FALSE)).func_206870_a((Property)ModBlockStateProperties.ON, (Comparable)Boolean.FALSE)).func_206870_a((Property)ModBlockStateProperties.BEFORE_ONLY, (Comparable)Boolean.FALSE));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        BellTypes type = (BellTypes)((Object)state.func_177229_b(ModBlockStateProperties.BELL_TYPES));
        if (type == BellTypes.NONE) {
            return Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)14.0, (double)10.0);
        }
        return Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> state) {
        state.func_206894_a(new Property[]{ModBlockStateProperties.BELL_TYPES, BlockStateProperties.field_208194_u, ModBlockStateProperties.ON, ModBlockStateProperties.BEFORE_ONLY});
    }

    public BlockState func_196258_a(BlockItemUseContext use) {
        World world = use.func_195991_k();
        BlockPos pos = use.func_195995_a();
        BlockState state = this.func_176223_P();
        BlockState below = world.func_180495_p(pos.func_177977_b());
        Optional<CompoundNBT> data = INBTTunnel.Block.tryGetData(world, pos);
        if (below.func_177230_c() instanceof GenericSteelPostBlock) {
            boolean neighborStart = data.map(d -> d.func_74767_n("Start")).orElse(false);
            if (neighborStart) {
                world.func_205220_G_().func_205360_a(pos, (Object)this, 0);
            }
            return (BlockState)((BlockState)state.func_206870_a(ModBlockStateProperties.BELL_TYPES, (Comparable)((Object)BellTypes.STEEL_POST))).func_206870_a((Property)ModBlockStateProperties.ON, (Comparable)Boolean.valueOf(neighborStart));
        }
        boolean neighborPowered = use.func_195991_k().func_175640_z(use.func_195995_a());
        if (neighborPowered) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, 0);
        }
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a(ModBlockStateProperties.BELL_TYPES, (Comparable)((Object)BellTypes.NONE))).func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(neighborPowered));
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos neighborPos, boolean bool) {
        if (world.field_72995_K) {
            return;
        }
        if (this.func_196260_a(state, (IWorldReader)world, pos)) {
            boolean powered = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u);
            boolean neighborPowered = world.func_175640_z(pos);
            BellTypes type = (BellTypes)((Object)state.func_177229_b(ModBlockStateProperties.BELL_TYPES));
            if (type == BellTypes.NONE) {
                if (powered == neighborPowered) {
                    return;
                }
                if (neighborPowered) {
                    BlockState updated = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(true));
                    world.func_175656_a(pos, updated);
                    world.func_205220_G_().func_205360_a(pos, (Object)this, 0);
                } else {
                    BlockState updated = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false));
                    world.func_175656_a(pos, updated);
                }
            } else {
                BlockState neighborState = world.func_180495_p(neighborPos);
                Optional<CompoundNBT> data = INBTTunnel.Block.tryGetData(world, neighborPos);
                if (neighborState.func_177230_c() instanceof GenericSteelPostBlock) {
                    boolean neighborStart = data.map(d -> d.func_74767_n("Start")).orElse(false);
                    boolean neighborRun = data.map(d -> d.func_74767_n("Run")).orElse(false);
                    boolean beforeOnly = (Boolean)state.func_177229_b((Property)ModBlockStateProperties.BEFORE_ONLY);
                    if (beforeOnly) {
                        if (neighborRun ^ neighborStart) {
                            BlockState updated = (BlockState)state.func_206870_a((Property)ModBlockStateProperties.ON, (Comparable)Boolean.valueOf(true));
                            world.func_175656_a(pos, updated);
                            world.func_205220_G_().func_205360_a(pos, (Object)this, 0);
                        } else {
                            BlockState updated = (BlockState)state.func_206870_a((Property)ModBlockStateProperties.ON, (Comparable)Boolean.valueOf(false));
                            world.func_175656_a(pos, updated);
                        }
                    } else if (neighborStart) {
                        BlockState updated = (BlockState)state.func_206870_a((Property)ModBlockStateProperties.ON, (Comparable)Boolean.valueOf(true));
                        world.func_175656_a(pos, updated);
                        world.func_205220_G_().func_205360_a(pos, (Object)this, 0);
                    } else {
                        BlockState updated = (BlockState)state.func_206870_a((Property)ModBlockStateProperties.ON, (Comparable)Boolean.valueOf(false));
                        world.func_175656_a(pos, updated);
                    }
                }
            }
        } else {
            ElectronicBellBlock.func_220075_c((BlockState)state, (World)world, (BlockPos)pos);
            world.func_217377_a(pos, bool);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rando) {
        if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u)).booleanValue() || ((Boolean)state.func_177229_b((Property)ModBlockStateProperties.ON)).booleanValue()) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, 8);
            world.func_184133_a(null, pos, (SoundEvent)SignsAndSignals.SOUNDS.get("block.safetran_type_3_electronic_bell.ring"), SoundCategory.BLOCKS, 2.0f, 1.0f);
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldReader, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        return Block.func_220055_a((IWorldReader)worldReader, (BlockPos)blockpos, (Direction)Direction.DOWN);
    }

    public VoxelShape func_230335_e_(BlockState state, IBlockReader WorldIn, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    public void screw(ItemUseContext use) {
        World world = use.func_195991_k();
        BlockPos pos = use.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        BlockState updated = (BlockState)state.func_235896_a_((Property)ModBlockStateProperties.BEFORE_ONLY);
        Optional<CompoundNBT> data = INBTTunnel.Block.tryGetData(world, pos.func_177977_b());
        boolean start = data.map(d -> d.func_74767_n("Start")).orElse(false);
        boolean run = data.map(d -> d.func_74767_n("Run")).orElse(false);
        boolean on = (Boolean)updated.func_177229_b((Property)ModBlockStateProperties.BEFORE_ONLY) != false ? start ^ run : start;
        world.func_175656_a(pos, (BlockState)updated.func_206870_a((Property)ModBlockStateProperties.ON, (Comparable)Boolean.valueOf(on)));
        world.func_205220_G_().func_205360_a(pos, (Object)this, 0);
    }
}

