/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.packets;

import java.io.File;
import java.io.IOException;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;
import xerca.xercapaint.common.XercaPaint;
import xerca.xercapaint.common.packets.ImportPaintingPacket;
import xerca.xercapaint.common.packets.ImportPaintingSendPacket;

public class ImportPaintingPacketHandler {
    public static void handle(ImportPaintingPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ctx.get().enqueueWork(() -> ImportPaintingPacketHandler.processMessage(message));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void processMessage(ImportPaintingPacket msg) {
        String filename = msg.getName() + ".paint";
        String filepath = "paintings/" + filename;
        try {
            CompoundNBT tag = CompressedStreamTools.func_74797_a((File)new File(filepath));
            ImportPaintingSendPacket pack = new ImportPaintingSendPacket(tag);
            XercaPaint.NETWORK_HANDLER.sendToServer((Object)pack);
        }
        catch (IOException e) {
            e.printStackTrace();
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("xercapaint.import.fail.4", new Object[]{filepath}).func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
        }
    }
}

