/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.packets;

import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.fml.network.NetworkEvent;
import xerca.xercapaint.common.XercaPaint;
import xerca.xercapaint.common.entity.EntityEasel;
import xerca.xercapaint.common.item.ItemCanvas;
import xerca.xercapaint.common.item.ItemPalette;
import xerca.xercapaint.common.packets.CanvasMiniUpdatePacket;

public class CanvasMiniUpdatePacketHandler {
    public static void handle(CanvasMiniUpdatePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.get().getSender();
        if (sendingPlayer == null) {
            System.err.println("EntityPlayerMP was null when CanvasUpdatePacket was received");
            return;
        }
        ctx.get().enqueueWork(() -> CanvasMiniUpdatePacketHandler.processMessage(message, sendingPlayer));
        ctx.get().setPacketHandled(true);
    }

    private static void processMessage(CanvasMiniUpdatePacket msg, ServerPlayerEntity pl) {
        ItemStack canvas;
        Entity entityEasel = null;
        if (msg.getEaselId() > -1) {
            entityEasel = pl.field_70170_p.func_73045_a(msg.getEaselId());
            if (entityEasel == null) {
                XercaPaint.LOGGER.error("CanvasMiniUpdatePacket: Easel entity not found! easelId: " + msg.getEaselId());
                return;
            }
            if (!(entityEasel instanceof EntityEasel)) {
                XercaPaint.LOGGER.error("CanvasMiniUpdatePacket: Entity found is not an easel! easelId: " + msg.getEaselId());
                return;
            }
            EntityEasel easel = (EntityEasel)entityEasel;
            canvas = easel.getItem();
            if (!(canvas.func_77973_b() instanceof ItemCanvas)) {
                XercaPaint.LOGGER.error("CanvasMiniUpdatePacket: Canvas not found inside easel!");
                return;
            }
        } else {
            canvas = pl.func_184614_ca();
            ItemStack palette = pl.func_184592_cb();
            if (canvas.func_77973_b() instanceof ItemPalette) {
                ItemStack temp = canvas;
                canvas = palette;
                ItemStack itemStack = temp;
            }
        }
        if (!canvas.func_190926_b() && canvas.func_77973_b() instanceof ItemCanvas) {
            CompoundNBT comp = canvas.func_196082_o();
            comp.func_74783_a("pixels", msg.getPixels());
            comp.func_74778_a("name", msg.getName());
            comp.func_74768_a("v", msg.getVersion());
            comp.func_74768_a("generation", 0);
            if (entityEasel instanceof EntityEasel) {
                EntityEasel easel = (EntityEasel)entityEasel;
                easel.setItem(canvas, false);
            }
            XercaPaint.LOGGER.debug("Handling canvas update: Name: " + msg.getName() + " V: " + msg.getVersion());
        }
    }
}

