/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.item;

import io.netty.util.internal.StringUtil;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.HangingEntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.system.NonnullDefault;
import xerca.xercapaint.client.CanvasItemRenderer;
import xerca.xercapaint.client.ClientStuff;
import xerca.xercapaint.common.CanvasType;
import xerca.xercapaint.common.entity.Entities;
import xerca.xercapaint.common.entity.EntityCanvas;
import xerca.xercapaint.common.item.Items;

@NonnullDefault
public class ItemCanvas
extends HangingEntityItem {
    private CanvasType canvasType;

    ItemCanvas(String name, CanvasType canvasType) {
        super(Entities.CANVAS, new Item.Properties().func_200916_a((ItemGroup)Items.paintTab).func_200917_a(1).setISTER(() -> new Callable<ItemStackTileEntityRenderer>(){
            @Nullable
            CanvasItemRenderer r = null;

            @Override
            public ItemStackTileEntityRenderer call() {
                if (this.r == null) {
                    this.r = new CanvasItemRenderer();
                }
                return this.r;
            }
        }));
        this.setRegistryName(name);
        this.canvasType = canvasType;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, @Nonnull Hand hand) {
        if (worldIn.field_72995_K) {
            ClientStuff.showCanvasGui(playerIn);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(hand));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        Direction direction = context.func_196000_l();
        BlockPos pos = blockpos.func_177972_a(direction);
        PlayerEntity playerentity = context.func_195999_j();
        ItemStack itemstack = context.func_195996_i();
        if (playerentity != null && !this.func_200127_a(playerentity, direction, itemstack, pos)) {
            if (playerentity.field_70170_p.field_72995_K) {
                ClientStuff.showCanvasGui(playerentity);
            }
        } else {
            EntityCanvas entityCanvas;
            World world = context.func_195991_k();
            CompoundNBT tag = itemstack.func_77978_p();
            if (tag == null || !tag.func_74764_b("pixels") || !tag.func_74764_b("name")) {
                if (world.field_72995_K && playerentity != null) {
                    ClientStuff.showCanvasGui(playerentity);
                }
                return ActionResultType.SUCCESS;
            }
            int rotation = 0;
            if (direction.func_176740_k() == Direction.Axis.Y) {
                double xDiff = (double)blockpos.func_177958_n() - playerentity.func_226277_ct_();
                double zDiff = (double)blockpos.func_177952_p() - playerentity.func_226281_cx_();
                rotation = Math.abs(xDiff) > Math.abs(zDiff) ? (xDiff > 0.0 ? 1 : 3) : (zDiff > 0.0 ? 2 : 0);
                if (direction == Direction.DOWN && Math.abs(xDiff) < Math.abs(zDiff)) {
                    rotation += 2;
                }
            }
            if (!world.field_72995_K && (entityCanvas = new EntityCanvas(world, tag, pos, direction, this.canvasType, rotation)).func_70518_d()) {
                entityCanvas.func_184523_o();
                world.func_217376_c((Entity)entityCanvas);
                itemstack.func_190918_g(1);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public static boolean hasTitle(@Nonnull ItemStack stack) {
        CompoundNBT tag;
        if (stack.func_77942_o() && (tag = stack.func_77978_p()) != null) {
            String s = tag.func_74779_i("title");
            return !StringUtil.isNullOrEmpty((String)s);
        }
        return false;
    }

    public static ITextComponent getFullLabel(@Nonnull ItemStack stack) {
        String labelString = "";
        int generation = 0;
        ITextComponent title = ItemCanvas.getCustomTitle(stack);
        if (title != null) {
            labelString = labelString + title.getString() + " ";
        }
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_77978_p();
            String s = tag.func_74779_i("author");
            if (!StringUtil.isNullOrEmpty((String)s)) {
                labelString = labelString + new TranslationTextComponent("canvas.byAuthor", new Object[]{s}).getString() + " ";
            }
            generation = tag.func_74762_e("generation");
        }
        StringTextComponent label = new StringTextComponent(labelString);
        if (generation == 1) {
            label.func_240699_a_(TextFormatting.YELLOW);
        } else if (generation >= 3) {
            label.func_240699_a_(TextFormatting.GRAY);
        }
        return label;
    }

    @Nullable
    public static ITextComponent getCustomTitle(@Nonnull ItemStack stack) {
        String s;
        CompoundNBT tag;
        if (stack.func_77942_o() && (tag = stack.func_77978_p()) != null && !StringUtil.isNullOrEmpty((String)(s = tag.func_74779_i("title")))) {
            return new StringTextComponent(s);
        }
        return null;
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        ITextComponent comp = ItemCanvas.getCustomTitle(stack);
        if (comp != null) {
            return comp;
        }
        return super.func_200295_i(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            int generation;
            CompoundNBT tag = stack.func_77978_p();
            String s = tag.func_74779_i("author");
            if (!StringUtils.func_151246_b((String)s)) {
                tooltip.add((ITextComponent)new TranslationTextComponent("canvas.byAuthor", new Object[]{s}));
            }
            if ((generation = tag.func_74762_e("generation")) > 0) {
                tooltip.add((ITextComponent)new TranslationTextComponent("canvas.generation." + (generation - 1)).func_240699_a_(TextFormatting.GRAY));
            }
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("canvas.empty").func_240699_a_(TextFormatting.GRAY));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        CompoundNBT tag;
        if (stack.func_77942_o() && (tag = stack.func_77978_p()) != null) {
            int generation = tag.func_74762_e("generation");
            return generation > 0;
        }
        return false;
    }

    public int getWidth() {
        return CanvasType.getWidth(this.canvasType);
    }

    public int getHeight() {
        return CanvasType.getHeight(this.canvasType);
    }

    public CanvasType getCanvasType() {
        return this.canvasType;
    }

    protected boolean func_200127_a(PlayerEntity playerIn, Direction directionIn, ItemStack itemStackIn, BlockPos posIn) {
        if (this.canvasType == CanvasType.SMALL) {
            return !World.func_189509_E((BlockPos)posIn) && playerIn.func_175151_a(posIn, directionIn, itemStackIn);
        }
        return !directionIn.func_176740_k().func_200128_b() && playerIn.func_175151_a(posIn, directionIn, itemStackIn);
    }
}

