/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.entity;

import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;
import xerca.xercapaint.common.XercaPaint;
import xerca.xercapaint.common.entity.Entities;
import xerca.xercapaint.common.item.ItemCanvas;
import xerca.xercapaint.common.item.ItemPalette;
import xerca.xercapaint.common.item.Items;
import xerca.xercapaint.common.packets.CloseGuiPacket;
import xerca.xercapaint.common.packets.OpenGuiPacket;

public class EntityEasel
extends Entity {
    private static final DataParameter<ItemStack> DATA_CANVAS = EntityDataManager.func_187226_a(EntityEasel.class, (IDataSerializer)DataSerializers.field_187196_f);
    private PlayerEntity painter = null;
    private Runnable dropDeferred = null;
    private int dropWaitTicks = 0;

    public EntityEasel(World world) {
        super(Entities.EASEL, world);
    }

    public EntityEasel(EntityType<EntityEasel> entityCanvasEntityType, World world) {
        super(entityCanvasEntityType, world);
    }

    public EntityEasel(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super(Entities.EASEL, world);
    }

    public void setPainter(PlayerEntity painter) {
        this.painter = painter;
    }

    public PlayerEntity getPainter() {
        return this.painter;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70097_a(DamageSource damageSource, float p_31580_) {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            if (!this.getItem().func_190926_b() && !damageSource.func_94541_c()) {
                this.dropItem(damageSource.func_76346_g(), false);
            } else {
                this.dropItem(damageSource.func_76346_g());
                this.func_174812_G();
            }
        }
        return false;
    }

    private void showBreakingParticles() {
        if (this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_196666_p.func_176223_P()), this.func_226277_ct_(), this.func_226283_e_(0.6666666666666666), this.func_226281_cx_(), 10, (double)(this.func_213311_cf() / 4.0f), (double)(this.func_213302_cg() / 4.0f), (double)(this.func_213311_cf() / 4.0f), 0.05);
        }
    }

    public void func_174812_G() {
        this.showBreakingParticles();
        this.func_70106_y();
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(DATA_CANVAS, (Object)ItemStack.field_190927_a);
    }

    public void dropItem(@Nullable Entity entity) {
        this.dropItem(entity, true);
    }

    private void dropItem(@Nullable Entity entity, boolean dropSelf) {
        if (this.painter != null) {
            if (!this.field_70170_p.field_72995_K && this.dropDeferred == null) {
                CloseGuiPacket pack = new CloseGuiPacket();
                XercaPaint.NETWORK_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)this.painter), (Object)pack);
                this.dropDeferred = () -> this.doDrop(entity, dropSelf);
            }
        } else {
            this.doDrop(entity, dropSelf);
        }
    }

    public void doDrop(@Nullable Entity entity, boolean dropSelf) {
        PlayerEntity player;
        ItemStack canvasStack = this.getItem();
        this.setItem(ItemStack.field_190927_a);
        if (!canvasStack.func_190926_b()) {
            canvasStack = canvasStack.func_77946_l();
            this.func_199701_a_(canvasStack);
        }
        if (entity instanceof PlayerEntity && (player = (PlayerEntity)entity).func_184812_l_()) {
            return;
        }
        if (dropSelf && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            this.func_199701_a_(this.getEaselItemStack());
        }
    }

    public ItemStack getItem() {
        return (ItemStack)this.func_184212_Q().func_187225_a(DATA_CANVAS);
    }

    public void setItem(ItemStack itemStack) {
        this.setItem(itemStack, true);
    }

    public void setItem(ItemStack itemStack, boolean makeSound) {
        if (!itemStack.func_190926_b()) {
            itemStack = itemStack.func_77946_l();
            itemStack.func_190920_e(1);
            itemStack.func_234695_a_((Entity)this);
        }
        this.func_184212_Q().func_187227_b(DATA_CANVAS, (Object)itemStack);
        if (makeSound) {
            if (!itemStack.func_190926_b()) {
                this.func_184185_a(SoundEvents.field_187694_dK, 1.0f, 1.0f);
            } else {
                this.func_184185_a(SoundEvents.field_187691_dJ, 1.0f, 1.0f);
            }
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_184206_a(DataParameter<?> accessor) {
        ItemStack itemStack;
        super.func_184206_a(accessor);
        if (accessor.equals(DATA_CANVAS) && !(itemStack = this.getItem()).func_190926_b() && itemStack.func_234694_A_() != this) {
            itemStack.func_234695_a_((Entity)this);
        }
    }

    public void func_213281_b(CompoundNBT tag) {
        if (!this.getItem().func_190926_b()) {
            tag.func_218657_a("Item", (INBT)this.getItem().func_77955_b(new CompoundNBT()));
        }
    }

    public void func_70037_a(CompoundNBT tag) {
        CompoundNBT itemTag = tag.func_74775_l("Item");
        if (itemTag != null && !itemTag.isEmpty()) {
            ItemStack var3 = ItemStack.func_199557_a((CompoundNBT)itemTag);
            if (var3.func_190926_b()) {
                field_184243_a.warn("Unable to load item from: {}", (Object)itemTag);
            }
            this.setItem(var3, false);
        }
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        ItemStack itemInHand = player.func_184586_b(hand);
        boolean isEaselFilled = !this.getItem().func_190926_b();
        boolean handHoldsCanvas = itemInHand.func_77973_b() instanceof ItemCanvas;
        boolean handHoldsPalette = itemInHand.func_77973_b() instanceof ItemPalette;
        if (this.field_70170_p.field_72995_K) {
            return !isEaselFilled && !handHoldsCanvas ? ActionResultType.PASS : ActionResultType.SUCCESS;
        }
        if (!isEaselFilled) {
            if (handHoldsCanvas && this.func_70089_S()) {
                this.setItem(itemInHand);
                itemInHand.func_190918_g(1);
            }
        } else {
            boolean unused = this.painter == null;
            boolean toEdit = handHoldsPalette && (!this.getItem().func_77942_o() || this.getItem().func_77978_p().func_74762_e("generation") <= 0);
            boolean allowed = unused || !toEdit;
            OpenGuiPacket pack = new OpenGuiPacket(this.func_145782_y(), allowed, toEdit, hand);
            XercaPaint.NETWORK_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)pack);
            if (toEdit && allowed) {
                this.painter = player;
            }
        }
        return ActionResultType.CONSUME;
    }

    protected ItemStack getEaselItemStack() {
        return new ItemStack((IItemProvider)Items.ITEM_EASEL);
    }

    public ItemStack getPickResult() {
        ItemStack canvas = this.getItem();
        return canvas.func_190926_b() ? this.getEaselItemStack() : canvas.func_77946_l();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_213315_a(MoverType.SELF, new Vector3d(0.0, -0.25, 0.0));
        this.func_226264_Z_();
        if (!this.field_70170_p.field_72995_K && this.dropDeferred != null && this.painter == null) {
            this.dropDeferred.run();
            this.dropDeferred = null;
        }
        if (this.painter != null && !this.painter.func_70089_S()) {
            this.painter = null;
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_184201_a(EquipmentSlotType equipmentSlot, ItemStack itemStack) {
    }
}

