/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.entity;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.RedstoneDiodeBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.commons.lang3.Validate;
import xerca.xercapaint.common.CanvasType;
import xerca.xercapaint.common.XercaPaint;
import xerca.xercapaint.common.entity.Entities;
import xerca.xercapaint.common.item.Items;
import xerca.xercapaint.common.packets.PictureRequestPacket;

public class EntityCanvas
extends HangingEntity
implements IEntityAdditionalSpawnData {
    private String canvasName;
    private String canvasTitle;
    private String canvasAuthor;
    private int canvasVersion;
    private int canvasGeneration = 0;
    private boolean canvasSigned;
    private int tickCounter1 = 0;
    private CanvasType canvasType;
    private static final DataParameter<Integer> ROTATION = EntityDataManager.func_187226_a(EntityCanvas.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final Map<String, Picture> PICTURES = Maps.newHashMap();
    public static final Set<String> PICTURE_REQUESTS = Sets.newHashSet();

    public EntityCanvas(World world, CompoundNBT canvasNBT, BlockPos pos, Direction facing, CanvasType canvasType, int rotation) {
        super(Entities.CANVAS, world, pos);
        this.canvasName = canvasNBT.func_74779_i("name");
        this.canvasVersion = canvasNBT.func_74762_e("v");
        if (canvasNBT.func_74764_b("title") && canvasNBT.func_74764_b("author")) {
            this.canvasSigned = true;
            this.canvasTitle = canvasNBT.func_74779_i("title");
            this.canvasAuthor = canvasNBT.func_74779_i("author");
            this.canvasGeneration = canvasNBT.func_74762_e("generation");
        } else {
            this.canvasSigned = false;
        }
        this.canvasType = canvasType;
        this.setRotation(rotation);
        this.func_174859_a(facing);
        Picture picture = PICTURES.get(this.canvasName);
        if (picture == null || picture.version < this.canvasVersion) {
            PICTURES.put(this.canvasName, new Picture(this.canvasVersion, canvasNBT.func_74759_k("pixels")));
        }
    }

    public EntityCanvas(EntityType<EntityCanvas> entityCanvasEntityType, World world) {
        super(entityCanvasEntityType, world);
    }

    public EntityCanvas(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super(Entities.CANVAS, world);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(ROTATION, (Object)0);
    }

    public int func_82329_d() {
        return CanvasType.getWidth(this.canvasType);
    }

    public int func_82330_g() {
        return CanvasType.getHeight(this.canvasType);
    }

    protected float func_213316_a(Pose poseIn, EntitySize sizeIn) {
        return 0.0f;
    }

    public String getCanvasName() {
        return this.canvasName;
    }

    public int getCanvasVersion() {
        return this.canvasVersion;
    }

    public void func_110128_b(@Nullable Entity brokenEntity) {
        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            Picture picture;
            ItemStack canvasItem;
            this.func_184185_a(SoundEvents.field_187691_dJ, 1.0f, 1.0f);
            if (brokenEntity instanceof PlayerEntity) {
                PlayerEntity playerentity = (PlayerEntity)brokenEntity;
                if (playerentity.field_71075_bZ.field_75098_d) {
                    return;
                }
            }
            if (this.canvasType == CanvasType.SMALL) {
                canvasItem = new ItemStack((IItemProvider)Items.ITEM_CANVAS);
            } else if (this.canvasType == CanvasType.LARGE) {
                canvasItem = new ItemStack((IItemProvider)Items.ITEM_CANVAS_LARGE);
            } else if (this.canvasType == CanvasType.LONG) {
                canvasItem = new ItemStack((IItemProvider)Items.ITEM_CANVAS_LONG);
            } else if (this.canvasType == CanvasType.TALL) {
                canvasItem = new ItemStack((IItemProvider)Items.ITEM_CANVAS_TALL);
            } else {
                XercaPaint.LOGGER.error("Invalid canvas type");
                return;
            }
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74778_a("name", this.canvasName);
            nbt.func_74768_a("v", this.canvasVersion);
            nbt.func_74768_a("generation", 0);
            if (this.canvasSigned) {
                nbt.func_74778_a("author", this.canvasAuthor);
                nbt.func_74778_a("title", this.canvasTitle);
                nbt.func_74768_a("generation", this.canvasGeneration);
            }
            if ((picture = PICTURES.get(this.canvasName)) != null) {
                nbt.func_74783_a("pixels", picture.pixels);
            }
            canvasItem.func_77982_d(nbt);
            this.func_199701_a_(canvasItem);
        }
    }

    public void func_70071_h_() {
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        if (this.tickCounter1++ == 50 && !this.field_70170_p.field_72995_K) {
            this.tickCounter1 = 0;
            if (this.func_70089_S() && !this.func_70518_d()) {
                this.func_70106_y();
                this.func_110128_b(null);
            }
        }
    }

    public void func_184523_o() {
        this.func_184185_a(SoundEvents.field_187694_dK, 1.0f, 1.0f);
    }

    protected void func_174859_a(Direction facingDirectionIn) {
        Validate.notNull((Object)facingDirectionIn);
        this.field_174860_b = facingDirectionIn;
        if (facingDirectionIn.func_176740_k().func_176722_c()) {
            this.field_70125_A = 0.0f;
            this.field_70177_z = this.field_174860_b.func_176736_b() * 90;
        } else {
            this.field_70125_A = -90 * facingDirectionIn.func_176743_c().func_179524_a();
            this.field_70177_z = 0.0f;
        }
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        this.func_174856_o();
    }

    private double offs(int l) {
        return l % 32 == 0 ? 0.5 : 0.0;
    }

    protected void func_174856_o() {
        if (this.canvasType != null && this.field_174860_b != null) {
            double d1 = (double)this.field_174861_a.func_177958_n() + 0.5 - (double)this.field_174860_b.func_82601_c() * 0.46875;
            double d2 = (double)this.field_174861_a.func_177956_o() + 0.5 - (double)this.field_174860_b.func_96559_d() * 0.46875;
            double d3 = (double)this.field_174861_a.func_177952_p() + 0.5 - (double)this.field_174860_b.func_82599_e() * 0.46875;
            if (this.field_174860_b.func_176740_k().func_176722_c()) {
                double d4 = this.offs(this.func_82329_d());
                double d5 = this.offs(this.func_82330_g());
                d2 += d5;
                Direction direction = this.field_174860_b.func_176735_f();
                d1 += d4 * (double)direction.func_82601_c();
                d3 += d4 * (double)direction.func_82599_e();
            }
            this.func_226288_n_(d1, d2, d3);
            double d6 = this.func_82329_d() - 2;
            double d7 = this.func_82330_g() - 2;
            double d8 = this.func_82329_d() - 2;
            Direction.Axis direction$axis = this.field_174860_b.func_176740_k();
            switch (direction$axis) {
                case X: {
                    d6 = 1.0;
                    break;
                }
                case Y: {
                    d7 = 1.0;
                    break;
                }
                case Z: {
                    d8 = 1.0;
                }
            }
            this.func_174826_a(new AxisAlignedBB(d1 - (d6 /= 32.0), d2 - (d7 /= 32.0), d3 - (d8 /= 32.0), d1 + d6, d2 + d7, d3 + d8));
        }
    }

    public boolean func_70518_d() {
        if (this.field_174860_b.func_176740_k().func_176722_c()) {
            return super.func_70518_d();
        }
        if (!this.field_70170_p.func_226669_j_((Entity)this)) {
            return false;
        }
        BlockState blockstate = this.field_70170_p.func_180495_p(this.field_174861_a.func_177972_a(this.field_174860_b.func_176734_d()));
        return blockstate.func_185904_a().func_76220_a() || this.field_174860_b.func_176740_k().func_176722_c() && RedstoneDiodeBlock.func_185546_B((BlockState)blockstate) ? this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), field_184524_c).isEmpty() : false;
    }

    public int getRotation() {
        return (Integer)this.func_184212_Q().func_187225_a(ROTATION);
    }

    private void setRotation(int rotation) {
        this.func_184212_Q().func_187227_b(ROTATION, (Object)(rotation % 4));
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70037_a(CompoundNBT tagCompound) {
        Picture picture;
        this.field_174861_a = new BlockPos(tagCompound.func_74762_e("TileX"), tagCompound.func_74762_e("TileY"), tagCompound.func_74762_e("TileZ"));
        CompoundNBT canvasNBT = tagCompound;
        if (tagCompound.func_74764_b("canvas")) {
            canvasNBT = tagCompound.func_74775_l("canvas");
        }
        this.canvasSigned = canvasNBT.func_74764_b("author") && canvasNBT.func_74764_b("title");
        this.canvasName = canvasNBT.func_74779_i("name");
        this.canvasVersion = canvasNBT.func_74762_e("v");
        if (this.canvasSigned) {
            this.canvasAuthor = canvasNBT.func_74779_i("author");
            this.canvasTitle = canvasNBT.func_74779_i("title");
            this.canvasGeneration = canvasNBT.func_74762_e("generation");
        }
        if ((picture = PICTURES.get(this.canvasName)) == null || picture.version < this.canvasVersion) {
            PICTURES.put(this.canvasName, new Picture(this.canvasVersion, canvasNBT.func_74759_k("pixels")));
        }
        this.canvasType = CanvasType.fromByte(tagCompound.func_74771_c("ctype"));
        if (tagCompound.func_74764_b("Facing") && !tagCompound.func_74764_b("RealFace")) {
            byte facing = tagCompound.func_74771_c("Facing");
            Direction horizontal = Direction.func_176731_b((int)facing);
            this.func_174859_a(horizontal);
        } else {
            this.func_174859_a(Direction.func_82600_a((int)tagCompound.func_74771_c("RealFace")));
        }
        this.setRotation(tagCompound.func_74771_c("Rotation"));
    }

    public void func_213281_b(CompoundNBT tagCompound) {
        BlockPos blockpos = this.func_174857_n();
        tagCompound.func_74768_a("TileX", blockpos.func_177958_n());
        tagCompound.func_74768_a("TileY", blockpos.func_177956_o());
        tagCompound.func_74768_a("TileZ", blockpos.func_177952_p());
        tagCompound.func_74778_a("name", this.canvasName);
        tagCompound.func_74768_a("v", this.canvasVersion);
        if (this.canvasSigned) {
            tagCompound.func_74778_a("author", this.canvasAuthor);
            tagCompound.func_74778_a("title", this.canvasTitle);
            tagCompound.func_74768_a("generation", this.canvasGeneration);
        }
        tagCompound.func_74774_a("ctype", (byte)this.canvasType.ordinal());
        tagCompound.func_74774_a("RealFace", (byte)this.field_174860_b.func_176745_a());
        tagCompound.func_74774_a("Rotation", (byte)this.getRotation());
        Picture picture = PICTURES.get(this.canvasName);
        if (picture != null) {
            tagCompound.func_74783_a("pixels", picture.pixels);
        }
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_180714_a(this.canvasName);
        buffer.writeInt(this.canvasVersion);
        buffer.writeInt(this.field_174860_b.func_176745_a());
        buffer.writeByte(this.canvasType.ordinal());
        buffer.func_179255_a(this.field_174861_a);
        buffer.writeByte((int)((byte)this.getRotation()));
    }

    private void requestPicture() {
        if (!PICTURE_REQUESTS.contains(this.canvasName)) {
            PICTURE_REQUESTS.add(this.canvasName);
            PictureRequestPacket pack = new PictureRequestPacket(this.canvasName);
            XercaPaint.NETWORK_HANDLER.sendToServer((Object)pack);
        }
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.canvasName = buffer.func_218666_n();
        this.canvasVersion = buffer.readInt();
        Picture picture = PICTURES.get(this.canvasName);
        if (picture == null || picture.version < this.canvasVersion) {
            this.requestPicture();
        }
        this.field_174860_b = Direction.func_82600_a((int)buffer.readInt());
        this.canvasType = CanvasType.fromByte(buffer.readByte());
        this.field_174861_a = buffer.func_179259_c();
        this.setRotation(buffer.readByte());
        this.func_174859_a(this.field_174860_b);
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (this.canvasType == CanvasType.SMALL || this.canvasType == CanvasType.LARGE) {
            if (!this.field_70170_p.field_72995_K) {
                this.setRotation(this.getRotation() + 1);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static class Picture {
        public int version;
        public int[] pixels;

        public Picture(int version, int[] pixels) {
            this.version = version;
            this.pixels = pixels;
        }
    }
}

