/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.client;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import xerca.xercapaint.client.EaselCanvasLayer;
import xerca.xercapaint.client.EaselModel;
import xerca.xercapaint.common.entity.EntityEasel;
import xerca.xercapaint.common.item.ItemCanvas;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
public class RenderEntityEasel
extends EntityRenderer<EntityEasel>
implements IEntityRenderer<EntityEasel, EaselModel> {
    protected EaselModel model;
    protected final List<LayerRenderer<EntityEasel, EaselModel>> layers = Lists.newArrayList();
    public static RenderEntityEasel theInstance;
    private static final ResourceLocation woodTexture;

    RenderEntityEasel(EntityRendererManager manager) {
        super(manager);
        this.model = new EaselModel();
        this.layers.add(new EaselCanvasLayer(this));
    }

    public EaselModel getModel() {
        return this.model;
    }

    @Nullable
    public ResourceLocation getTextureLocation(EntityEasel entity) {
        return woodTexture;
    }

    public void render(EntityEasel entity, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-entityYaw));
        this.model.setupAnim(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        matrixStackIn.func_227863_a_(RenderEntityEasel.fromXYZDegrees(new Vector3f(0.0f, 180.0f, 0.0f)));
        matrixStackIn.func_227861_a_(0.0, -1.5, 0.0);
        RenderType rendertype = this.model.func_228282_a_(this.getTextureLocation(entity));
        IVertexBuilder vertexconsumer = bufferIn.getBuffer(rendertype);
        int i = OverlayTexture.func_229201_a_((int)OverlayTexture.func_229199_a_((float)0.0f), (int)OverlayTexture.func_229202_a_((boolean)false));
        this.model.func_225598_a_(matrixStackIn, vertexconsumer, packedLightIn, i, 1.0f, 1.0f, 1.0f, 1.0f);
        this.layers.forEach(renderlayer -> renderlayer.func_225628_a_(matrixStackIn, bufferIn, packedLightIn, (Entity)entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f));
        matrixStackIn.func_227865_b_();
        super.func_225623_a_((Entity)entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected boolean shouldShowName(EntityEasel easel) {
        RayTraceResult result = Minecraft.func_71410_x().field_71476_x;
        if (result instanceof EntityRayTraceResult) {
            EntityRayTraceResult entityHitResult = (EntityRayTraceResult)result;
            if (Minecraft.func_71382_s() && entityHitResult.func_216348_a() == easel && !easel.getItem().func_190926_b() && ItemCanvas.hasTitle(easel.getItem())) {
                double d0 = this.field_76990_c.func_229099_b_((Entity)easel);
                float f = easel.func_226273_bm_() ? 32.0f : 64.0f;
                return d0 < (double)(f * f);
            }
        }
        return false;
    }

    protected void renderNameTag(EntityEasel easel, ITextComponent component, MatrixStack poseStack, IRenderTypeBuffer bufferSource, int p_115087_) {
        poseStack.func_227860_a_();
        poseStack.func_227861_a_(0.0, -0.5, 0.0);
        super.func_225629_a_((Entity)easel, ItemCanvas.getFullLabel(easel.getItem()), poseStack, bufferSource, p_115087_);
        poseStack.func_227865_b_();
    }

    public static Quaternion fromXYZDegrees(Vector3f p_175226_) {
        return RenderEntityEasel.fromXYZ((float)Math.toRadians(p_175226_.func_195899_a()), (float)Math.toRadians(p_175226_.func_195900_b()), (float)Math.toRadians(p_175226_.func_195902_c()));
    }

    private static Quaternion fromXYZ(float p_175219_, float p_175220_, float p_175221_) {
        Quaternion quaternion = Quaternion.field_227060_a_.func_227068_g_();
        quaternion.func_195890_a(new Quaternion(0.0f, (float)Math.sin(p_175219_ / 2.0f), 0.0f, (float)Math.cos(p_175219_ / 2.0f)));
        quaternion.func_195890_a(new Quaternion((float)Math.sin(p_175220_ / 2.0f), 0.0f, 0.0f, (float)Math.cos(p_175220_ / 2.0f)));
        quaternion.func_195890_a(new Quaternion(0.0f, 0.0f, (float)Math.sin(p_175221_ / 2.0f), (float)Math.cos(p_175221_ / 2.0f)));
        return quaternion;
    }

    static {
        woodTexture = new ResourceLocation("xercapaint", "textures/block/birch_long.png");
    }

    public static class RenderEntityCanvasFactory
    implements IRenderFactory<EntityEasel> {
        public EntityRenderer<? super EntityEasel> createRenderFor(EntityRendererManager manager) {
            theInstance = new RenderEntityEasel(manager);
            return theInstance;
        }
    }
}

