/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import xerca.xercapaint.client.GuiCanvasEdit;
import xerca.xercapaint.client.GuiCanvasView;
import xerca.xercapaint.client.GuiPalette;
import xerca.xercapaint.client.RenderEntityCanvas;
import xerca.xercapaint.client.RenderEntityEasel;
import xerca.xercapaint.common.entity.Entities;
import xerca.xercapaint.common.entity.EntityEasel;
import xerca.xercapaint.common.item.ItemCanvas;
import xerca.xercapaint.common.item.ItemPalette;
import xerca.xercapaint.common.item.Items;

public class ClientStuff {
    public static void init() {
        RenderingRegistry.registerEntityRenderingHandler(Entities.CANVAS, (IRenderFactory)new RenderEntityCanvas.RenderEntityCanvasFactory());
        RenderingRegistry.registerEntityRenderingHandler(Entities.EASEL, (IRenderFactory)new RenderEntityEasel.RenderEntityCanvasFactory());
    }

    public static void showCanvasGui(EntityEasel easel, ItemStack palette) {
        ClientStuff.showCanvasGui(easel, palette, Minecraft.func_71410_x());
    }

    public static void showCanvasGui(EntityEasel easel, ItemStack palette, Minecraft minecraft) {
        ItemStack canvas = easel.getItem();
        CompoundNBT tag = canvas.func_77978_p();
        if (tag != null && tag.func_74762_e("generation") > 0 || palette.func_190926_b()) {
            minecraft.func_147108_a((Screen)new GuiCanvasView(canvas.func_77978_p(), (ITextComponent)new TranslationTextComponent("item.xercapaint.item_canvas"), ((ItemCanvas)canvas.func_77973_b()).getCanvasType(), easel));
        } else {
            minecraft.func_147108_a((Screen)new GuiCanvasEdit((PlayerEntity)minecraft.field_71439_g, canvas.func_77978_p(), palette.func_77978_p(), (ITextComponent)new TranslationTextComponent("item.xercapaint.item_canvas"), ((ItemCanvas)canvas.func_77973_b()).getCanvasType(), easel));
        }
    }

    public static void showCanvasGui(PlayerEntity player) {
        ItemStack heldItem = player.func_184614_ca();
        ItemStack offhandItem = player.func_184592_cb();
        Minecraft minecraft = Minecraft.func_71410_x();
        if (heldItem.func_190926_b() || minecraft.field_71439_g != null && !minecraft.field_71439_g.func_146103_bH().getId().equals(player.func_146103_bH().getId())) {
            return;
        }
        if (heldItem.func_77973_b() instanceof ItemCanvas) {
            CompoundNBT tag = heldItem.func_77978_p();
            if (offhandItem.func_190926_b() || !(offhandItem.func_77973_b() instanceof ItemPalette) || tag != null && tag.func_74762_e("generation") > 0) {
                minecraft.func_147108_a((Screen)new GuiCanvasView(heldItem.func_77978_p(), (ITextComponent)new TranslationTextComponent("item.xercapaint.item_canvas"), ((ItemCanvas)heldItem.func_77973_b()).getCanvasType(), null));
            } else {
                minecraft.func_147108_a((Screen)new GuiCanvasEdit((PlayerEntity)minecraft.field_71439_g, tag, offhandItem.func_77978_p(), (ITextComponent)new TranslationTextComponent("item.xercapaint.item_canvas"), ((ItemCanvas)heldItem.func_77973_b()).getCanvasType(), null));
            }
        } else if (heldItem.func_77973_b() instanceof ItemPalette) {
            if (offhandItem.func_190926_b() || !(offhandItem.func_77973_b() instanceof ItemCanvas)) {
                minecraft.func_147108_a((Screen)new GuiPalette(heldItem.func_77978_p(), (ITextComponent)new TranslationTextComponent("item.xercapaint.item_palette")));
            } else {
                CompoundNBT tag = offhandItem.func_77978_p();
                if (tag != null && tag.func_74762_e("generation") > 0) {
                    minecraft.func_147108_a((Screen)new GuiCanvasView(offhandItem.func_77978_p(), (ITextComponent)new TranslationTextComponent("item.xercapaint.item_canvas"), ((ItemCanvas)offhandItem.func_77973_b()).getCanvasType(), null));
                } else {
                    minecraft.func_147108_a((Screen)new GuiCanvasEdit((PlayerEntity)minecraft.field_71439_g, tag, heldItem.func_77978_p(), (ITextComponent)new TranslationTextComponent("item.xercapaint.item_canvas"), ((ItemCanvas)offhandItem.func_77973_b()).getCanvasType(), null));
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="xercapaint", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBusSubscriber {
        @SubscribeEvent
        public static void clientSetupHandler(FMLClientSetupEvent event) {
            IItemPropertyGetter drawn = (itemStack, p_call_2_, p_call_3_) -> {
                if (!itemStack.func_77942_o()) {
                    return 0.0f;
                }
                return 1.0f;
            };
            IItemPropertyGetter colors = (stack, p_call_2_, p_call_3_) -> (float)ItemPalette.basicColorCount(stack) / 16.0f;
            ItemModelsProperties.func_239418_a_((Item)Items.ITEM_CANVAS, (ResourceLocation)new ResourceLocation("xercapaint", "drawn"), (IItemPropertyGetter)drawn);
            ItemModelsProperties.func_239418_a_((Item)Items.ITEM_CANVAS_LARGE, (ResourceLocation)new ResourceLocation("xercapaint", "drawn"), (IItemPropertyGetter)drawn);
            ItemModelsProperties.func_239418_a_((Item)Items.ITEM_CANVAS_LONG, (ResourceLocation)new ResourceLocation("xercapaint", "drawn"), (IItemPropertyGetter)drawn);
            ItemModelsProperties.func_239418_a_((Item)Items.ITEM_CANVAS_TALL, (ResourceLocation)new ResourceLocation("xercapaint", "drawn"), (IItemPropertyGetter)drawn);
            ItemModelsProperties.func_239418_a_((Item)Items.ITEM_PALETTE, (ResourceLocation)new ResourceLocation("xercapaint", "colors"), (IItemPropertyGetter)colors);
        }
    }
}

