/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import xerca.xercapaint.client.RenderEntityCanvas;
import xerca.xercapaint.common.item.ItemCanvas;

@ParametersAreNonnullByDefault
public class CanvasItemRenderer
extends ItemStackTileEntityRenderer {
    private static final ResourceLocation backLocation = new ResourceLocation("minecraft", "textures/block/birch_planks.png");
    private static final ResourceLocation emptyCanvasLocation = new ResourceLocation("xercapaint", "textures/block/empty.png");

    public void func_239207_a_(ItemStack stack, ItemCameraTransforms.TransformType p_239207_2_, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        if (stack.func_77973_b() instanceof ItemCanvas) {
            ItemCanvas itemCanvas = (ItemCanvas)stack.func_77973_b();
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt != null && RenderEntityCanvas.theInstance != null) {
                RenderEntityCanvas.Instance canvasIns = RenderEntityCanvas.theInstance.getCanvasRendererInstance(nbt, itemCanvas.getWidth(), itemCanvas.getHeight());
                if (canvasIns != null) {
                    canvasIns.render(null, 0.0f, 0.0f, matrixStack, buffer, Direction.UP, combinedLight);
                }
            } else {
                this.renderEmptyCanvas(matrixStack, buffer, itemCanvas.getWidth(), itemCanvas.getHeight(), combinedLight);
            }
        }
    }

    private void addVertex(IVertexBuilder vb, Matrix4f m, Matrix3f mn, double x, double y, double z, float tx, float ty, int lightmap, float xOff, float yOff, float zOff) {
        vb.func_227888_a_(m, (float)x, (float)y, (float)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(tx, ty).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(lightmap).func_227887_a_(mn, xOff, yOff, zOff).func_181675_d();
    }

    private void renderEmptyCanvas(MatrixStack ms, IRenderTypeBuffer buffer, float width, float height, int packedLight) {
        float wScale = width / 16.0f;
        float hScale = height / 16.0f;
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        ms.func_227860_a_();
        Matrix3f mn = ms.func_227866_c_().func_227872_b_().func_226121_d_();
        float xOffset = Direction.UP.func_82601_c();
        float yOffset = Direction.UP.func_96559_d();
        float zOffset = Direction.UP.func_82599_e();
        ms.func_227866_c_().func_227872_b_().func_226114_a_(mn);
        float f = 0.03125f;
        ms.func_227861_a_(0.75, 0.5, 0.5);
        f = wScale > 1.0f || hScale > 1.0f ? (f /= 3.3f) : (f /= 2.0f);
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        ms.func_227862_a_(f, f, f);
        textureManager.func_110577_a(emptyCanvasLocation);
        Matrix4f m = ms.func_227866_c_().func_227870_a_();
        mn = ms.func_227866_c_().func_227872_b_();
        IVertexBuilder vb = buffer.getBuffer(RenderType.func_228634_a_((ResourceLocation)emptyCanvasLocation));
        this.addVertex(vb, m, mn, 0.0, 32.0f * hScale, -1.0, 1.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 32.0f * wScale, 32.0f * hScale, -1.0, 0.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 32.0f * wScale, 0.0, -1.0, 0.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 0.0, 0.0, -1.0, 1.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
        vb = buffer.getBuffer(RenderType.func_228634_a_((ResourceLocation)backLocation));
        float sideWidth = 0.0625f;
        textureManager.func_110577_a(emptyCanvasLocation);
        this.addVertex(vb, m, mn, 0.0, 0.0, 1.0, 0.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 32.0 * (double)wScale, 0.0, 1.0, 1.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 32.0 * (double)wScale, 32.0 * (double)hScale, 1.0, 1.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 0.0, 32.0 * (double)hScale, 1.0, 0.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 0.0, 0.0, 1.0, 0.0625f, 0.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 0.0, 32.0 * (double)hScale, 1.0, 0.0625f, 1.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 0.0, 32.0 * (double)hScale, -1.0, 0.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 0.0, 0.0, -1.0, 0.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 0.0, 32.0 * (double)hScale, 1.0, 0.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 32.0 * (double)wScale, 32.0 * (double)hScale, 1.0, 1.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 32.0 * (double)wScale, 32.0 * (double)hScale, -1.0, 1.0f, 0.0625f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 0.0, 32.0 * (double)hScale, -1.0, 0.0f, 0.0625f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 32.0 * (double)wScale, 0.0, -1.0, 0.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 32.0 * (double)wScale, 32.0 * (double)hScale, -1.0, 0.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 32.0 * (double)wScale, 32.0 * (double)hScale, 1.0, 0.0625f, 1.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 32.0 * (double)wScale, 0.0, 1.0, 0.0625f, 0.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 0.0, 0.0, -1.0, 0.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 32.0 * (double)wScale, 0.0, -1.0, 1.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 32.0 * (double)wScale, 0.0, 1.0, 1.0f, 0.9375f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 0.0, 0.0, 1.0, 0.0f, 0.9375f, packedLight, xOffset, yOffset, zOffset);
        ms.func_227865_b_();
    }
}

