/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.block;

import com.mrcrayfish.furniture.block.FurnitureHorizontalWaterloggedBlock;
import com.mrcrayfish.furniture.core.ModSounds;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class DivingBoardBlock
extends FurnitureHorizontalWaterloggedBlock {
    public static final EnumProperty<DivingBoardPart> PART = EnumProperty.func_177709_a((String)"part", DivingBoardPart.class);
    public final Map<BlockState, VoxelShape> SHAPES = new HashMap<BlockState, VoxelShape>();

    public DivingBoardBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(PART, (Comparable)((Object)DivingBoardPart.BASE))).func_206870_a((Property)DIRECTION, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private VoxelShape getShape(BlockState state) {
        return this.SHAPES.computeIfAbsent(state, state1 -> {
            VoxelShape[] BOARD = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)1.0, (double)4.0, (double)0.0, (double)15.0, (double)6.0, (double)16.0), Direction.SOUTH));
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(BOARD[((Direction)state.func_177229_b((Property)DIRECTION)).func_176736_b()]);
            if (state1.func_177229_b(PART) == DivingBoardPart.BASE) {
                VoxelShape[] BASE = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)3.0, (double)0.0, (double)2.0, (double)13.0, (double)4.0, (double)15.0), Direction.SOUTH));
                shapes.add(BASE[((Direction)state.func_177229_b((Property)DIRECTION)).func_176736_b()]);
            }
            return VoxelShapeHelper.combineAll(shapes);
        });
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return this.getShape(state);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader reader, BlockPos pos) {
        return this.getShape(state);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        Direction direction = (Direction)state.func_177229_b((Property)DIRECTION);
        DivingBoardPart part = (DivingBoardPart)((Object)state.func_177229_b(PART));
        BlockPos otherPos = part == DivingBoardPart.BASE ? pos.func_177972_a(direction) : pos.func_177972_a(direction.func_176734_d());
        BlockState otherBlockState = worldIn.func_180495_p(otherPos);
        if (otherBlockState.func_177230_c() == this && otherBlockState.func_177229_b(PART) != part) {
            worldIn.func_180501_a(otherPos, Blocks.field_150350_a.func_176223_P(), 35);
            worldIn.func_217378_a(player, 2001, otherPos, Block.func_196246_j((BlockState)otherBlockState));
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.func_180501_a(pos.func_177972_a(placer.func_174811_aO()), (BlockState)((BlockState)this.func_176223_P().func_206870_a(PART, (Comparable)((Object)DivingBoardPart.BOARD))).func_206870_a((Property)DIRECTION, (Comparable)placer.func_174811_aO()), 3);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177972_a((Direction)state.func_177229_b((Property)DIRECTION))).func_196958_f();
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (worldIn.func_180495_p(pos).func_177229_b(PART) != DivingBoardPart.BOARD) {
            return;
        }
        if (entityIn instanceof LivingEntity) {
            float strength = 5.0f;
            float maxHeight = 8.0f;
            float height = entityIn.field_70143_R * strength;
            if (height > 0.0f && !entityIn.func_225608_bj_()) {
                if (height > maxHeight - 0.25f) {
                    height = maxHeight - 0.25f;
                }
                entityIn.func_213317_d(entityIn.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
                entityIn.func_70024_g(0.0, Math.sqrt(0.22 * (double)(height + 0.25f)), 0.0);
                if (worldIn.field_72995_K) {
                    for (int i = 0; i < 5; ++i) {
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197625_r, entityIn.field_70169_q, entityIn.field_70167_r, entityIn.field_70166_s, 1.0, 1.0, 1.0);
                    }
                } else {
                    worldIn.func_184133_a(null, pos, (SoundEvent)ModSounds.BLOCK_DIVING_BOARD_BOUNCE.get(), SoundCategory.BLOCKS, 1.0f, worldIn.field_73012_v.nextFloat() * 0.1f + 1.0f);
                }
            }
            entityIn.field_70143_R = 0.0f;
        }
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
    }

    public boolean addLandingEffects(BlockState state1, ServerWorld worldserver, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{PART});
    }

    public static enum DivingBoardPart implements IStringSerializable
    {
        BASE,
        BOARD;


        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this == BASE ? "base" : "board";
        }
    }
}

