/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.glasscutter.jei;

import com.google.common.io.CharStreams;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mrcrayfish.glasscutter.item.crafting.GlasscuttingRecipe;
import com.mrcrayfish.glasscutter.jei.GlasscuttingRecipeCategory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.util.ErrorUtil;
import net.minecraft.item.DyeColor;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@JeiPlugin
public class GlassCutterJeiPlugin
implements IModPlugin {
    private GlasscuttingRecipeCategory glasscuttingCategory;
    private static final Logger LOGGER = LogManager.getLogger();

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("glasscutter", "glasscutter");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[1];
        this.glasscuttingCategory = new GlasscuttingRecipeCategory(registration.getJeiHelpers().getGuiHelper());
        iRecipeCategoryArray[0] = this.glasscuttingCategory;
        registration.addRecipeCategories(iRecipeCategoryArray);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ErrorUtil.checkNotNull((Object)this.glasscuttingCategory, (String)"glasscuttingCategory");
        registration.addRecipes(this.getGlasscuttingRecipes(), new ResourceLocation("glasscutter", "glasscutting"));
        LOGGER.debug("Added JEI Recipes.");
    }

    private List<GlasscuttingRecipe> getGlasscuttingRecipes() {
        ArrayList<GlasscuttingRecipe> recipes = new ArrayList<GlasscuttingRecipe>();
        for (String type : new String[]{"stairs", "slab", "pane"}) {
            for (DyeColor dye : DyeColor.values()) {
                String path = "data/glasscutter/recipes/cut_" + dye.toString() + "_stained_glass_to_" + dye.toString() + "_stained_glass_" + type + ".json";
                ResourceLocation resourceLocation = new ResourceLocation("glasscutter", "cut_" + dye.toString() + "_stained_glass_to_" + dye.toString() + "_stained_glass_" + type + ".json");
                this.addRecipe(recipes, resourceLocation, path);
            }
            String path = "data/glasscutter/recipes/cut_glass_to_glass_" + type + ".json";
            ResourceLocation resourceLocation = new ResourceLocation("glasscutter", "cut_glass_to_glass_" + type + ".json");
            this.addRecipe(recipes, resourceLocation, path);
        }
        String path = "data/glasscutter/recipes/cut_glass_to_glass_bottle.json";
        ResourceLocation resourceLocation = new ResourceLocation("glasscutter", "cut_glass_to_glass_bottle.json");
        this.addRecipe(recipes, resourceLocation, path);
        return recipes;
    }

    private JsonObject getObjectFromPath(String path) {
        String jsonString;
        try {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(path);
            jsonString = CharStreams.toString((Readable)new InputStreamReader(stream));
        }
        catch (IOException e) {
            LOGGER.error("Error while trying to get json object from ResourceLocation.", (Throwable)e);
            return null;
        }
        return new JsonParser().parse(jsonString).getAsJsonObject();
    }

    private void addRecipe(List<GlasscuttingRecipe> recipes, ResourceLocation resourceLocation, String path) {
        JsonObject object = this.getObjectFromPath(path);
        if (object == null) {
            return;
        }
        IRecipe recipe = RecipeManager.func_215377_a((ResourceLocation)resourceLocation, (JsonObject)object);
        if (!(recipe instanceof GlasscuttingRecipe)) {
            LOGGER.error("Wrong recipe type.");
            return;
        }
        recipes.add((GlasscuttingRecipe)recipe);
    }
}

