/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.glasscutter.inventory.container;

import com.google.common.collect.Lists;
import com.mrcrayfish.glasscutter.init.ModBlocks;
import com.mrcrayfish.glasscutter.init.ModContainers;
import com.mrcrayfish.glasscutter.item.crafting.GlasscuttingRecipe;
import com.mrcrayfish.glasscutter.item.crafting.RecipeType;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GlasscutterContainer
extends Container {
    private final IWorldPosCallable worldPosCallable;
    private final IntReferenceHolder selectedRecipe;
    private final World world;
    private List<GlasscuttingRecipe> recipes;
    private ItemStack itemStackInput;
    private long lastOnTake;
    private final Slot inputInventorySlot;
    private final Slot outputInventorySlot;
    private Runnable inventoryUpdateListener = () -> {};
    private final IInventory inputInventory;
    private final CraftResultInventory inventory;

    public GlasscutterContainer(int windowId, PlayerInventory playerInventory) {
        this(windowId, playerInventory, IWorldPosCallable.field_221489_a);
    }

    public GlasscutterContainer(int windowId, PlayerInventory playerInventory, final IWorldPosCallable callable) {
        super(ModContainers.GLASSCUTTER, windowId);
        int i;
        this.selectedRecipe = IntReferenceHolder.func_221492_a();
        this.recipes = Lists.newArrayList();
        this.itemStackInput = ItemStack.field_190927_a;
        this.inputInventory = new Inventory(1){

            public void func_70296_d() {
                super.func_70296_d();
                GlasscutterContainer.this.func_75130_a((IInventory)this);
                GlasscutterContainer.this.inventoryUpdateListener.run();
            }
        };
        this.inventory = new CraftResultInventory();
        this.worldPosCallable = callable;
        this.world = playerInventory.field_70458_d.field_70170_p;
        this.inputInventorySlot = this.func_75146_a(new Slot(this.inputInventory, 0, 20, 33));
        this.outputInventorySlot = this.func_75146_a(new Slot((IInventory)this.inventory, 1, 143, 33){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public ItemStack func_190901_a(PlayerEntity playerEntity, ItemStack stack) {
                ItemStack slotStack = GlasscutterContainer.this.inputInventorySlot.func_75209_a(1);
                if (!slotStack.func_190926_b()) {
                    GlasscutterContainer.this.updateRecipeResultSlot();
                }
                stack.func_77973_b().func_77622_d(stack, playerEntity.field_70170_p, playerEntity);
                callable.func_221486_a((world, pos) -> {
                    long gameTime = world.func_82737_E();
                    if (GlasscutterContainer.this.lastOnTake != gameTime) {
                        world.func_184133_a(null, pos, SoundEvents.field_219719_ml, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        GlasscutterContainer.this.lastOnTake = gameTime;
                    }
                });
                return super.func_190901_a(playerEntity, stack);
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)playerInventory, i, 8 + i * 18, 142));
        }
        this.func_216958_a(this.selectedRecipe);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSelectedRecipe() {
        return this.selectedRecipe.func_221495_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<GlasscuttingRecipe> getRecipeList() {
        return this.recipes;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getRecipeListSize() {
        return this.recipes.size();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasItemsInInputSlot() {
        return this.inputInventorySlot.func_75216_d() && !this.recipes.isEmpty();
    }

    public boolean func_75145_c(PlayerEntity playerEntity) {
        return GlasscutterContainer.func_216963_a((IWorldPosCallable)this.worldPosCallable, (PlayerEntity)playerEntity, (Block)ModBlocks.GLASSCUTTER);
    }

    public boolean func_75140_a(PlayerEntity playerEntity, int index) {
        if (index >= 0 && index < this.recipes.size()) {
            this.selectedRecipe.func_221494_a(index);
            this.updateRecipeResultSlot();
        }
        return true;
    }

    public void func_75130_a(IInventory inventory) {
        ItemStack stack = this.inputInventorySlot.func_75211_c();
        if (stack.func_77973_b() != this.itemStackInput.func_77973_b()) {
            this.itemStackInput = stack.func_77946_l();
            this.updateAvailableRecipes(inventory, stack);
        }
    }

    private void updateAvailableRecipes(IInventory inventory, ItemStack stack) {
        this.recipes.clear();
        this.selectedRecipe.func_221494_a(-1);
        this.outputInventorySlot.func_75215_d(ItemStack.field_190927_a);
        if (!stack.func_190926_b()) {
            this.recipes = this.world.func_199532_z().func_215370_b(RecipeType.GLASSCUTTING, inventory, this.world);
        }
    }

    private void updateRecipeResultSlot() {
        if (!this.recipes.isEmpty()) {
            GlasscuttingRecipe recipe = this.recipes.get(this.selectedRecipe.func_221495_b());
            this.outputInventorySlot.func_75215_d(recipe.func_77572_b(this.inputInventory));
        } else {
            this.outputInventorySlot.func_75215_d(ItemStack.field_190927_a);
        }
        this.func_75142_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setInventoryUpdateListener(Runnable runnable) {
        this.inventoryUpdateListener = runnable;
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return slot.field_75224_c != this.inventory && super.func_94530_a(stack, slot);
    }

    public ItemStack func_82846_b(PlayerEntity playerEntity, int index) {
        ItemStack copyStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            Item item = slotStack.func_77973_b();
            copyStack = slotStack.func_77946_l();
            if (index == 1) {
                item.func_77622_d(slotStack, playerEntity.field_70170_p, playerEntity);
                if (!this.func_75135_a(slotStack, 2, 38, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(slotStack, copyStack);
            } else if (index == 0 ? !this.func_75135_a(slotStack, 2, 38, false) : (this.world.func_199532_z().func_215371_a(RecipeType.GLASSCUTTING, (IInventory)new Inventory(new ItemStack[]{slotStack}), this.world).isPresent() ? !this.func_75135_a(slotStack, 0, 1, false) : (index < 29 ? !this.func_75135_a(slotStack, 29, 38, false) : index < 38 && !this.func_75135_a(slotStack, 2, 29, false)))) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
            slot.func_75218_e();
            if (slotStack.func_190916_E() == copyStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerEntity, slotStack);
            this.func_75142_b();
        }
        return copyStack;
    }

    public void func_75134_a(PlayerEntity playerEntity) {
        super.func_75134_a(playerEntity);
        this.inventory.func_70304_b(1);
        this.worldPosCallable.func_221486_a((world, pos) -> this.func_193327_a(playerEntity, playerEntity.field_70170_p, this.inputInventory));
    }
}

