/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.integration.jei;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextProperties;
import xyz.apex.forge.fantasyfurniture.block.base.FurnitureStationBlock;
import xyz.apex.forge.fantasyfurniture.client.screen.FurnitureStationContainerScreen;
import xyz.apex.forge.fantasyfurniture.container.FurnitureStationContainer;
import xyz.apex.forge.fantasyfurniture.init.FFRegistry;
import xyz.apex.forge.fantasyfurniture.init.FurnitureStation;
import xyz.apex.forge.fantasyfurniture.integration.jei.FurnitureStationRecipeCategory;
import xyz.apex.forge.fantasyfurniture.integration.jei.FurnitureStationRecipes;

@JeiPlugin
public final class JeiIntegration
implements IModPlugin {
    private static final FFRegistry REGISTRY = FFRegistry.getInstance();
    private static final ResourceLocation PLUGIN_ID = REGISTRY.id("jei_integration");
    public static final ResourceLocation FURNITURE_STATION_RECIPES = REGISTRY.id("recipes/furniture_station");

    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jei = registration.getJeiHelpers();
        registration.addRecipeCategories(new IRecipeCategory[]{new FurnitureStationRecipeCategory(jei)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        IJeiHelpers jei = registration.getJeiHelpers();
        List<ItemStack> results = FurnitureStation.getCraftingResults();
        Set<FurnitureStationRecipes> recipes = Collections.singleton(new FurnitureStationRecipes(results, jei));
        registration.addRecipes(recipes, FURNITURE_STATION_RECIPES);
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(FurnitureStationContainer.class, FURNITURE_STATION_RECIPES, 0, 3, 4, 36);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        int x = 6;
        int y = 8;
        int w = font.func_238414_a_((ITextProperties)((FurnitureStationBlock)FurnitureStation.BLOCK.asBlock()).func_235333_g_());
        font.getClass();
        int h = 9;
        int padding = 2;
        registration.addRecipeClickArea(FurnitureStationContainerScreen.class, x - padding, y - padding, w + padding * 2, h + padding * 2, new ResourceLocation[]{FURNITURE_STATION_RECIPES});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)FurnitureStation.BLOCK.asItemStack(), new ResourceLocation[]{FURNITURE_STATION_RECIPES});
    }
}

