/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.init;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.SmithingRecipeBuilder;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.player.PlayerEvent;
import xyz.apex.forge.apexcore.lib.block.BlockHelper;
import xyz.apex.forge.apexcore.lib.net.AbstractPacket;
import xyz.apex.forge.apexcore.lib.util.EventBusHelper;
import xyz.apex.forge.fantasyfurniture.FantasyFurniture;
import xyz.apex.forge.fantasyfurniture.block.base.FurnitureStationBlock;
import xyz.apex.forge.fantasyfurniture.block.entity.FurnitureStationBlockEntity;
import xyz.apex.forge.fantasyfurniture.client.screen.FurnitureStationContainerScreen;
import xyz.apex.forge.fantasyfurniture.container.FurnitureStationContainer;
import xyz.apex.forge.fantasyfurniture.init.FFRegistry;
import xyz.apex.forge.fantasyfurniture.init.FurnitureSet;
import xyz.apex.forge.fantasyfurniture.init.Registrations;
import xyz.apex.forge.fantasyfurniture.net.SyncFurnitureStationResultsPacket;
import xyz.apex.forge.utility.registrator.AbstractRegistrator;
import xyz.apex.forge.utility.registrator.builder.BlockBuilder;
import xyz.apex.forge.utility.registrator.entry.BlockEntityEntry;
import xyz.apex.forge.utility.registrator.entry.BlockEntry;
import xyz.apex.forge.utility.registrator.entry.ContainerEntry;
import xyz.apex.forge.utility.registrator.entry.ItemEntry;
import xyz.apex.java.utility.Lazy;
import xyz.apex.repack.com.tterrag.registrate.providers.ProviderType;
import xyz.apex.repack.com.tterrag.registrate.providers.RegistrateRecipeProvider;
import xyz.apex.repack.com.tterrag.registrate.util.DataIngredient;

public final class FurnitureStation {
    private static final FFRegistry REGISTRY = FFRegistry.getInstance();
    public static final int CLAY_SLOT = 0;
    public static final int WOOD_SLOT = 1;
    public static final int STONE_SLOT = 2;
    public static final int RESULT_SLOT = 3;
    public static final BlockEntry<FurnitureStationBlock> BLOCK = FurnitureStation.block();
    public static final ItemEntry<BlockItem> BLOCK_ITEM = Registrations.blockItem(BLOCK);
    public static final BlockEntityEntry<FurnitureStationBlockEntity> BLOCK_ENTITY = Registrations.blockEntity(BLOCK);
    public static final ContainerEntry<FurnitureStationContainer> CONTAINER = FurnitureStation.container();
    private static final String TXT_ACCEPTS_ANY = "text.fantasyfurniture.recipe.accepts_any";
    private static final String TXT_ACCEPTS_ANY_ARG = "text.fantasyfurniture.recipe.accepts_any.arg";
    public static final ITag.INamedTag<Item> CRAFTABLE = REGISTRY.moddedItemTag("craftable");
    public static final ITag.INamedTag<Item> CLAY = REGISTRY.forgeItemTagOptional("clay_ball", Sets.newHashSet((Object[])new Supplier[]{() -> Items.field_151119_aD}));
    public static final ITag.INamedTag<Item> WOOD = ItemTags.field_199905_b;
    public static final ITag.INamedTag<Item> STONE = ItemTags.field_242176_ac;
    private static List<ItemStack> customCraftingResults = Lists.newArrayList();
    private static final Lazy<List<ItemStack>> preCachedResults = Lazy.of(() -> {
        FantasyFurniture.LOGGER.info("Precaching Furniture Station Crafting Results...");
        ArrayList results = Lists.newArrayList();
        customCraftingResults.stream().filter(stack -> !stack.func_190926_b()).forEach(results::add);
        for (Item item : CRAFTABLE.func_230236_b_()) {
            boolean flag = false;
            for (ItemStack result : results) {
                if (result.func_77973_b() != item) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            results.add(item.func_190903_i());
        }
        results.sort(FurnitureStation::compareItemStacks);
        return ImmutableList.copyOf((Collection)results);
    });
    private static final List<ItemStack> syncedFromServer = Lists.newArrayList();

    public static boolean isValidClay(ItemStack stack) {
        return stack.func_77973_b().func_206844_a(CLAY);
    }

    public static boolean isValidWood(ItemStack stack) {
        return stack.func_77973_b().func_206844_a(WOOD);
    }

    public static boolean isValidStone(ItemStack stack) {
        return stack.func_77973_b().func_206844_a(STONE);
    }

    public static List<ItemStack> getCraftingResults() {
        if (!syncedFromServer.isEmpty()) {
            return syncedFromServer;
        }
        return (List)preCachedResults.get();
    }

    public static ITextComponent buildAcceptsAnyComponent(ITag.INamedTag<Item> tag) {
        return new TranslationTextComponent(TXT_ACCEPTS_ANY, new Object[]{new StringTextComponent(tag.func_230234_a_().toString()).func_240699_a_(TextFormatting.ITALIC)}).func_240699_a_(TextFormatting.GRAY);
    }

    public static void registerAdditionalCraftingResult(ItemStack stack) {
        customCraftingResults.add(stack.func_77946_l());
    }

    public static void syncCraftingResultsFromServer(SyncFurnitureStationResultsPacket packet) {
        syncedFromServer.clear();
        Collections.addAll(syncedFromServer, packet.getResults());
    }

    static void bootstrap() {
        REGISTRY.addDataGenerator(ProviderType.ITEM_TAGS, provider -> provider.tag(CRAFTABLE));
        String acceptsAnyEnglish = "Accepts Any: %s";
        REGISTRY.addDataGenerator(ProviderType.LANG, provider -> provider.add(TXT_ACCEPTS_ANY, acceptsAnyEnglish));
        REGISTRY.addDataGenerator(AbstractRegistrator.LANG_EXT_PROVIDER, provider -> provider.add("en_gb", TXT_ACCEPTS_ANY, acceptsAnyEnglish));
        EventBusHelper.addListener(PlayerEvent.PlayerLoggedInEvent.class, event -> {
            PlayerEntity player = event.getPlayer();
            if (player instanceof ServerPlayerEntity) {
                FantasyFurniture.LOGGER.info("Syncing FurnitureStation results to client ('{}')...", (Object)player.func_195047_I_());
                FantasyFurniture.NETWORK.sendTo((AbstractPacket)new SyncFurnitureStationResultsPacket(), (ServerPlayerEntity)player);
            }
        });
    }

    private static int compareItemStacks(ItemStack left, ItemStack right) {
        Item leftItem = left.func_77973_b();
        Item rightItem = right.func_77973_b();
        for (FurnitureSet furnitureSet : FurnitureSet.values()) {
            boolean leftHasTag = leftItem.func_206844_a(furnitureSet.itemGroupCategoryTag);
            boolean rightHasTag = rightItem.func_206844_a(furnitureSet.itemGroupCategoryTag);
            if (leftHasTag && !rightHasTag) {
                return -1;
            }
            if (leftHasTag || !rightHasTag) continue;
            return 1;
        }
        return 0;
    }

    private static BlockEntry<FurnitureStationBlock> block() {
        return (BlockEntry)((BlockBuilder)REGISTRY.block("furniture_station", FurnitureStationBlock::new).lang("Furniture Station").lang("en_gb", "Furniture Station").initialProperties(Material.field_151575_d).strength(2.5f).sound(SoundType.field_185848_a).noOcclusion().blockState(Registrations::horizontalBlock).recipe((ctx, provider) -> SmithingRecipeBuilder.func_240502_a_((Ingredient)DataIngredient.items((IItemProvider)Items.field_221734_cc, (IItemProvider[])new Item[0]), (Ingredient)DataIngredient.tag((ITag.INamedTag)Tags.Items.LEATHER), (Item)((FurnitureStationBlock)ctx.get()).func_199767_j()).func_240503_a_("has_crafting_table", (ICriterionInstance)RegistrateRecipeProvider.hasItem((IItemProvider)Items.field_221734_cc)).func_240503_a_("has_leather", (ICriterionInstance)RegistrateRecipeProvider.hasItem((ITag)Tags.Items.LEATHER)).func_240505_a_((Consumer)provider, ctx.getId())).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model(Registrations::blockItem).build()).simpleBlockEntity(FurnitureStationBlockEntity::new).register();
    }

    private static ContainerEntry<FurnitureStationContainer> container() {
        return (ContainerEntry)REGISTRY.container("furniture_station", (containerType, windowId, playerInventory, buffer) -> new FurnitureStationContainer(containerType, windowId, playerInventory, IWorldPosCallable.field_221489_a), () -> FurnitureStationContainerScreen::new).register();
    }
}

