/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.init;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import xyz.apex.forge.fantasyfurniture.block.entity.SetBookshelfBlockEntity;
import xyz.apex.forge.fantasyfurniture.block.entity.SetChestBlockEntity;
import xyz.apex.forge.fantasyfurniture.block.entity.SetDeskBlockEntity;
import xyz.apex.forge.fantasyfurniture.block.entity.SetDrawerBlockEntity;
import xyz.apex.forge.fantasyfurniture.block.entity.SetDresserBlockEntity;
import xyz.apex.forge.fantasyfurniture.block.entity.SetWardrobeBlockEntity;
import xyz.apex.forge.fantasyfurniture.client.renderer.entity.SeatEntityRenderer;
import xyz.apex.forge.fantasyfurniture.client.screen.SetBookshelfContainerScreen;
import xyz.apex.forge.fantasyfurniture.client.screen.SetChestContainerScreen;
import xyz.apex.forge.fantasyfurniture.client.screen.SetDeskContainerScreen;
import xyz.apex.forge.fantasyfurniture.client.screen.SetDrawerContainerScreen;
import xyz.apex.forge.fantasyfurniture.client.screen.SetDresserContainerScreen;
import xyz.apex.forge.fantasyfurniture.client.screen.SetWardrobeContainerScreen;
import xyz.apex.forge.fantasyfurniture.container.SetBookshelfContainer;
import xyz.apex.forge.fantasyfurniture.container.SetChestContainer;
import xyz.apex.forge.fantasyfurniture.container.SetDeskContainer;
import xyz.apex.forge.fantasyfurniture.container.SetDrawerContainer;
import xyz.apex.forge.fantasyfurniture.container.SetDresserContainer;
import xyz.apex.forge.fantasyfurniture.container.SetWardrobeContainer;
import xyz.apex.forge.fantasyfurniture.entity.SeatEntity;
import xyz.apex.forge.fantasyfurniture.init.FFRegistry;
import xyz.apex.forge.fantasyfurniture.init.FurnitureSet;
import xyz.apex.forge.fantasyfurniture.init.Registrations;
import xyz.apex.forge.utility.registrator.entry.BlockEntityEntry;
import xyz.apex.forge.utility.registrator.entry.ContainerEntry;
import xyz.apex.forge.utility.registrator.entry.EntityEntry;
import xyz.apex.forge.utility.registrator.factory.BlockEntityFactory;
import xyz.apex.java.utility.nullness.NonnullSupplier;

public final class FFElements {
    private static final FFRegistry REGISTRY = FFRegistry.getInstance();
    public static final EntityEntry<SeatEntity> SEAT_ENTITY = (EntityEntry)REGISTRY.entity("seat", EntityClassification.MISC, SeatEntity::new).lang("Seat").lang("en_gb", "Seat").sized(0.0f, 0.0f).setCustomClientFactory((spawnEntity, level) -> new SeatEntity((World)level)).noSummon().fireImmune().immuneTo(new NonnullSupplier[]{() -> Blocks.field_150335_W, () -> Blocks.field_150353_l}).renderer(() -> SeatEntityRenderer::new).register();
    public static final ResourceLocation SMALL_STORAGE_TEXTURE = REGISTRY.id("textures/gui/container/small_storage.png");
    public static final ResourceLocation MEDIUM_STORAGE_TEXTURE = REGISTRY.id("textures/gui/container/medium_storage.png");
    public static final ResourceLocation LARGE_STORAGE_TEXTURE = REGISTRY.id("textures/gui/container/large_storage.png");
    public static final ContainerEntry<SetDrawerContainer> DRAWER_CONTAINER = Registrations.container("drawer", 3, 5, SetDrawerContainer::new, () -> SetDrawerContainerScreen::new);
    public static final BlockEntityEntry<SetDrawerBlockEntity> DRAWER_BLOCK_ENTITY;
    public static final ContainerEntry<SetChestContainer> CHEST_CONTAINER;
    public static final BlockEntityEntry<SetChestBlockEntity> CHEST_BLOCK_ENTITY;
    public static final ContainerEntry<SetDresserContainer> DRESSER_CONTAINER;
    public static final BlockEntityEntry<SetDresserBlockEntity> DRESSER_BLOCK_ENTITY;
    public static final ContainerEntry<SetDeskContainer> DESK_CONTAINER;
    public static final BlockEntityEntry<SetDeskBlockEntity> DESK_BLOCK_ENTITY;
    public static final ContainerEntry<SetWardrobeContainer> WARDROBE_CONTAINER;
    public static final BlockEntityEntry<SetWardrobeBlockEntity> WARDROBE_BLOCK_ENTITY;
    public static final ContainerEntry<SetBookshelfContainer> BOOKSHELF_CONTAINER;
    public static final BlockEntityEntry<SetBookshelfBlockEntity> BOOKSHELF_BLOCK_ENTITY;

    static void bootstrap() {
    }

    private static <BLOCK_ENTITY extends TileEntity> BlockEntityEntry<BLOCK_ENTITY> blockEntity(String registryName, BlockEntityFactory<BLOCK_ENTITY> blockEntityFactory, NonnullSupplier<Block> ... validBlocks) {
        return (BlockEntityEntry)REGISTRY.blockEntity(registryName, blockEntityFactory).validBlocks(validBlocks).register();
    }

    static {
        CHEST_CONTAINER = Registrations.container("chest", 6, 9, SetChestContainer::new, () -> SetChestContainerScreen::new);
        DRESSER_CONTAINER = Registrations.container("dresser", 3, 9, SetDresserContainer::new, () -> SetDresserContainerScreen::new);
        DESK_CONTAINER = Registrations.container("desk", 3, 5, SetDeskContainer::new, () -> SetDeskContainerScreen::new);
        WARDROBE_CONTAINER = Registrations.container("wardrobe", 6, 9, SetWardrobeContainer::new, () -> SetWardrobeContainerScreen::new);
        BOOKSHELF_CONTAINER = Registrations.container("bookshelf", 6, 9, SetBookshelfContainer::new, () -> SetBookshelfContainerScreen::new);
        ArrayList drawers = Lists.newArrayList();
        ArrayList chests = Lists.newArrayList();
        ArrayList dressers = Lists.newArrayList();
        ArrayList wardrobes = Lists.newArrayList();
        ArrayList bookshelves = Lists.newArrayList();
        ArrayList desks = Lists.newArrayList();
        for (FurnitureSet furnitureSet : FurnitureSet.values()) {
            drawers.add(() -> furnitureSet.drawerBlock.asBlock());
            chests.add(() -> furnitureSet.chestBlock.asBlock());
            dressers.add(() -> furnitureSet.dresserBlock.asBlock());
            wardrobes.add(() -> furnitureSet.wardrobeBlock.asBlock());
            bookshelves.add(() -> furnitureSet.bookshelfBlock.asBlock());
            desks.add(() -> furnitureSet.deskLeftBlock.asBlock());
            desks.add(() -> furnitureSet.deskRightBlock.asBlock());
        }
        DRAWER_BLOCK_ENTITY = FFElements.blockEntity("drawer", SetDrawerBlockEntity::new, drawers.toArray(new NonnullSupplier[0]));
        CHEST_BLOCK_ENTITY = FFElements.blockEntity("chest", SetChestBlockEntity::new, chests.toArray(new NonnullSupplier[0]));
        DRESSER_BLOCK_ENTITY = FFElements.blockEntity("dresser", SetDresserBlockEntity::new, dressers.toArray(new NonnullSupplier[0]));
        WARDROBE_BLOCK_ENTITY = FFElements.blockEntity("wardrobe", SetWardrobeBlockEntity::new, wardrobes.toArray(new NonnullSupplier[0]));
        BOOKSHELF_BLOCK_ENTITY = FFElements.blockEntity("bookshelf", SetBookshelfBlockEntity::new, bookshelves.toArray(new NonnullSupplier[0]));
        DESK_BLOCK_ENTITY = FFElements.blockEntity("desk", SetDeskBlockEntity::new, desks.toArray(new NonnullSupplier[0]));
    }
}

