/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.init;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.DatagenModLoader;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import xyz.apex.forge.apexcore.lib.block.BlockHelper;
import xyz.apex.forge.apexcore.lib.item.ItemGroupCategory;
import xyz.apex.forge.apexcore.lib.item.ItemGroupCategoryManager;
import xyz.apex.forge.apexcore.lib.item.WearableBlockItem;
import xyz.apex.forge.apexcore.lib.multiblock.MultiBlockBuilder;
import xyz.apex.forge.apexcore.lib.util.EventBusHelper;
import xyz.apex.forge.fantasyfurniture.block.base.core.IStackedBlock;
import xyz.apex.forge.fantasyfurniture.block.decorations.BerryBasketBlock;
import xyz.apex.forge.fantasyfurniture.block.decorations.BoiledCremeTreatsBlock;
import xyz.apex.forge.fantasyfurniture.block.decorations.BoltsOfClothBlock;
import xyz.apex.forge.fantasyfurniture.block.decorations.BookStackBlock;
import xyz.apex.forge.fantasyfurniture.block.decorations.BowlBlock;
import xyz.apex.forge.fantasyfurniture.block.decorations.ChalicesBlock;
import xyz.apex.forge.fantasyfurniture.block.decorations.CoinStackBlock;
import xyz.apex.forge.fantasyfurniture.block.decorations.FoodBlock;
import xyz.apex.forge.fantasyfurniture.block.decorations.MeadBottlesBlock;
import xyz.apex.forge.fantasyfurniture.block.decorations.MuffinsBlock;
import xyz.apex.forge.fantasyfurniture.block.decorations.MushroomsRedBlock;
import xyz.apex.forge.fantasyfurniture.block.decorations.PaperStackBlock;
import xyz.apex.forge.fantasyfurniture.block.decorations.PlatterBlock;
import xyz.apex.forge.fantasyfurniture.block.decorations.PotteryBlock;
import xyz.apex.forge.fantasyfurniture.block.decorations.SoulGemsBlock;
import xyz.apex.forge.fantasyfurniture.block.decorations.SweetRollsBlock;
import xyz.apex.forge.fantasyfurniture.block.decorations.TankardsBlock;
import xyz.apex.forge.fantasyfurniture.block.decorations.TeaCupsBlock;
import xyz.apex.forge.fantasyfurniture.block.decorations.TeaSetBlock;
import xyz.apex.forge.fantasyfurniture.block.decorations.TomesBlock;
import xyz.apex.forge.fantasyfurniture.block.decorations.WidowBloomBlock;
import xyz.apex.forge.fantasyfurniture.block.entity.WidowBloomBlockEntity;
import xyz.apex.forge.fantasyfurniture.client.renderer.FFItemStackBlockEntityRenderer;
import xyz.apex.forge.fantasyfurniture.client.renderer.entity.WidowBloomBlockEntityRenderer;
import xyz.apex.forge.fantasyfurniture.init.FFPatterns;
import xyz.apex.forge.fantasyfurniture.init.FFRegistry;
import xyz.apex.forge.fantasyfurniture.init.FurnitureSet;
import xyz.apex.forge.fantasyfurniture.init.FurnitureStation;
import xyz.apex.forge.fantasyfurniture.init.Registrations;
import xyz.apex.forge.utility.registrator.AbstractRegistrator;
import xyz.apex.forge.utility.registrator.builder.BlockBuilder;
import xyz.apex.forge.utility.registrator.builder.ItemBuilder;
import xyz.apex.forge.utility.registrator.entry.BlockEntityEntry;
import xyz.apex.forge.utility.registrator.entry.BlockEntry;
import xyz.apex.forge.utility.registrator.entry.ItemEntry;
import xyz.apex.repack.com.tterrag.registrate.providers.ProviderType;
import xyz.apex.repack.com.tterrag.registrate.providers.RegistrateLangProvider;

public final class Decorations {
    private static final FFRegistry REGISTRY = FFRegistry.getInstance();
    public static final ITag.INamedTag<Item> ITEM_GROUP_CATEGORY_TAG = REGISTRY.moddedItemTag("item_category/decorations");
    public static final BlockEntry<BerryBasketBlock> BERRY_BASKET_EMPTY_BLOCK = Decorations.berryBasket("empty");
    public static final ItemEntry<BlockItem> BERRY_BASKET_EMPTY_BLOCK_ITEM = Registrations.blockItem(BERRY_BASKET_EMPTY_BLOCK);
    public static final BlockEntry<BerryBasketBlock> BERRY_BASKET_SWEETBERRY_BLOCK = Decorations.berryBasket("sweetberry");
    public static final ItemEntry<BlockItem> BERRY_BASKET_SWEETBERRY_BLOCK_ITEM = Registrations.blockItem(BERRY_BASKET_SWEETBERRY_BLOCK);
    public static final BlockEntry<BerryBasketBlock> BERRY_BASKET_BLUEBERRY_BLOCK = Decorations.berryBasket("blueberry");
    public static final ItemEntry<BlockItem> BERRY_BASKET_BLUEBERRY_BLOCK_ITEM = Registrations.blockItem(BERRY_BASKET_BLUEBERRY_BLOCK);
    public static final BlockEntry<BerryBasketBlock> BERRY_BASKET_STRAWBERRY_BLOCK = Decorations.berryBasket("strawberry");
    public static final ItemEntry<BlockItem> BERRY_BASKET_STRAWBERRY_BLOCK_ITEM = Registrations.blockItem(BERRY_BASKET_STRAWBERRY_BLOCK);
    public static final BlockEntry<BoltsOfClothBlock> BOLTS_OF_CLOTH_BLOCK = Decorations.boltsOfCloth();
    public static final ItemEntry<BlockItem> BOLTS_OF_CLOTH_BLOCK_ITEM = Registrations.blockItem(BOLTS_OF_CLOTH_BLOCK);
    public static final BlockEntry<BookStackBlock> BOOK_STACK_BLOCK = Decorations.bookStack();
    public static final ItemEntry<BlockItem> BOOK_STACK_BLOCK_ITEM = Registrations.blockItem(BOOK_STACK_BLOCK);
    public static final BlockEntry<BowlBlock> BOWL_EMPTY_BLOCK = Decorations.bowl("empty");
    public static final ItemEntry<BlockItem> BOWL_EMPTY_BLOCK_ITEM = Registrations.blockItem(BOWL_EMPTY_BLOCK);
    public static final BlockEntry<BowlBlock> BOWL_BEETROOT_SOUP_BLOCK = Decorations.bowl("beetroot_soup");
    public static final ItemEntry<BlockItem> BOWL_BEETROOT_SOUP_BLOCK_ITEM = Registrations.blockItem(BOWL_BEETROOT_SOUP_BLOCK);
    public static final BlockEntry<BowlBlock> BOWL_MUSHROOM_STEW_BLOCK = Decorations.bowl("mushroom_stew");
    public static final ItemEntry<BlockItem> BOWL_MUSHROOM_STEW_BLOCK_ITEM = Registrations.blockItem(BOWL_MUSHROOM_STEW_BLOCK);
    public static final BlockEntry<TankardsBlock> TANKARD_EMPTY_BLOCK = Decorations.tankards("empty");
    public static final ItemEntry<BlockItem> TANKARD_EMPTY_BLOCK_ITEM = Registrations.blockItem(TANKARD_EMPTY_BLOCK);
    public static final BlockEntry<TankardsBlock> TANKARD_HONEYMEAD_BLOCK = Decorations.tankards("honeymead");
    public static final ItemEntry<BlockItem> TANKARD_HONEYMEAD_BLOCK_ITEM = Registrations.blockItem(TANKARD_HONEYMEAD_BLOCK);
    public static final BlockEntry<TankardsBlock> TANKARD_MILK_BLOCK = Decorations.tankards("milk");
    public static final ItemEntry<BlockItem> TANKARD_MILK_BLOCK_ITEM = Registrations.blockItem(TANKARD_MILK_BLOCK);
    public static final BlockEntry<TankardsBlock> TANKARD_SWEETBERRY_BLOCK = Decorations.tankards("sweetberry");
    public static final ItemEntry<BlockItem> TANKARD_SWEETBERRY_BLOCK_ITEM = Registrations.blockItem(TANKARD_SWEETBERRY_BLOCK);
    public static final BlockEntry<MushroomsRedBlock> MUSHROOMS_RED_BLOCK = Decorations.mushroomsRed();
    public static final ItemEntry<BlockItem> MUSHROOMS_RED_BLOCK_ITEM = Registrations.blockItem(MUSHROOMS_RED_BLOCK);
    public static final BlockEntry<CoinStackBlock> COIN_STOCK_GOLD_BLOCK = Decorations.coinStack("gold");
    public static final ItemEntry<BlockItem> COIN_STOCK_GOLD_BLOCK_ITEM = Registrations.blockItem(COIN_STOCK_GOLD_BLOCK);
    public static final BlockEntry<CoinStackBlock> COIN_STOCK_IRON_BLOCK = Decorations.coinStack("iron");
    public static final ItemEntry<BlockItem> COIN_STOCK_IRON_BLOCK_ITEM = Registrations.blockItem(COIN_STOCK_IRON_BLOCK);
    public static final BlockEntry<MuffinsBlock> MUFFINS_BLUEBERRY_BLOCK = Decorations.muffins("blueberry");
    public static final ItemEntry<BlockItem> MUFFINS_BLUEBERRY_BLOCK_ITEM = Registrations.blockItem(MUFFINS_BLUEBERRY_BLOCK);
    public static final BlockEntry<MuffinsBlock> MUFFINS_CHOCOLATE_BLOCK = Decorations.muffins("chocolate");
    public static final ItemEntry<BlockItem> MUFFINS_CHOCOLATE_BLOCK_ITEM = Registrations.blockItem(MUFFINS_CHOCOLATE_BLOCK);
    public static final BlockEntry<MuffinsBlock> MUFFINS_SWEETBERRY_BLOCK = Decorations.muffins("sweetberry");
    public static final ItemEntry<BlockItem> MUFFINS_SWEETBERRY_BLOCK_ITEM = Registrations.blockItem(MUFFINS_SWEETBERRY_BLOCK);
    public static final BlockEntry<PaperStackBlock> PAPER_STACK_BLOCK = Decorations.paperStack();
    public static final ItemEntry<BlockItem> PAPER_STACK_BLOCK_ITEM = Registrations.blockItem(PAPER_STACK_BLOCK);
    public static final BlockEntry<BoiledCremeTreatsBlock> BOILED_CREME_TREATS_BLOCK = Decorations.boiledCremeTreats(FurnitureSet.NORDIC);
    public static final ItemEntry<BlockItem> BOILED_CREME_TREATS_BLOCK_ITEM = Registrations.blockItem(BOILED_CREME_TREATS_BLOCK);
    public static final BlockEntry<SweetRollsBlock> SWEETROLLS_BLOCK = Decorations.sweetRolls(FurnitureSet.NORDIC);
    public static final ItemEntry<BlockItem> SWEETROLLS_BLOCK_ITEM = Registrations.blockItem(SWEETROLLS_BLOCK);
    public static final BlockEntry<MeadBottlesBlock> MEAD_BOTTLES_BLOCK = Decorations.meadBottles(FurnitureSet.NORDIC);
    public static final ItemEntry<BlockItem> MEAD_BOTTLES_BLOCK_ITEM = Registrations.blockItem(MEAD_BOTTLES_BLOCK);
    public static final BlockEntry<SoulGemsBlock> NORDIC_SOUL_GEMS_LIGHT_BLOCK = Decorations.soulGems(FurnitureSet.NORDIC, "light");
    public static final ItemEntry<BlockItem> NORDIC_SOUL_GEMS_LIGHT_BLOCK_ITEM = Registrations.blockItem(NORDIC_SOUL_GEMS_LIGHT_BLOCK);
    public static final BlockEntry<SoulGemsBlock> NORDIC_SOUL_GEMS_DARK_BLOCK = Decorations.soulGems(FurnitureSet.NORDIC, "dark");
    public static final ItemEntry<BlockItem> NORDIC_SOUL_GEMS_DARK_BLOCK_ITEM = Registrations.blockItem(NORDIC_SOUL_GEMS_DARK_BLOCK);
    public static final BlockEntry<FoodBlock> VENTHYR_FOOD_0_BLOCK = Decorations.food(FurnitureSet.VENTHYR, 0);
    public static final ItemEntry<BlockItem> VENTHYR_FOOD_0_BLOCK_ITEM = Registrations.blockItem(VENTHYR_FOOD_0_BLOCK);
    public static final BlockEntry<FoodBlock> VENTHYR_FOOD_1_BLOCK = Decorations.food(FurnitureSet.VENTHYR, 1);
    public static final ItemEntry<BlockItem> VENTHYR_FOOD_1_BLOCK_ITEM = Registrations.blockItem(VENTHYR_FOOD_1_BLOCK);
    public static final BlockEntry<TeaSetBlock> VENTHYR_TEA_SET_BLOCK = Decorations.teaSet(FurnitureSet.VENTHYR);
    public static final ItemEntry<BlockItem> VENTHYR_TEA_SET_BLOCK_ITEM = Registrations.blockItem(VENTHYR_TEA_SET_BLOCK);
    public static final BlockEntry<TeaCupsBlock> VENTHYR_TEA_CUPS_BLOCK = Decorations.teaCups(FurnitureSet.VENTHYR);
    public static final ItemEntry<BlockItem> VENTHYR_TEA_CUPS_BLOCK_ITEM = Registrations.blockItem(VENTHYR_TEA_CUPS_BLOCK);
    public static final BlockEntry<PlatterBlock> VENTHYR_PLATTER_BLOCK = Decorations.platter(FurnitureSet.VENTHYR);
    public static final ItemEntry<BlockItem> VENTHYR_PLATTER_BLOCK_ITEM = Registrations.blockItem(VENTHYR_PLATTER_BLOCK);
    public static final BlockEntry<WidowBloomBlock> VENTHYR_WIDOW_BLOOM_BLOCK = Decorations.widowBloom(FurnitureSet.VENTHYR);
    public static final ItemEntry<BlockItem> VENTHYR_WIDOW_BLOOM_BLOCK_ITEM = Registrations.blockItem(VENTHYR_WIDOW_BLOOM_BLOCK);
    public static final BlockEntityEntry<WidowBloomBlockEntity> VENTHYR_WIDOW_BLOOM_BLOCK_ENTITY = Registrations.blockEntity(VENTHYR_WIDOW_BLOOM_BLOCK);
    public static final BlockEntry<TomesBlock> VENTHYR_TOMES_BLOCK = Decorations.tomes(FurnitureSet.VENTHYR);
    public static final ItemEntry<BlockItem> VENTHYR_TOMES_BLOCK_ITEM = Registrations.blockItem(VENTHYR_TOMES_BLOCK);
    public static final BlockEntry<ChalicesBlock> VENTHYR_CHALICES_BLOCK = Decorations.chalices(FurnitureSet.VENTHYR);
    public static final ItemEntry<BlockItem> VENTHYR_CHALICES_BLOCK_ITEM = Registrations.blockItem(VENTHYR_CHALICES_BLOCK);
    public static final BlockEntry<PotteryBlock> DUNMER_POTTERY_0_BLOCK = Decorations.pottery(FurnitureSet.DUNMER, 0);
    public static final ItemEntry<BlockItem> DUNMER_POTTERY_0_BLOCK_ITEM = Registrations.blockItem(DUNMER_POTTERY_0_BLOCK);
    public static final BlockEntry<PotteryBlock> DUNMER_POTTERY_1_BLOCK = Decorations.pottery(FurnitureSet.DUNMER, 1);
    public static final ItemEntry<BlockItem> DUNMER_POTTERY_1_BLOCK_ITEM = Registrations.blockItem(DUNMER_POTTERY_1_BLOCK);
    public static final ItemGroupCategory ITEM_GROUP_CATEGORY = ItemGroupCategory.builder((String)ITEM_GROUP_CATEGORY_TAG.func_230234_a_().toString()).tagged(ITEM_GROUP_CATEGORY_TAG).defaultIcon(() -> SWEETROLLS_BLOCK.asItemStack()).build();

    private static BlockEntry<BerryBasketBlock> berryBasket(String type) {
        String codeName = "decorations/berry_basket_" + type;
        String englishName = type.equals("empty") ? "Berry Basket" : RegistrateLangProvider.toEnglishName((String)type) + " Basket";
        return (BlockEntry)((BlockBuilder)REGISTRY.block(codeName, BerryBasketBlock::new).lang(englishName).lang("en_gb", englishName).initialProperties(Material.field_151575_d).strength(2.5f).sound(SoundType.field_185848_a).noOcclusion().blockState(Registrations::horizontalBlock).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model(Registrations::blockItem).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, ITEM_GROUP_CATEGORY_TAG}).build()).register();
    }

    private static BlockEntry<BoltsOfClothBlock> boltsOfCloth() {
        return (BlockEntry)((BlockBuilder)REGISTRY.block("decorations/bolts_of_cloth", BoltsOfClothBlock::new).lang("Bolts of Cloth").lang("en_gb", "Bolts of Cloth").initialProperties(Material.field_151580_n).strength(0.8f).sound(SoundType.field_185854_g).noOcclusion().blockState(Registrations::horizontalBlock).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model(Registrations::blockItem).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, ITEM_GROUP_CATEGORY_TAG}).build()).register();
    }

    private static BlockEntry<BookStackBlock> bookStack() {
        return (BlockEntry)((BlockBuilder)REGISTRY.block("decorations/book_stack", BookStackBlock::new).lang("Book Stack").lang("en_gb", "Book Stack").initialProperties(Material.field_151575_d).strength(2.5f).sound(SoundType.field_185848_a).noOcclusion().blockState((ctx, provider) -> Registrations.horizontalBlock(ctx, provider, BookStackBlock.BOOKS)).loot((lootTables, block) -> Registrations.droppingStacked(lootTables, block, BookStackBlock.BOOKS)).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model((ctx, provider) -> Registrations.blockItemStacked(ctx, provider, BookStackBlock.BOOKS)).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, ITEM_GROUP_CATEGORY_TAG}).build()).register();
    }

    private static BlockEntry<BowlBlock> bowl(String type) {
        String codeName = "decorations/bowl_" + type;
        String englishName = type.equals("empty") ? "Bowl" : RegistrateLangProvider.toEnglishName((String)type) + " Bowl";
        return (BlockEntry)((BlockBuilder)REGISTRY.block(codeName, BowlBlock::new).lang(englishName).lang("en_gb", englishName).initialProperties(Material.field_151575_d).strength(2.5f).sound(SoundType.field_185848_a).noOcclusion().blockState(Registrations::horizontalBlock).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model(Registrations::blockItem).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, ITEM_GROUP_CATEGORY_TAG}).build()).register();
    }

    private static BlockEntry<TankardsBlock> tankards(String type) {
        String codeName = "decorations/tankards_" + type;
        String englishName = type.equals("empty") ? "Tankards" : (type.equals("honeymead") ? "Honeyed Tankards" : RegistrateLangProvider.toEnglishName((String)type) + " Tankards");
        return (BlockEntry)((BlockBuilder)REGISTRY.block(codeName, TankardsBlock::new).lang(englishName).lang("en_gb", englishName).initialProperties(Material.field_151575_d).strength(2.5f).sound(SoundType.field_185848_a).noOcclusion().blockState((ctx, provider) -> Registrations.horizontalBlock(ctx, provider, TankardsBlock.TANKARDS)).loot((lootTables, block) -> Registrations.droppingStacked(lootTables, block, TankardsBlock.TANKARDS)).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model((ctx, provider) -> Registrations.blockItemStacked(ctx, provider, TankardsBlock.TANKARDS)).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, ITEM_GROUP_CATEGORY_TAG}).build()).register();
    }

    private static BlockEntry<MushroomsRedBlock> mushroomsRed() {
        return (BlockEntry)((BlockBuilder)REGISTRY.block("decorations/mushrooms_red", MushroomsRedBlock::new).lang("Red Mushrooms").lang("en_gb", "Red Mushrooms").initialProperties(Material.field_151585_k, MaterialColor.field_151645_D).sound(SoundType.field_185850_c).noOcclusion().noCollission().randomTicks().instabreak().blockState((ctx, provider) -> Registrations.horizontalBlock(ctx, provider, MushroomsRedBlock.MUSHROOMS)).loot((lootTables, block) -> Registrations.droppingStacked(lootTables, block, MushroomsRedBlock.MUSHROOMS)).hasPostProcess(BlockHelper::always).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model((ctx, provider) -> Registrations.blockItemStacked(ctx, provider, MushroomsRedBlock.MUSHROOMS)).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, ITEM_GROUP_CATEGORY_TAG}).build()).register();
    }

    private static BlockEntry<CoinStackBlock> coinStack(String type) {
        return (BlockEntry)((BlockBuilder)REGISTRY.block("decorations/coin_stack_" + type, CoinStackBlock::new).lang(RegistrateLangProvider.toEnglishName((String)type) + " Coin Stack").lang("en_gb", RegistrateLangProvider.toEnglishName((String)type) + " Coin Stack").initialProperties(Material.field_151573_f).strength(2.5f).sound(SoundType.field_185852_e).noOcclusion().blockState(Registrations::horizontalBlock).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model(Registrations::blockItem).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, ITEM_GROUP_CATEGORY_TAG}).build()).register();
    }

    private static BlockEntry<MuffinsBlock> muffins(String type) {
        return (BlockEntry)((BlockBuilder)REGISTRY.block("decorations/muffins_" + type, MuffinsBlock::new).lang(RegistrateLangProvider.toEnglishName((String)type) + " Muffins").lang("en_gb", RegistrateLangProvider.toEnglishName((String)type) + " Muffins").initialProperties(Material.field_151568_F).strength(0.5f).sound(SoundType.field_185854_g).noOcclusion().blockState((ctx, provider) -> Registrations.horizontalBlock(ctx, provider, MuffinsBlock.MUFFINS)).loot((lootTables, block) -> Registrations.droppingStacked(lootTables, block, MuffinsBlock.MUFFINS)).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model((ctx, provider) -> Registrations.blockItemStacked(ctx, provider, MuffinsBlock.MUFFINS)).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, ITEM_GROUP_CATEGORY_TAG}).build()).register();
    }

    private static BlockEntry<PaperStackBlock> paperStack() {
        return (BlockEntry)((BlockBuilder)REGISTRY.block("decorations/paper_stack", PaperStackBlock::new).lang("Paper Stack").lang("en_gb", "Paper stack").initialProperties(Material.field_151575_d).strength(2.5f).sound(SoundType.field_185848_a).noOcclusion().blockState(Registrations::horizontalBlock).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model(Registrations::blockItem).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, ITEM_GROUP_CATEGORY_TAG}).build()).register();
    }

    private static BlockEntry<BoiledCremeTreatsBlock> boiledCremeTreats(FurnitureSet furnitureSet) {
        return (BlockEntry)((BlockBuilder)((ItemBuilder)((BlockBuilder)REGISTRY.block("decorations/" + furnitureSet.serializedName + "/boiled_creme_treats", BoiledCremeTreatsBlock::new).lang("Boiled Creme Treats").lang("en_gb", "Boiled Creme Treats").initialProperties(Material.field_151568_F).strength(0.5f).sound(SoundType.field_185854_g).noOcclusion().blockState((ctx, provider) -> Registrations.horizontalBlock(ctx, provider, BoiledCremeTreatsBlock.TREATS)).loot((lootTables, block) -> Registrations.droppingStacked(lootTables, block, BoiledCremeTreatsBlock.TREATS)).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).mapping("1.16.5", "decorations/boiled_creme_treats", RegistryEvent.MissingMappings.Action.REMAP)).item().model((ctx, provider) -> Registrations.blockItemStacked(ctx, provider, BoiledCremeTreatsBlock.TREATS)).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, ITEM_GROUP_CATEGORY_TAG, furnitureSet.itemGroupCategoryTag}).mapping("1.16.5", "decorations/boiled_creme_treats", RegistryEvent.MissingMappings.Action.REMAP)).build()).register();
    }

    private static BlockEntry<SweetRollsBlock> sweetRolls(FurnitureSet furnitureSet) {
        return (BlockEntry)((BlockBuilder)((ItemBuilder)((BlockBuilder)REGISTRY.block("decorations/" + furnitureSet.serializedName + "/sweetrolls", SweetRollsBlock::new).lang("Sweetrolls").lang("en_gb", "Sweetrolls").initialProperties(Material.field_151568_F).strength(0.5f).sound(SoundType.field_185854_g).noOcclusion().blockState((ctx, provider) -> Registrations.horizontalBlock(ctx, provider, SweetRollsBlock.ROLLS)).loot((lootTables, block) -> Registrations.droppingStacked(lootTables, block, SweetRollsBlock.ROLLS)).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).mapping("1.16.5", "decorations/sweetrolls", RegistryEvent.MissingMappings.Action.REMAP)).item().model((ctx, provider) -> Registrations.blockItemStacked(ctx, provider, SweetRollsBlock.ROLLS)).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, ITEM_GROUP_CATEGORY_TAG, furnitureSet.itemGroupCategoryTag}).mapping("1.16.5", "decorations/sweetrolls", RegistryEvent.MissingMappings.Action.REMAP)).build()).register();
    }

    private static BlockEntry<MeadBottlesBlock> meadBottles(FurnitureSet furnitureSet) {
        return (BlockEntry)((BlockBuilder)((ItemBuilder)((BlockBuilder)REGISTRY.block("decorations/" + furnitureSet.serializedName + "/mead_bottles", MeadBottlesBlock::new).lang("Mead Bottles").lang("en_gb", "Mead Bottles").initialProperties(Material.field_151592_s).strength(0.3f).sound(SoundType.field_185853_f).noOcclusion().blockState((ctx, provider) -> Registrations.horizontalBlock(ctx, provider, MeadBottlesBlock.BOTTLES)).loot((lootTables, block) -> Registrations.droppingStacked(lootTables, block, MeadBottlesBlock.BOTTLES)).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).mapping("1.16.5", "decorations/mead_bottles", RegistryEvent.MissingMappings.Action.REMAP)).item().model((ctx, provider) -> Registrations.blockItemStacked(ctx, provider, MeadBottlesBlock.BOTTLES)).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, ITEM_GROUP_CATEGORY_TAG, furnitureSet.itemGroupCategoryTag}).mapping("1.16.5", "decorations/mead_bottles", RegistryEvent.MissingMappings.Action.REMAP)).build()).register();
    }

    private static BlockEntry<SoulGemsBlock> soulGems(FurnitureSet furnitureSet, String type) {
        String englishName = "Soul Gems";
        if (type.equals("dark")) {
            englishName = "Black " + englishName;
        }
        return (BlockEntry)((BlockBuilder)REGISTRY.block("decorations/" + furnitureSet.serializedName + "/soul_gems_" + type, SoulGemsBlock::new).lang(englishName).lang("en_gb", englishName).initialProperties(Material.field_151592_s).strength(0.3f).sound(SoundType.field_185853_f).noOcclusion().blockState(Registrations::horizontalBlock).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model(Registrations::blockItem).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, ITEM_GROUP_CATEGORY_TAG, furnitureSet.itemGroupCategoryTag}).build()).register();
    }

    private static BlockEntry<FoodBlock> food(FurnitureSet furnitureSet, int index) {
        return (BlockEntry)((BlockBuilder)REGISTRY.block("decorations/" + furnitureSet.serializedName + "/food_" + index, FoodBlock::new).lang(furnitureSet.englishName + " Food " + (index + 1)).lang("en_gb", furnitureSet.englishName + " Food " + (index + 1)).initialProperties(Material.field_151568_F).strength(2.5f).sound(SoundType.field_185854_g).noOcclusion().blockState(Registrations::horizontalBlock).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model(Registrations::blockItem).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, ITEM_GROUP_CATEGORY_TAG, furnitureSet.itemGroupCategoryTag}).build()).register();
    }

    private static BlockEntry<TeaSetBlock> teaSet(FurnitureSet furnitureSet) {
        return (BlockEntry)((MultiBlockBuilder)REGISTRY.multiBlock("decorations/" + furnitureSet.serializedName + "/tea_set", TeaSetBlock::new, FFPatterns.PATTERN_1x2).lang(furnitureSet.englishName + " Tea Set").lang("en_gb", furnitureSet.englishName + " Tea Set").initialProperties(Material.field_151573_f).strength(2.5f).sound(SoundType.field_185852_e).noOcclusion().blockState(Registrations::horizontalBlock).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model(Registrations::blockItem).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, ITEM_GROUP_CATEGORY_TAG, furnitureSet.itemGroupCategoryTag}).build()).register();
    }

    private static BlockEntry<TeaCupsBlock> teaCups(FurnitureSet furnitureSet) {
        return (BlockEntry)((BlockBuilder)REGISTRY.block("decorations/" + furnitureSet.serializedName + "/tea_cups", TeaCupsBlock::new).lang(furnitureSet.englishName + " Tea Cups").lang("en_gb", furnitureSet.englishName + " Tea Cups").initialProperties(Material.field_151573_f).strength(2.5f).sound(SoundType.field_185852_e).noOcclusion().blockState((ctx, provider) -> Registrations.horizontalBlock(ctx, provider, TeaCupsBlock.TEA_CUPS)).loot((lootTables, block) -> Registrations.droppingStacked(lootTables, block, TeaCupsBlock.TEA_CUPS)).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model((ctx, provider) -> Registrations.blockItemStacked(ctx, provider, TeaCupsBlock.TEA_CUPS)).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, ITEM_GROUP_CATEGORY_TAG, furnitureSet.itemGroupCategoryTag}).build()).register();
    }

    private static BlockEntry<PlatterBlock> platter(FurnitureSet furnitureSet) {
        return (BlockEntry)((BlockBuilder)REGISTRY.block("decorations/" + furnitureSet.serializedName + "/platter", PlatterBlock::new).lang(furnitureSet.englishName + " Platter").lang("en_gb", furnitureSet.englishName + " Platter").initialProperties(Material.field_151573_f).strength(2.5f).sound(SoundType.field_185852_e).noOcclusion().blockState((ctx, provider) -> Registrations.horizontalBlock(ctx, provider, PlatterBlock.PLATTER)).loot((lootTables, block) -> Registrations.droppingStacked(lootTables, block, PlatterBlock.PLATTER)).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model((ctx, provider) -> Registrations.blockItemStacked(ctx, provider, PlatterBlock.PLATTER)).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, ITEM_GROUP_CATEGORY_TAG, furnitureSet.itemGroupCategoryTag}).build()).register();
    }

    private static BlockEntry<WidowBloomBlock> widowBloom(FurnitureSet furnitureSet) {
        return (BlockEntry)((BlockBuilder)((BlockBuilder)REGISTRY.block("decorations/" + furnitureSet.serializedName + "/widow_bloom", WidowBloomBlock::new).lang("Widowbloom Vase").lang("en_gb", "Widowbloom Vase").initialProperties(Material.field_151594_q).strength(2.5f).sound(SoundType.field_185851_d).noOcclusion().blockState((ctx, provider) -> provider.getVariantBuilder((Block)ctx.get()).forAllStates(blockState -> ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)provider.models().getBuilder(ctx.getName())).texture("particle", "minecraft:block/basalt_top")).build())).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item((block, properties) -> new WearableBlockItem(block, properties, new EquipmentSlotType[]{EquipmentSlotType.HEAD})).model((ctx, provider) -> {
            ResourceLocation id = ctx.getId();
            ModelFile.UncheckedModelFile builtInEntity = new ModelFile.UncheckedModelFile("minecraft:builtin/entity");
            ((ItemModelBuilder)((ItemModelBuilder)provider.getBuilder(id.func_110624_b() + ":item/" + id.func_110623_a())).parent((ModelFile)builtInEntity)).transforms().transform(ModelBuilder.Perspective.THIRDPERSON_RIGHT).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 3.0f, 4.0f).scale(0.375f, 0.375f, 0.375f).end().transform(ModelBuilder.Perspective.THIRDPERSON_LEFT).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 3.0f, 4.0f).scale(0.375f, 0.375f, 0.375f).end().transform(ModelBuilder.Perspective.FIRSTPERSON_RIGHT).rotation(0.0f, 135.0f, 0.0f).translation(0.0f, 7.0f, 0.0f).scale(0.4f, 0.4f, 0.4f).end().transform(ModelBuilder.Perspective.FIRSTPERSON_LEFT).rotation(0.0f, 135.0f, 0.0f).translation(0.0f, 7.0f, 0.0f).scale(0.4f, 0.4f, 0.4f).end().transform(ModelBuilder.Perspective.HEAD).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 30.0f, 0.0f).scale(1.0f, 1.0f, 1.0f).end().transform(ModelBuilder.Perspective.GROUND).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 6.0f, 0.0f).scale(0.25f, 0.25f, 0.25f).end().transform(ModelBuilder.Perspective.FIXED).rotation(-90.0f, 0.0f, 0.0f).translation(0.0f, 0.0f, -23.0f).scale(1.0f, 1.0f, 1.0f).end().transform(ModelBuilder.Perspective.GUI).rotation(30.0f, -135.0f, 0.0f).translation(0.0f, 3.0f, 0.0f).scale(0.5f, 0.5f, 0.5f).end().end();
        }).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, ITEM_GROUP_CATEGORY_TAG, furnitureSet.itemGroupCategoryTag}).setISTER(() -> DatagenModLoader.isRunningDataGen() ? () -> null : FFItemStackBlockEntityRenderer::new).build()).blockEntity(WidowBloomBlockEntity::new).renderer(() -> WidowBloomBlockEntityRenderer::new).build()).register();
    }

    private static BlockEntry<TomesBlock> tomes(FurnitureSet furnitureSet) {
        return (BlockEntry)((BlockBuilder)REGISTRY.block("decorations/" + furnitureSet.serializedName + "/tomes", TomesBlock::new).lang(furnitureSet.englishName + " Tomes").lang("en_gb", furnitureSet.englishName + " Tomes").initialProperties(Material.field_151575_d).strength(2.5f).sound(SoundType.field_185848_a).noOcclusion().blockState((ctx, provider) -> Registrations.horizontalBlock(ctx, provider, TomesBlock.TOMES)).loot((lootTables, block) -> Registrations.droppingStacked(lootTables, block, TomesBlock.TOMES)).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model((ctx, provider) -> Registrations.blockItemStacked(ctx, provider, TomesBlock.TOMES)).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, ITEM_GROUP_CATEGORY_TAG, furnitureSet.itemGroupCategoryTag}).build()).register();
    }

    private static BlockEntry<ChalicesBlock> chalices(FurnitureSet furnitureSet) {
        return (BlockEntry)((BlockBuilder)REGISTRY.block("decorations/" + furnitureSet.serializedName + "/chalices", ChalicesBlock::new).lang(furnitureSet.englishName + " Chalices").lang("en_gb", furnitureSet.englishName + " Chalices").initialProperties(Material.field_151573_f).strength(2.5f).sound(SoundType.field_185852_e).noOcclusion().blockState((ctx, provider) -> Registrations.horizontalBlock(ctx, provider, ChalicesBlock.CHALICES)).loot((lootTables, block) -> Registrations.droppingStacked(lootTables, block, ChalicesBlock.CHALICES)).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model((ctx, provider) -> Registrations.blockItemStacked(ctx, provider, ChalicesBlock.CHALICES)).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, ITEM_GROUP_CATEGORY_TAG, furnitureSet.itemGroupCategoryTag}).build()).register();
    }

    private static BlockEntry<PotteryBlock> pottery(FurnitureSet furnitureSet, int index) {
        String codeName = "decorations/" + furnitureSet.serializedName + "/pottery_" + index;
        String englishName = furnitureSet.englishName + " Pottery " + (index + 1);
        return (BlockEntry)((BlockBuilder)REGISTRY.block(codeName, PotteryBlock::new).lang(englishName).lang("en_gb", englishName).initialProperties(Material.field_151594_q).strength(2.5f).sound(SoundType.field_185851_d).noOcclusion().blockState(Registrations::horizontalBlock).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model(Registrations::blockItem).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, ITEM_GROUP_CATEGORY_TAG, furnitureSet.itemGroupCategoryTag}).build()).register();
    }

    static void bootstrap() {
        ITEM_GROUP_CATEGORY.addTranslationGenerator((AbstractRegistrator)REGISTRY, "Decorations").addTranslationGenerator((AbstractRegistrator)REGISTRY, "en_gb", "Decorations");
        BlockEntry[] blocks = new BlockEntry[]{BERRY_BASKET_EMPTY_BLOCK, BERRY_BASKET_SWEETBERRY_BLOCK, BERRY_BASKET_BLUEBERRY_BLOCK, BERRY_BASKET_STRAWBERRY_BLOCK, BOLTS_OF_CLOTH_BLOCK, BOOK_STACK_BLOCK, BOWL_EMPTY_BLOCK, BOWL_BEETROOT_SOUP_BLOCK, BOWL_MUSHROOM_STEW_BLOCK, TANKARD_EMPTY_BLOCK, TANKARD_HONEYMEAD_BLOCK, TANKARD_MILK_BLOCK, TANKARD_SWEETBERRY_BLOCK, MUSHROOMS_RED_BLOCK, COIN_STOCK_GOLD_BLOCK, COIN_STOCK_IRON_BLOCK, MUFFINS_BLUEBERRY_BLOCK, MUFFINS_CHOCOLATE_BLOCK, MUFFINS_SWEETBERRY_BLOCK, PAPER_STACK_BLOCK, BOILED_CREME_TREATS_BLOCK, SWEETROLLS_BLOCK, MEAD_BOTTLES_BLOCK, NORDIC_SOUL_GEMS_LIGHT_BLOCK, NORDIC_SOUL_GEMS_DARK_BLOCK, VENTHYR_FOOD_0_BLOCK, VENTHYR_FOOD_1_BLOCK, VENTHYR_TEA_SET_BLOCK, VENTHYR_TEA_CUPS_BLOCK, VENTHYR_PLATTER_BLOCK, VENTHYR_WIDOW_BLOOM_BLOCK, VENTHYR_TOMES_BLOCK, VENTHYR_CHALICES_BLOCK, DUNMER_POTTERY_0_BLOCK, DUNMER_POTTERY_1_BLOCK};
        ItemEntry[] items = new ItemEntry[]{BERRY_BASKET_EMPTY_BLOCK_ITEM, BERRY_BASKET_SWEETBERRY_BLOCK_ITEM, BERRY_BASKET_BLUEBERRY_BLOCK_ITEM, BERRY_BASKET_STRAWBERRY_BLOCK_ITEM, BOLTS_OF_CLOTH_BLOCK_ITEM, BOOK_STACK_BLOCK_ITEM, BOWL_EMPTY_BLOCK_ITEM, BOWL_BEETROOT_SOUP_BLOCK_ITEM, BOWL_MUSHROOM_STEW_BLOCK_ITEM, TANKARD_EMPTY_BLOCK_ITEM, TANKARD_HONEYMEAD_BLOCK_ITEM, TANKARD_MILK_BLOCK_ITEM, TANKARD_SWEETBERRY_BLOCK_ITEM, MUSHROOMS_RED_BLOCK_ITEM, COIN_STOCK_GOLD_BLOCK_ITEM, COIN_STOCK_IRON_BLOCK_ITEM, MUFFINS_BLUEBERRY_BLOCK_ITEM, MUFFINS_CHOCOLATE_BLOCK_ITEM, MUFFINS_SWEETBERRY_BLOCK_ITEM, PAPER_STACK_BLOCK_ITEM, BOILED_CREME_TREATS_BLOCK_ITEM, SWEETROLLS_BLOCK_ITEM, MEAD_BOTTLES_BLOCK_ITEM, NORDIC_SOUL_GEMS_LIGHT_BLOCK_ITEM, NORDIC_SOUL_GEMS_DARK_BLOCK_ITEM, VENTHYR_FOOD_0_BLOCK_ITEM, VENTHYR_FOOD_1_BLOCK_ITEM, VENTHYR_TEA_SET_BLOCK_ITEM, VENTHYR_TEA_CUPS_BLOCK_ITEM, VENTHYR_PLATTER_BLOCK_ITEM, VENTHYR_WIDOW_BLOOM_BLOCK_ITEM, VENTHYR_TOMES_BLOCK_ITEM, VENTHYR_CHALICES_BLOCK_ITEM, DUNMER_POTTERY_0_BLOCK_ITEM, DUNMER_POTTERY_1_BLOCK_ITEM};
        REGISTRY.addDataGenerator(ProviderType.LANG, provider -> {
            for (BlockEntry entry : blocks) {
                entry.ifPresent(block -> {
                    if (block instanceof IStackedBlock) {
                        IStackedBlock stacked = (IStackedBlock)block;
                        provider.add(stacked.getStackableTranslationKey(), "Stackable");
                    }
                });
            }
        });
        REGISTRY.addDataGenerator(AbstractRegistrator.LANG_EXT_PROVIDER, provider -> {
            for (BlockEntry entry : blocks) {
                entry.ifPresent(block -> {
                    if (block instanceof IStackedBlock) {
                        IStackedBlock stacked = (IStackedBlock)block;
                        provider.add("en_gb", stacked.getStackableTranslationKey(), "Stackable");
                    }
                });
            }
        });
        EventBusHelper.addEnqueuedListener(FMLCommonSetupEvent.class, event -> {
            ItemGroupCategoryManager instance = ItemGroupCategoryManager.getInstance((ItemGroup)FFRegistry.MOD_ITEM_GROUP);
            instance.addCategory(ITEM_GROUP_CATEGORY);
        });
    }
}

