/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.container;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import xyz.apex.forge.fantasyfurniture.init.FurnitureStation;
import xyz.apex.java.utility.nullness.NonnullPredicate;

public final class FurnitureStationContainer
extends Container {
    private final IWorldPosCallable access;
    private final IInventory inputInventory;
    private final CraftResultInventory resultInventory;
    private final Slot claySlot;
    private final Slot woodSlot;
    private final Slot stoneSlot;
    private final Slot resultSlot;
    private final List<ItemStack> results = Lists.newArrayList();
    private long lastSoundTime = 0L;

    public FurnitureStationContainer(@Nullable ContainerType<?> menuType, int windowId, PlayerInventory playerInventory, IWorldPosCallable access) {
        super(menuType, windowId);
        int i;
        this.access = access;
        this.inputInventory = new Inventory(4){

            public void func_70296_d() {
                super.func_70296_d();
                FurnitureStationContainer.this.func_75130_a((IInventory)this);
            }
        };
        this.resultInventory = new CraftResultInventory();
        this.claySlot = this.func_75146_a(new InputSlot(0, 16, 21, FurnitureStation::isValidClay));
        this.woodSlot = this.func_75146_a(new InputSlot(1, 34, 21, FurnitureStation::isValidWood));
        this.stoneSlot = this.func_75146_a(new InputSlot(2, 52, 21, FurnitureStation::isValidStone));
        this.resultSlot = this.func_75146_a(new ResultSlot());
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j + i * 9 + 9, 8 + j * 18, 140 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)playerInventory, i, 8 + i * 18, 198));
        }
    }

    public Slot getClaySlot() {
        return this.claySlot;
    }

    public Slot getWoodSlot() {
        return this.woodSlot;
    }

    public Slot getStoneSlot() {
        return this.stoneSlot;
    }

    public Slot getResultSlot() {
        return this.resultSlot;
    }

    public List<ItemStack> getResults() {
        return this.results;
    }

    public boolean func_75145_c(PlayerEntity player) {
        return FurnitureStationContainer.func_216963_a((IWorldPosCallable)this.access, (PlayerEntity)player, (Block)FurnitureStation.BLOCK.asBlock());
    }

    public void func_75130_a(IInventory inventory) {
        super.func_75130_a(inventory);
        this.results.clear();
        if (this.claySlot.func_75216_d() && this.woodSlot.func_75216_d() && this.stoneSlot.func_75216_d()) {
            this.results.addAll(FurnitureStation.getCraftingResults());
        }
        this.setupResultSlot(-1);
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return slot.field_75224_c != this.resultInventory && super.func_94530_a(stack, slot);
    }

    public boolean func_75140_a(PlayerEntity player, int button) {
        this.setupResultSlot(button);
        return super.func_75140_a(player, button);
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        this.resultInventory.func_70304_b(1);
        this.access.func_221486_a((world, pos) -> this.func_193327_a(player, (World)world, this.inputInventory));
    }

    public ItemStack func_82846_b(PlayerEntity player, int slotIndex) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack1 = slot.func_75211_c();
            stack = stack1.func_77946_l();
            int inputStart = Math.min(0, Math.min(1, 2));
            int inputEnd = Math.max(0, Math.max(1, 2));
            int resultSlot = 3;
            int playerStart = 4;
            int playerEnd = 31;
            int hotStart = 32;
            int hotEnd = 40;
            if (slotIndex >= inputStart && slotIndex <= inputEnd) {
                if (!this.func_75135_a(stack1, playerStart, hotEnd, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (slotIndex == resultSlot) {
                stack1.func_77980_a(player.field_70170_p, player, stack1.func_190916_E());
                if (!this.func_75135_a(stack1, playerStart, hotEnd, false)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(stack1, stack);
            } else if (slotIndex >= playerStart && slotIndex <= playerEnd) {
                if (!this.func_75135_a(stack1, inputStart, resultSlot, false)) {
                    return ItemStack.field_190927_a;
                }
                if (!this.func_75135_a(stack1, hotStart, hotEnd, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (slotIndex >= hotStart && slotIndex <= hotEnd && !this.func_75135_a(stack1, inputStart, playerEnd, false)) {
                return ItemStack.field_190927_a;
            }
            if (stack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
            slot.func_75218_e();
            if (stack1.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, stack1);
            this.func_75142_b();
        }
        return stack;
    }

    private void setupResultSlot(int button) {
        int size = this.results.size();
        if (size == 0 || button < 0 || button > size - 1) {
            this.resultSlot.func_75215_d(ItemStack.field_190927_a);
            this.func_75142_b();
            return;
        }
        ItemStack stack = this.results.get(button).func_77946_l();
        stack.func_190920_e(1);
        this.resultSlot.func_75215_d(stack);
        this.func_75142_b();
    }

    private void decrementInput() {
        this.claySlot.func_75209_a(1);
        this.woodSlot.func_75209_a(1);
        this.stoneSlot.func_75209_a(1);
    }

    public final class ResultSlot
    extends Slot {
        private ResultSlot() {
            super((IInventory)FurnitureStationContainer.this.resultInventory, 3, 148, 72);
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        public ItemStack func_190901_a(PlayerEntity player, ItemStack stack) {
            stack.func_77973_b().func_77622_d(stack, player.field_70170_p, player);
            FurnitureStationContainer.this.resultInventory.func_201560_d(player);
            FurnitureStationContainer.this.decrementInput();
            FurnitureStationContainer.this.setupResultSlot(-1);
            FurnitureStationContainer.this.access.func_221486_a((world, pos) -> {
                long gameTime = world.func_82737_E();
                if (FurnitureStationContainer.this.lastSoundTime != gameTime) {
                    world.func_184133_a(null, pos, SoundEvents.field_219719_ml, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    FurnitureStationContainer.this.lastSoundTime = gameTime;
                }
            });
            return super.func_190901_a(player, stack);
        }
    }

    public final class InputSlot
    extends Slot {
        private final NonnullPredicate<ItemStack> predicate;

        private InputSlot(int index, int x, int y, NonnullPredicate<ItemStack> predicate) {
            super(FurnitureStationContainer.this.inputInventory, index, x, y);
            this.predicate = predicate;
        }

        public boolean func_75214_a(ItemStack stack) {
            return this.predicate.test((Object)stack);
        }
    }
}

