/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.client.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.StringUtils;
import xyz.apex.forge.fantasyfurniture.container.FurnitureStationContainer;
import xyz.apex.forge.fantasyfurniture.init.FFRegistry;
import xyz.apex.forge.fantasyfurniture.init.FurnitureStation;

public final class FurnitureStationContainerScreen
extends ContainerScreen<FurnitureStationContainer> {
    public static final ResourceLocation TEXTURE = FFRegistry.getInstance().id("textures/gui/container/furniture_station.png");
    private int clayIndex = 0;
    private int woodIndex = 0;
    private int stoneIndex = 0;
    private int cycleCounter = 0;
    private float scrollOffset = 0.0f;
    private int startIndex = 0;
    private boolean scrolling = false;
    @Nullable
    private TextFieldWidget searchBox;
    private boolean focusSearchBoxNextTick = false;
    private int currentSearchSyntaxColor = 0xFFFFFF;
    private boolean changeSearchSyntaxColor = true;

    public FurnitureStationContainerScreen(FurnitureStationContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
    }

    protected void func_231160_c_() {
        this.field_146999_f = 176;
        this.field_147000_g = 222;
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        super.func_231160_c_();
        this.field_238745_s_ = this.field_147000_g - 94;
        this.scrolling = false;
        this.startIndex = 0;
        this.scrollOffset = 0.0f;
        String text = this.searchBox == null ? "" : this.searchBox.func_146179_b();
        int s = 73;
        int e = this.field_146999_f - 12;
        int w = e - s;
        int h = 16;
        int x = this.field_147003_i + s;
        this.field_230712_o_.getClass();
        int y = this.field_147009_r + this.field_238743_q_ + 9 + 6;
        this.searchBox = (TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, x, y, w, h, (ITextComponent)new TranslationTextComponent("gui.recipebook.search_hint")));
        this.searchBox.func_146203_f(50);
        this.searchBox.func_146185_a(true);
        this.searchBox.func_146189_e(true);
        this.searchBox.func_146193_g(this.currentSearchSyntaxColor);
        this.searchBox.func_146180_a(text);
        this.searchBox.func_146205_d(true);
    }

    public void func_231023_e_() {
        if (this.searchBox != null) {
            Slot claySlot = ((FurnitureStationContainer)this.field_147002_h).getClaySlot();
            Slot woodSlot = ((FurnitureStationContainer)this.field_147002_h).getWoodSlot();
            Slot stoneSlot = ((FurnitureStationContainer)this.field_147002_h).getStoneSlot();
            if (!(claySlot.func_75216_d() && woodSlot.func_75216_d() && stoneSlot.func_75216_d())) {
                this.searchBox.field_230693_o_ = false;
                this.searchBox.func_146180_a("");
                this.focusSearchBoxNextTick = false;
                this.searchBox.func_146195_b(false);
                this.func_231035_a_(null);
            } else {
                this.searchBox.field_230693_o_ = true;
            }
            this.searchBox.func_146178_a();
            if (this.focusSearchBoxNextTick) {
                if (!this.searchBox.func_230999_j_()) {
                    this.func_231035_a_((IGuiEventListener)this.searchBox);
                    this.searchBox.func_146195_b(true);
                }
                this.focusSearchBoxNextTick = false;
            }
        }
        this.updateSearchBoxSyntaxHighlighting();
        super.func_231023_e_();
    }

    public void func_231164_f_() {
        this.searchBox = null;
        this.field_230706_i_.field_195559_v.func_197967_a(false);
        super.func_231164_f_();
    }

    public void func_230430_a_(MatrixStack pose, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(pose);
        super.func_230430_a_(pose, mouseX, mouseY, partialTicks);
        if (this.searchBox != null && this.searchBox.func_146176_q() && !this.searchBox.func_230999_j_() && this.searchBox.func_146179_b().isEmpty()) {
            IFormattableTextComponent iFormattableTextComponent = this.searchBox.func_230458_i_().func_230532_e_().func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC});
            int n = this.searchBox.field_230690_l_ + 2;
            int n2 = this.searchBox.field_230691_m_;
            this.field_230712_o_.getClass();
            FurnitureStationContainerScreen.func_238475_b_((MatrixStack)pose, (FontRenderer)this.field_230712_o_, (ITextComponent)iFormattableTextComponent, (int)n, (int)(n2 + 9 / 2), (int)this.searchBox.getFGColor());
        }
        this.renderResults(pose, mouseX, mouseY);
        this.renderSlotBackgrounds(pose, mouseX, mouseY);
        this.func_230459_a_(pose, mouseX, mouseY);
        if (this.searchBox != null && this.searchBox.func_146176_q() && this.searchBox.func_231047_b_((double)mouseX, (double)mouseY)) {
            this.renderWrappedToolTip(pose, Arrays.asList(new StringTextComponent("'").func_230529_a_((ITextComponent)new StringTextComponent("@").func_240701_a_(new TextFormatting[]{TextFormatting.AQUA, TextFormatting.ITALIC})).func_240702_b_("' -> Search by ").func_230529_a_((ITextComponent)new StringTextComponent("Mod ID").func_240701_a_(new TextFormatting[]{TextFormatting.AQUA, TextFormatting.ITALIC})), new StringTextComponent("'").func_230529_a_((ITextComponent)new StringTextComponent("#").func_240701_a_(new TextFormatting[]{TextFormatting.AQUA, TextFormatting.ITALIC})).func_240702_b_("' -> Search by ").func_230529_a_((ITextComponent)new StringTextComponent("ItemTag").func_240701_a_(new TextFormatting[]{TextFormatting.AQUA, TextFormatting.ITALIC}))), mouseX, mouseY, this.field_230712_o_);
        }
    }

    protected void func_230450_a_(MatrixStack pose, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(TEXTURE);
        int i = (this.field_230708_k_ - this.field_146999_f) / 2;
        int j = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(pose, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        int k = (int)(57.0f * this.scrollOffset);
        this.func_238474_b_(pose, i + 127, j + 45 + k, 194 + (this.scrollbarActive() ? 0 : 12), 0, 12, 15);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        this.scrolling = false;
        if (this.searchBox != null && this.searchBox.field_230693_o_ && this.searchBox.func_146176_q()) {
            if (this.searchBox.func_231044_a_(mouseX, mouseY, mouseButton)) {
                this.changeSearchSyntaxColor = true;
                return true;
            }
            if (mouseButton == 1 && this.searchBox.func_231047_b_(mouseX, mouseY)) {
                this.changeSearchSyntaxColor = true;
                this.searchBox.func_146180_a("");
                return true;
            }
        }
        if (this.clickedResult(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (!((FurnitureStationContainer)this.field_147002_h).getResults().isEmpty()) {
            int x = this.field_147003_i + 128;
            int y = this.field_147009_r + 46;
            int w = 12;
            int h = 71;
            if (mouseX >= (double)x && mouseY >= (double)y && mouseX < (double)(x + w) && mouseY < (double)(y + h)) {
                this.scrolling = true;
                return true;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        List<ItemStack> results = ((FurnitureStationContainer)this.field_147002_h).getResults();
        int size = results.size();
        if (this.scrolling && this.scrollbarActive()) {
            int i = this.field_147009_r + 44;
            int j = i + 73;
            int offscreenRows = (size + 6 - 1) / 4 - 4;
            this.scrollOffset = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffset = MathHelper.func_76131_a((float)this.scrollOffset, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffset * (float)offscreenRows) + 0.5) * 6;
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, mouseButton, dragX, dragY);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scrollDelta) {
        if (this.scrollbarActive()) {
            List<ItemStack> results = ((FurnitureStationContainer)this.field_147002_h).getResults();
            int size = results.size();
            int offscreenRows = (size + 6 - 1) / 4 - 4;
            this.scrollOffset = (float)((double)this.scrollOffset - scrollDelta / (double)offscreenRows);
            this.scrollOffset = MathHelper.func_76131_a((float)this.scrollOffset, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffset * (float)offscreenRows) + 0.5) * 6;
            return true;
        }
        return super.func_231043_a_(mouseX, mouseY, scrollDelta);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox != null && this.searchBox.field_230693_o_ && this.searchBox.func_146176_q()) {
            if (this.searchBox.func_230999_j_()) {
                if (this.searchBox.func_231046_a_(keyCode, scanCode, modifiers)) {
                    this.changeSearchSyntaxColor = true;
                    return true;
                }
                if (this.field_230706_i_.field_71474_y.field_151445_Q.func_197976_a(keyCode, scanCode)) {
                    return false;
                }
                if (keyCode == 256) {
                    this.focusSearchBoxNextTick = false;
                    this.searchBox.func_146195_b(false);
                    return true;
                }
            } else if (this.field_230706_i_.field_71474_y.field_74310_D.func_197976_a(keyCode, scanCode)) {
                this.focusSearchBoxNextTick = true;
                return true;
            }
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char typedChar, int modifiers) {
        if (this.searchBox != null && this.searchBox.field_230693_o_ && this.searchBox.func_230999_j_() && this.searchBox.func_146176_q() && this.searchBox.func_231042_a_(typedChar, modifiers)) {
            this.changeSearchSyntaxColor = true;
            return true;
        }
        return super.func_231042_a_(typedChar, modifiers);
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        if (this.searchBox != null && !this.searchBox.field_230693_o_) {
            ArrayList kids = Lists.newArrayList((Iterable)this.field_230705_e_);
            kids.remove(this.searchBox);
            return kids;
        }
        return this.field_230705_e_;
    }

    private void updateSearchBoxSyntaxHighlighting() {
        if (this.searchBox == null || !this.changeSearchSyntaxColor) {
            return;
        }
        String value = this.searchBox.func_146179_b();
        if (StringUtils.isBlank((CharSequence)value)) {
            int syntaxColor = 0xFFFFFF;
            this.searchBox.func_146193_g(syntaxColor);
            this.currentSearchSyntaxColor = syntaxColor;
            return;
        }
        List<ItemStack> results = ((FurnitureStationContainer)this.field_147002_h).getResults();
        if (!results.isEmpty()) {
            for (int j = this.startIndex; j < results.size(); ++j) {
                ItemStack resultItem = results.get(j);
                if (!this.isItemValid(resultItem)) continue;
                this.changeSearchSyntaxColor = false;
                int syntaxColor = DyeColor.GREEN.func_218388_g();
                this.searchBox.func_146193_g(syntaxColor);
                this.currentSearchSyntaxColor = syntaxColor;
                return;
            }
        }
        int syntaxColor = DyeColor.RED.func_218388_g();
        this.searchBox.func_146193_g(syntaxColor);
        this.currentSearchSyntaxColor = syntaxColor;
        this.changeSearchSyntaxColor = false;
    }

    private void renderSlotBackgrounds(MatrixStack pose, int mouseX, int mouseY) {
        Slot claySlot = ((FurnitureStationContainer)this.field_147002_h).getClaySlot();
        Slot woodSlot = ((FurnitureStationContainer)this.field_147002_h).getWoodSlot();
        Slot stoneSlot = ((FurnitureStationContainer)this.field_147002_h).getStoneSlot();
        this.clayIndex = this.renderSlotBackground(claySlot, FurnitureStation.CLAY, pose, mouseX, mouseY, this.clayIndex);
        this.woodIndex = this.renderSlotBackground(woodSlot, FurnitureStation.WOOD, pose, mouseX, mouseY, this.woodIndex);
        this.stoneIndex = this.renderSlotBackground(stoneSlot, FurnitureStation.STONE, pose, mouseX, mouseY, this.stoneIndex);
        ++this.cycleCounter;
        if (this.cycleCounter > 125) {
            this.cycleCounter = 0;
        }
    }

    private int renderSlotBackground(Slot slot, ITag.INamedTag<Item> backgroundTag, MatrixStack pose, int mouseX, int mouseY, int counter) {
        int index = counter;
        if (!slot.func_75216_d()) {
            ItemStack stack;
            List values = backgroundTag.func_230236_b_();
            if (this.cycleCounter == 125 && ++index >= values.size()) {
                index = 0;
            }
            int x = this.field_147003_i + slot.field_75223_e;
            int y = this.field_147009_r + slot.field_75221_f;
            Item item = (Item)values.get(index);
            FontRenderer stackFont = item.getFontRenderer(stack = item.func_190903_i());
            stackFont = stackFont == null ? this.field_230712_o_ : stackFont;
            this.renderTranslucentItem(stack, x, y);
            this.field_230707_j_.func_175030_a(stackFont, stack, x, y);
            if (this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && mouseX >= x && mouseY >= y && mouseX < x + 16 && mouseY < y + 16) {
                ITextComponent name = stack.func_200301_q();
                ITextComponent accepts = FurnitureStation.buildAcceptsAnyComponent(backgroundTag);
                this.renderWrappedToolTip(pose, Lists.newArrayList((Object[])new ITextComponent[]{name, accepts}), mouseX, mouseY, stackFont);
            }
        }
        return index;
    }

    private boolean isItemValid(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (this.searchBox == null) {
            return true;
        }
        if (!this.searchBox.func_146176_q() || !this.searchBox.field_230693_o_) {
            return true;
        }
        String value = this.searchBox.func_146179_b();
        if (StringUtils.isBlank((CharSequence)value)) {
            return true;
        }
        String[] values = value.split("\\s+");
        Item item = stack.func_77973_b();
        Set itemTagNames = item.getTags();
        String displayName = stack.func_200301_q().getString();
        for (String filter : values) {
            if (filter.startsWith("#")) {
                String rawTagName = filter.substring(1);
                for (ResourceLocation itemTagName : itemTagNames) {
                    String namespace = itemTagName.func_110624_b();
                    String path = itemTagName.func_110623_a();
                    if (!StringUtils.containsIgnoreCase((CharSequence)namespace, (CharSequence)rawTagName) && !StringUtils.containsIgnoreCase((CharSequence)path, (CharSequence)rawTagName)) continue;
                    return true;
                }
                continue;
            }
            if (filter.startsWith("@")) {
                String raw = filter.substring(1);
                String modId = item.getCreatorModId(stack);
                if (!StringUtils.containsIgnoreCase((CharSequence)modId, (CharSequence)raw)) continue;
                return true;
            }
            if (!StringUtils.containsIgnoreCase((CharSequence)displayName, (CharSequence)filter)) continue;
            return true;
        }
        return false;
    }

    private void renderResults(MatrixStack pose, int mouseX, int mouseY) {
        List<ItemStack> results = ((FurnitureStationContainer)this.field_147002_h).getResults();
        if (!results.isEmpty()) {
            Minecraft mc = this.getMinecraft();
            int centerX = (this.field_230708_k_ - this.field_146999_f) / 2;
            int centerY = (this.field_230709_l_ - this.field_147000_g) / 2;
            int yOffset = 0;
            boolean canHover = true;
            int maxY = centerY + 46 + 72;
            ItemStack selectedResult = ((FurnitureStationContainer)this.field_147002_h).getResultSlot().func_75211_c();
            int visibleItemIndex = 0;
            for (int j = this.startIndex; j < results.size(); ++j) {
                ItemStack resultItem = results.get(j);
                if (!this.isItemValid(resultItem)) continue;
                int resultItemX = centerX + 17 + 18 * (visibleItemIndex % 6);
                int resultItemY = centerY + 46 + yOffset;
                if (visibleItemIndex % 6 == 5) {
                    yOffset += 18;
                }
                if (resultItemY >= maxY) break;
                boolean isHovered = false;
                float vOffset = 0.0f;
                if (canHover) {
                    boolean bl = isHovered = mouseX >= resultItemX && mouseY >= resultItemY && mouseX < resultItemX + 18 && mouseY < resultItemY + 18;
                }
                if (isHovered) {
                    canHover = false;
                    vOffset = 36.0f;
                }
                if (!selectedResult.func_190926_b() && ItemStack.func_77989_b((ItemStack)selectedResult, (ItemStack)resultItem)) {
                    vOffset = 18.0f;
                }
                mc.field_71446_o.func_110577_a(TEXTURE);
                FurnitureStationContainerScreen.func_238463_a_((MatrixStack)pose, (int)(resultItemX - 1), (int)(resultItemY - 1), (float)176.0f, (float)vOffset, (int)18, (int)18, (int)256, (int)256);
                FontRenderer stackFont = resultItem.func_77973_b().getFontRenderer(resultItem);
                stackFont = stackFont == null ? this.field_230712_o_ : stackFont;
                this.field_230707_j_.func_175042_a(resultItem, resultItemX, resultItemY);
                this.field_230707_j_.func_175030_a(stackFont, resultItem, resultItemX, resultItemY);
                if (isHovered) {
                    this.func_230457_a_(pose, resultItem, mouseX, mouseY);
                }
                ++visibleItemIndex;
            }
        }
    }

    private boolean clickedResult(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton != 0) {
            return false;
        }
        List<ItemStack> results = ((FurnitureStationContainer)this.field_147002_h).getResults();
        if (!results.isEmpty()) {
            ItemStack selectedItem = ((FurnitureStationContainer)this.field_147002_h).getResultSlot().func_75211_c();
            int centerX = (this.field_230708_k_ - this.field_146999_f) / 2;
            int centerY = (this.field_230709_l_ - this.field_147000_g) / 2;
            int yOffset = 0;
            int maxY = centerY + 46 + 72;
            int visibleItemIndex = 0;
            for (int j = this.startIndex; j < results.size(); ++j) {
                ItemStack resultItem = results.get(j);
                if (!this.isItemValid(resultItem)) continue;
                boolean isSelected = false;
                if (!selectedItem.func_190926_b() && ItemStack.func_77989_b((ItemStack)selectedItem, (ItemStack)resultItem)) {
                    isSelected = true;
                }
                int resultItemX = centerX + 17 + 18 * (visibleItemIndex % 6);
                int resultItemY = centerY + 46 + yOffset;
                if (visibleItemIndex % 6 == 5) {
                    yOffset += 18;
                }
                if (resultItemY >= maxY) break;
                if (!isSelected && mouseX >= (double)resultItemX && mouseY >= (double)resultItemY && mouseX < (double)(resultItemX + 18) && mouseY < (double)(resultItemY + 18)) {
                    Minecraft mc = this.getMinecraft();
                    mc.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219720_mm, (float)1.0f));
                    mc.field_71442_b.func_78756_a(((FurnitureStationContainer)this.field_147002_h).field_75152_c, j);
                    return true;
                }
                ++visibleItemIndex;
            }
        }
        return false;
    }

    private void renderTranslucentItem(ItemStack stack, int x, int y) {
        boolean flag;
        if (stack.func_190926_b()) {
            return;
        }
        Minecraft mc = this.getMinecraft();
        IBakedModel model = this.field_230707_j_.func_184393_a(stack, null, null);
        RenderSystem.pushMatrix();
        mc.field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        mc.field_71446_o.func_229267_b_(AtlasTexture.field_110575_b).func_174937_a(false, false);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.translatef((float)x, (float)y, (float)(100.0f + (float)this.func_230927_p_()));
        RenderSystem.translatef((float)8.0f, (float)8.0f, (float)0.0f);
        RenderSystem.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
        RenderSystem.scalef((float)16.0f, (float)16.0f, (float)16.0f);
        MatrixStack pose = new MatrixStack();
        IRenderTypeBuffer.Impl buffer = mc.func_228019_au_().func_228487_b_();
        boolean bl = flag = !model.func_230044_c_();
        if (flag) {
            RenderHelper.func_227783_c_();
        }
        int color = 0xF000F0;
        int overlay = OverlayTexture.field_229196_a_;
        if (flag) {
            color = -1074790160;
        } else {
            overlay = OverlayTexture.func_229200_a_((float)0.45f, (boolean)false);
        }
        this.field_230707_j_.func_229111_a_(stack, ItemCameraTransforms.TransformType.GUI, false, pose, (IRenderTypeBuffer)buffer, color, overlay, model);
        buffer.func_228461_a_();
        RenderSystem.enableDepthTest();
        if (flag) {
            RenderHelper.func_227784_d_();
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        RenderSystem.popMatrix();
    }

    private boolean scrollbarActive() {
        return ((FurnitureStationContainer)this.field_147002_h).getResults().size() > 24;
    }
}

