/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.block.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import xyz.apex.forge.apexcore.lib.block.entity.BaseBlockEntity;
import xyz.apex.forge.apexcore.lib.util.INameableMutable;
import xyz.apex.forge.fantasyfurniture.init.Registrations;

public abstract class InventoryBlockEntity<CONTAINER extends Container>
extends BaseBlockEntity
implements INamedContainerProvider,
INameableMutable,
IContainerListener {
    public static final String NBT_INVENTORY = "Inventory";
    public static final String NBT_CUSTOM_NAME = "CustomName";
    @Nullable
    private ItemStackHandler inventory = null;
    private final LazyOptional<IItemHandler> itemHandlerCapability = LazyOptional.of(this::createItemHandler);
    @Nullable
    private ITextComponent customName = null;
    private final Registrations.ContainerFactory<CONTAINER> containerFactory;

    public InventoryBlockEntity(TileEntityType<? extends InventoryBlockEntity> blockEntityType, Registrations.ContainerFactory<CONTAINER> containerFactory) {
        super(blockEntityType);
        this.containerFactory = containerFactory;
        this.itemHandlerCapability.addListener(opt -> {
            this.inventory = null;
        });
    }

    public final IItemHandler getItemHandler() {
        return (IItemHandler)this.itemHandlerCapability.orElseGet(this::createItemHandler);
    }

    protected abstract ItemStackHandler createInventoryHandler();

    protected abstract ContainerType<CONTAINER> getContainerType();

    private IItemHandler createItemHandler() {
        if (this.inventory == null) {
            this.inventory = this.createInventoryHandler();
        }
        return this.inventory;
    }

    public final Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
        CONTAINER drawerContainer = this.containerFactory.create(this.getContainerType(), windowId, playerInventory, this.getItemHandler());
        drawerContainer.func_75132_a((IContainerListener)this);
        return drawerContainer;
    }

    public void setCustomName(@Nullable ITextComponent customName) {
        this.customName = customName;
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT tagCompound) {
        if (tagCompound.func_150297_b(NBT_INVENTORY, 10)) {
            this.itemHandlerCapability.invalidate();
            this.inventory = this.createInventoryHandler();
            CompoundNBT inventoryTag = tagCompound.func_74775_l(NBT_INVENTORY);
            this.inventory.deserializeNBT(inventoryTag);
        }
        if (tagCompound.func_150297_b(NBT_CUSTOM_NAME, 8)) {
            String customNameJson = tagCompound.func_74779_i(NBT_CUSTOM_NAME);
            this.customName = ITextComponent.Serializer.func_240643_a_((String)customNameJson);
        }
        super.func_230337_a_(blockState, tagCompound);
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        if (this.inventory != null) {
            CompoundNBT inventoryTag = this.inventory.serializeNBT();
            tagCompound.func_218657_a(NBT_INVENTORY, (INBT)inventoryTag);
        }
        if (this.customName != null) {
            String customNameJson = ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName);
            tagCompound.func_74778_a(NBT_CUSTOM_NAME, customNameJson);
        }
        return super.func_189515_b(tagCompound);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandlerCapability.cast();
        }
        return super.getCapability(capability, side);
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.customName;
    }

    public ITextComponent func_145748_c_() {
        return this.customName == null ? this.func_200200_C_() : this.customName;
    }

    public ITextComponent func_200200_C_() {
        return new TranslationTextComponent(this.func_195044_w().func_177230_c().func_149739_a());
    }

    public void func_71110_a(Container container, NonNullList<ItemStack> stacks) {
    }

    public void func_71111_a(Container container, int slotIndex, ItemStack stack) {
        this.func_70296_d();
    }

    public void func_71112_a(Container container, int varToUpdate, int newValue) {
    }

    protected CompoundNBT writeUpdateTag(CompoundNBT tagCompound) {
        if (this.inventory != null) {
            CompoundNBT inventoryTag = this.inventory.serializeNBT();
            tagCompound.func_218657_a(NBT_INVENTORY, (INBT)inventoryTag);
        }
        if (this.customName != null) {
            String customNameJson = ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName);
            tagCompound.func_74778_a(NBT_CUSTOM_NAME, customNameJson);
        }
        return super.writeUpdateTag(tagCompound);
    }

    protected void readeUpdateTag(CompoundNBT tagCompound) {
        if (tagCompound.func_150297_b(NBT_INVENTORY, 10)) {
            this.itemHandlerCapability.invalidate();
            this.inventory = this.createInventoryHandler();
            CompoundNBT inventoryTag = tagCompound.func_74775_l(NBT_INVENTORY);
            this.inventory.deserializeNBT(inventoryTag);
        }
        if (tagCompound.func_150297_b(NBT_CUSTOM_NAME, 8)) {
            String customNameJson = tagCompound.func_74779_i(NBT_CUSTOM_NAME);
            this.customName = ITextComponent.Serializer.func_240643_a_((String)customNameJson);
        }
        super.readeUpdateTag(tagCompound);
    }
}

