/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.block.base.core;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import xyz.apex.forge.fantasyfurniture.entity.SeatEntity;

public interface ISeatBlock {
    public static final BooleanProperty OCCUPIED = BlockStateProperties.field_208192_s;

    public String getOccupiedTranslationKey();

    default public IFormattableTextComponent getOccupiedTranslation() {
        return new TranslationTextComponent(this.getOccupiedTranslationKey());
    }

    default public ActionResultType useSeatBlock(BlockState blockState, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (level.field_72995_K) {
            return ActionResultType.CONSUME;
        }
        BlockPos sitPos = this.getSeatSitPos(blockState, pos);
        if (ISeatBlock.isSeatOccupied(level, sitPos, player, this)) {
            player.func_146105_b((ITextComponent)this.getOccupiedTranslation(), true);
            return ActionResultType.SUCCESS;
        }
        return this.trySitInSeat(level, pos, player);
    }

    default public double getSeatYOffset(BlockState blockState) {
        return 0.0;
    }

    default public BlockPos getSeatSitPos(BlockState blockState, BlockPos pos) {
        return pos;
    }

    default public AxisAlignedBB getSeatOccupiedArea(BlockState blockState, BlockPos pos) {
        return new AxisAlignedBB(pos).func_72314_b(0.0, 1.0, 0.0);
    }

    default public ActionResultType trySitInSeat(World level, BlockPos pos, PlayerEntity player) {
        BlockState blockState = level.func_180495_p(pos);
        BlockPos sitPos = this.getSeatSitPos(blockState, pos);
        if (SeatEntity.create(level, sitPos, this, player)) {
            ISeatBlock.setSeatOccupied(level, pos, true);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    default public void setSeatOccupied(World level, BlockPos pos, BlockState blockState, boolean occupied) {
        level.func_180501_a(pos, (BlockState)blockState.func_206870_a((Property)OCCUPIED, (Comparable)Boolean.valueOf(occupied)), 3);
    }

    public static void setSeatOccupied(World level, BlockPos pos, boolean occupied) {
        BlockState blockState = level.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (block instanceof ISeatBlock) {
            ((ISeatBlock)block).setSeatOccupied(level, pos, blockState, occupied);
        }
    }

    public static boolean isSeatOccupied(World level, BlockPos pos, PlayerEntity sitter, ISeatBlock seatBlock) {
        BlockState blockState = level.func_180495_p(pos);
        BlockPos seatPos = seatBlock.getSeatSitPos(blockState, pos);
        return level.func_180495_p(seatPos).func_235903_d_((Property)OCCUPIED).orElse(false);
    }
}

