/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.block.base.core;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.TransportationHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;
import xyz.apex.forge.apexcore.lib.multiblock.MultiBlockPattern;
import xyz.apex.forge.fantasyfurniture.block.base.core.SimpleFourWayWaterLoggedMultiBlock;

public abstract class BedBlock
extends SimpleFourWayWaterLoggedMultiBlock {
    public static final BooleanProperty OCCUPIED = BlockStateProperties.field_208192_s;

    public BedBlock(AbstractBlock.Properties properties, MultiBlockPattern pattern) {
        super(properties, pattern);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)OCCUPIED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    @Nullable
    protected BlockState getPlacementState(BlockItemUseContext ctx, BlockState defaultBlockState) {
        BlockState blockState = super.getPlacementState(ctx, defaultBlockState);
        if (blockState != null) {
            return (BlockState)blockState.func_206870_a((Property)FACING, (Comparable)ctx.func_195992_f());
        }
        return null;
    }

    protected abstract int getBedFootMultiBlockIndex(BlockState var1);

    public PushReaction func_149656_h(BlockState blockState) {
        return PushReaction.DESTROY;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{OCCUPIED});
        super.func_206840_a(builder);
    }

    public ActionResultType func_225533_a_(BlockState blockState, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        if (level.field_72995_K) {
            return ActionResultType.CONSUME;
        }
        BlockPos footPos = BedBlock.getBedFootPos(this, blockState, pos);
        BlockState footBlockState = blockState;
        if (!footPos.equals((Object)pos)) {
            footBlockState = level.func_180495_p(footPos);
        }
        if (!footBlockState.func_203425_a((Block)this)) {
            return ActionResultType.CONSUME;
        }
        if (!BedBlock.canSetSpawn(level)) {
            return this.onBadBedSetSpawn(level, footBlockState, footPos, player, hand);
        }
        if (((Boolean)footBlockState.func_177229_b((Property)OCCUPIED)).booleanValue()) {
            return this.onBedOccupied(level, footBlockState, footPos, player, hand);
        }
        return this.onSleepInBed(level, footBlockState, footPos, player, hand);
    }

    public void func_180658_a(World level, BlockPos pos, Entity entity, float dist) {
        super.func_180658_a(level, pos, entity, dist * 0.5f);
    }

    public void func_176216_a(IBlockReader level, Entity entity) {
        if (entity.func_226272_bl_()) {
            super.func_176216_a(level, entity);
        } else {
            BedBlock.bounceUp(entity);
        }
    }

    public boolean isBed(BlockState blockState, IBlockReader level, BlockPos pos, @Nullable Entity player) {
        return blockState.func_203425_a((Block)this);
    }

    public void setBedOccupied(BlockState blockState, World level, BlockPos pos, LivingEntity sleeper, boolean occupied) {
        BlockPos footPos = BedBlock.getBedFootPos(this, blockState, pos);
        BlockState footBlockState = level.func_180495_p(footPos);
        BlockPos headPos = footPos.func_177972_a((Direction)footBlockState.func_177229_b((Property)FACING));
        BlockState headBlockState = level.func_180495_p(headPos);
        super.setBedOccupied(footBlockState, level, footPos, sleeper, occupied);
        super.setBedOccupied(headBlockState, level, headPos, sleeper, occupied);
    }

    public Optional<Vector3d> getBedSpawnPosition(EntityType<?> entityType, BlockState blockState, IWorldReader level, BlockPos pos, float orientation, @Nullable LivingEntity sleeper) {
        Optional<Vector3d> standUpPosition = BedBlock.findStandUpPosition(entityType, (ICollisionReader)level, pos, orientation);
        if (standUpPosition.isPresent()) {
            return standUpPosition;
        }
        return super.getBedSpawnPosition(entityType, blockState, level, pos, orientation, sleeper);
    }

    public boolean func_196266_a(BlockState blockState, IBlockReader level, BlockPos pos, PathType pathType) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onFixBedRotations(LivingEntity entity, MatrixStack pose) {
    }

    protected ActionResultType onBadBedSetSpawn(World level, BlockState blockState, BlockPos pos, PlayerEntity player, Hand hand) {
        level.func_217377_a(pos, false);
        level.func_230546_a_(null, DamageSource.func_233546_a_(), null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 5.0f, true, Explosion.Mode.DESTROY);
        return ActionResultType.SUCCESS;
    }

    protected ActionResultType onBedOccupied(World level, BlockState blockState, BlockPos pos, PlayerEntity player, Hand hand) {
        if (!BedBlock.kickVillagerOutOfBed(level, pos)) {
            player.func_146105_b((ITextComponent)this.getOccupiedTranslation(), true);
        }
        return ActionResultType.SUCCESS;
    }

    protected ActionResultType onSleepInBed(World level, BlockState blockState, BlockPos pos, PlayerEntity player, Hand hand) {
        Direction facing = (Direction)blockState.func_177229_b((Property)FACING);
        BlockPos sleepPos = pos.func_177972_a(facing);
        player.func_213819_a(sleepPos).ifLeft(result -> {
            if (result != null) {
                player.func_146105_b(result.func_221259_a(), true);
            }
        });
        return ActionResultType.SUCCESS;
    }

    public String getOccupiedTranslationKey() {
        return this.func_149739_a() + ".occupied";
    }

    public IFormattableTextComponent getOccupiedTranslation() {
        return new TranslationTextComponent(this.getOccupiedTranslationKey());
    }

    public static boolean kickVillagerOutOfBed(World level, BlockPos pos) {
        List villagersInBed = level.func_217394_a(EntityType.field_200756_av, new AxisAlignedBB(pos), LivingEntity::func_70608_bn);
        if (villagersInBed.isEmpty()) {
            return false;
        }
        ((VillagerEntity)villagersInBed.get(0)).func_213366_dy();
        return true;
    }

    public static void bounceUp(Entity entity) {
        Vector3d delta = entity.func_213322_ci();
        if (delta.field_72448_b < 0.0) {
            double d = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.func_213293_j(delta.field_72450_a, -delta.field_72448_b * (double)0.66f * d, delta.field_72449_c);
        }
    }

    public static BlockPos getBedFootPos(BedBlock bed, BlockState blockState, BlockPos pos) {
        int footIndex = bed.getBedFootMultiBlockIndex(blockState);
        MultiBlockPattern pattern = bed.getMultiBlockPattern();
        int currentIndex = pattern.getIndex(blockState);
        if (currentIndex == footIndex) {
            return pos;
        }
        List localPositions = pattern.getLocalPositions();
        BlockPos localSpace = (BlockPos)localPositions.get(currentIndex);
        BlockPos origin = pattern.getOriginFromWorldSpace(blockState, pos, localSpace);
        BlockPos footLocalSPace = (BlockPos)localPositions.get(footIndex);
        return pattern.getWorldSpaceFromLocalSpace(blockState, origin, footLocalSPace);
    }

    public static boolean canSetSpawn(World level) {
        return net.minecraft.block.BedBlock.func_235330_a_((World)level);
    }

    public static boolean isBedBlock(BlockState blockState) {
        Block block = blockState.func_177230_c();
        if (block instanceof BedBlock || block instanceof net.minecraft.block.BedBlock) {
            return true;
        }
        return blockState.func_235714_a_((ITag)BlockTags.field_219747_F);
    }

    public static boolean isBunkBed(IBlockReader level, BlockPos pos) {
        return BedBlock.isBedBlock(level.func_180495_p(pos.func_177977_b())) || BedBlock.isBedBlock(level.func_180495_p(pos.func_177984_a()));
    }

    public static Optional<Vector3d> findStandUpPosition(EntityType<?> entityType, ICollisionReader level, BlockPos pos, float f) {
        Direction dir;
        Direction facing = (Direction)level.func_180495_p(pos).func_177229_b((Property)FACING);
        Direction facingClockWise = facing.func_176746_e();
        Direction direction = dir = facingClockWise.func_243532_a(f) ? facingClockWise.func_176734_d() : facingClockWise;
        if (BedBlock.isBunkBed((IBlockReader)level, pos)) {
            return BedBlock.findBunkBedStandUpPosition(entityType, level, pos, facing, dir);
        }
        int[][] aint = BedBlock.bedStandUpOffsets(facing, dir);
        Optional<Vector3d> optional = BedBlock.findStandUpPositionAtOffset(entityType, level, pos, aint, true);
        return optional.isPresent() ? optional : BedBlock.findStandUpPositionAtOffset(entityType, level, pos, aint, false);
    }

    private static Optional<Vector3d> findBunkBedStandUpPosition(EntityType<?> entityType, ICollisionReader level, BlockPos pos, Direction dirA, Direction dirB) {
        int[][] aint = BedBlock.bedSurroundStandUpOffsets(dirA, dirB);
        Optional<Vector3d> optional = BedBlock.findStandUpPositionAtOffset(entityType, level, pos, aint, true);
        if (optional.isPresent()) {
            return optional;
        }
        BlockPos below = pos.func_177977_b();
        Optional<Vector3d> belowOptional = BedBlock.findStandUpPositionAtOffset(entityType, level, below, aint, true);
        if (belowOptional.isPresent()) {
            return belowOptional;
        }
        int[][] aint1 = BedBlock.bedAboveStandUpOffsets(dirA);
        Optional<Vector3d> optA = BedBlock.findStandUpPositionAtOffset(entityType, level, pos, aint1, true);
        if (optA.isPresent()) {
            return optA;
        }
        Optional<Vector3d> optB = BedBlock.findStandUpPositionAtOffset(entityType, level, pos, aint, false);
        if (optB.isPresent()) {
            return optB;
        }
        Optional<Vector3d> optC = BedBlock.findStandUpPositionAtOffset(entityType, level, below, aint, false);
        return optC.isPresent() ? optC : BedBlock.findStandUpPositionAtOffset(entityType, level, pos, aint1, false);
    }

    private static Optional<Vector3d> findStandUpPositionAtOffset(EntityType<?> entityType, ICollisionReader level, BlockPos pos, int[][] ints, boolean flag) {
        BlockPos.Mutable posMutable = new BlockPos.Mutable();
        for (int[] aint : ints) {
            posMutable.func_181079_c(pos.func_177958_n() + aint[0], pos.func_177956_o(), pos.func_177952_p() + aint[1]);
            Vector3d vector3d = TransportationHelper.func_242379_a(entityType, (ICollisionReader)level, (BlockPos)posMutable, (boolean)flag);
            if (vector3d == null) continue;
            return Optional.of(vector3d);
        }
        return Optional.empty();
    }

    private static int[][] bedStandUpOffsets(Direction dirA, Direction dirB) {
        return (int[][])ArrayUtils.addAll((Object[])BedBlock.bedSurroundStandUpOffsets(dirA, dirB), (Object[])BedBlock.bedAboveStandUpOffsets(dirA));
    }

    private static int[][] bedSurroundStandUpOffsets(Direction dirA, Direction dirB) {
        int dirAStepX = dirA.func_82601_c();
        int dirAStepZ = dirA.func_82599_e();
        int dirBStepX = dirB.func_82601_c();
        int dirBStepZ = dirB.func_82599_e();
        return new int[][]{{dirBStepX, dirBStepZ}, {dirBStepX - dirAStepX, dirBStepZ - dirAStepZ}, {dirBStepX - dirAStepX * 2, dirBStepZ - dirAStepZ * 2}, {-dirAStepX * 2, -dirAStepZ * 2}, {-dirBStepX - dirAStepX * 2, -dirBStepZ - dirAStepZ * 2}, {-dirBStepX - dirAStepX, -dirBStepZ - dirAStepZ}, {-dirBStepX, -dirBStepZ}, {-dirBStepX + dirAStepX, -dirBStepZ + dirAStepZ}, {dirAStepX, dirAStepZ}, {dirBStepX + dirAStepX, dirBStepZ + dirAStepZ}};
    }

    private static int[][] bedAboveStandUpOffsets(Direction dir) {
        return new int[][]{{0, 0}, {-dir.func_82601_c(), -dir.func_82599_e()}};
    }
}

