/*
 * Decompiled with CFR 0.152.
 */
package com.mcwwindows.kikoz.objects;

import com.mcwwindows.kikoz.init.ItemInit;
import com.mcwwindows.kikoz.init.SoundsInit;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class WindowBarred
extends Block {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final EnumProperty<WindowState> WINDOWSTATE = EnumProperty.func_177709_a((String)"windowstate", WindowState.class);
    protected static final VoxelShape EE = WindowBarred.func_208617_a((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    protected static final VoxelShape NN = WindowBarred.func_208617_a((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);
    protected static final VoxelShape FIX = WindowBarred.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.1, (double)0.0);

    public WindowBarred(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)Direction.NORTH)).func_206870_a(WINDOWSTATE, (Comparable)((Object)WindowState.CLOSED)));
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        WindowState windowState = (WindowState)((Object)state.func_177229_b(WINDOWSTATE));
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        if (windowState == WindowState.OPEN_LEFT || windowState == WindowState.OPEN_RIGHT) {
            return FIX;
        }
        if (direction == Direction.NORTH || direction == Direction.SOUTH) {
            return EE;
        }
        return NN;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f());
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        WindowState newState;
        ItemStack itemstack = player.func_184586_b(handIn);
        Item item = itemstack.func_77973_b();
        WindowState windowState = (WindowState)((Object)state.func_177229_b(WINDOWSTATE));
        if (item == ItemInit.KEY.get()) {
            this.lockWindow(level, pos, windowState != WindowState.LOCKED, (Direction)state.func_177229_b((Property)FACING), 1000);
            level.func_184133_a(null, pos, SoundEvents.field_187614_cJ, SoundCategory.BLOCKS, 0.5f, level.field_73012_v.nextFloat() * 0.1f + 0.8f);
            state = (BlockState)state.func_206870_a(WINDOWSTATE, (Comparable)((Object)(windowState == WindowState.LOCKED ? WindowState.CLOSED : WindowState.LOCKED)));
            level.func_180501_a(pos, state, 10);
            return ActionResultType.SUCCESS;
        }
        if (windowState == WindowState.LOCKED || item == this.func_199767_j()) {
            return ActionResultType.PASS;
        }
        if (windowState == WindowState.CLOSED) {
            newState = this.getHingeDirectionFromContext(pos, (Direction)state.func_177229_b((Property)FACING), hit.func_216347_e());
            this.toggleWindowState(level, pos, newState);
            level.func_184133_a(null, pos, (SoundEvent)SoundsInit.WINDOW_OPEN.get(), SoundCategory.BLOCKS, 0.5f, level.field_73012_v.nextFloat() * 0.1f + 0.8f);
        } else {
            newState = WindowState.CLOSED;
            this.toggleWindowState(level, pos, newState);
            level.func_184133_a(null, pos, (SoundEvent)SoundsInit.WINDOW_CLOSE.get(), SoundCategory.BLOCKS, 0.5f, level.field_73012_v.nextFloat() * 0.1f + 0.8f);
        }
        state = (BlockState)state.func_206870_a(WINDOWSTATE, (Comparable)((Object)newState));
        level.func_180501_a(pos, state, 10);
        return ActionResultType.SUCCESS;
    }

    private WindowState getHingeDirectionFromContext(BlockPos blockpos, Direction direction, Vector3d clickLocation) {
        int j = direction.func_82601_c();
        int k = direction.func_82599_e();
        double d0 = clickLocation.field_72450_a - (double)blockpos.func_177958_n();
        double d1 = clickLocation.field_72449_c - (double)blockpos.func_177952_p();
        boolean left = !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5);
        return left ? WindowState.OPEN_RIGHT : WindowState.OPEN_LEFT;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return mirror == Mirror.NONE ? state : state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return ((Direction)state.func_177229_b((Property)FACING)).func_176740_k() == Direction.Axis.X ? NN : EE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, WINDOWSTATE});
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState updatePostPlacement(BlockState stateIn, Direction facing, BlockState facingState, World worldIn, BlockPos currentPos, BlockPos facingPos) {
        return super.func_196271_a(stateIn, facing, facingState, (IWorld)worldIn, currentPos, facingPos);
    }

    private void toggleWindowState(World world, BlockPos pos, WindowState newState) {
        BlockState state = world.func_180495_p(pos);
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        if (state.func_177229_b(WINDOWSTATE) == newState) {
            return;
        }
        world.func_175656_a(pos, (BlockState)state.func_206870_a(WINDOWSTATE, (Comparable)((Object)newState)));
        this.toggleAdjacentWindows(world, pos.func_177984_a(), facing, newState, 0, 100);
        this.toggleAdjacentWindows(world, pos.func_177977_b(), facing, newState, 0, 100);
    }

    private void toggleAdjacentWindows(World world, BlockPos pos, Direction facing, WindowState newState, int depth, int maxDepth) {
        BlockState state = world.func_180495_p(pos);
        if (depth > maxDepth || state.func_177230_c() != this || state.func_177229_b((Property)FACING) != facing) {
            return;
        }
        if (state.func_177229_b(WINDOWSTATE) != newState) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a(WINDOWSTATE, (Comparable)((Object)newState)));
            this.toggleAdjacentWindows(world, pos.func_177984_a(), facing, newState, depth + 1, maxDepth);
            this.toggleAdjacentWindows(world, pos.func_177977_b(), facing, newState, depth + 1, maxDepth);
        }
    }

    private void lockWindow(World world, BlockPos pos, boolean targetOpen, Direction targetDirection, int depth) {
        if (depth <= 0) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this) {
            boolean isLocked = state.func_177229_b(WINDOWSTATE) == WindowState.LOCKED;
            Direction direction = (Direction)state.func_177229_b((Property)FACING);
            if (isLocked != targetOpen && direction.equals((Object)targetDirection)) {
                world.func_175656_a(pos, (BlockState)state.func_206870_a(WINDOWSTATE, (Comparable)((Object)(targetOpen ? WindowState.LOCKED : WindowState.CLOSED))));
                Direction[] directions = direction.func_176740_k() == Direction.Axis.X ? new Direction[]{Direction.SOUTH, Direction.NORTH} : new Direction[]{Direction.EAST, Direction.WEST};
                for (Direction dir : directions) {
                    this.lockWindow(world, pos.func_177972_a(dir), targetOpen, targetDirection, depth - 2);
                }
                for (int y = 1; y <= 2; ++y) {
                    this.lockWindow(world, pos.func_177981_b(y), targetOpen, targetDirection, depth - 2);
                    this.lockWindow(world, pos.func_177979_c(y), targetOpen, targetDirection, depth - 2);
                }
            }
        }
    }

    public static enum WindowState implements IStringSerializable
    {
        CLOSED("closed"),
        OPEN_LEFT("open_left"),
        OPEN_RIGHT("open_right"),
        LOCKED("locked");

        private final String name;

        private WindowState(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

