/*
 * Decompiled with CFR 0.152.
 */
package com.mcwwindows.kikoz.objects;

import com.mcwwindows.kikoz.init.SoundsInit;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class Shutter
extends Block {
    protected static final VoxelShape SOUTH_LEFT = Block.func_208617_a((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)11.0);
    protected static final VoxelShape SOUTH_RIGHT = Block.func_208617_a((double)14.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_LEFT = Block.func_208617_a((double)5.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_RIGHT = Block.func_208617_a((double)0.0, (double)0.0, (double)14.0, (double)11.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_LEFT = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)2.0);
    protected static final VoxelShape EAST_RIGHT = Block.func_208617_a((double)5.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    protected static final VoxelShape NORTH_LEFT = Block.func_208617_a((double)0.0, (double)0.0, (double)5.0, (double)2.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_RIGHT = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)11.0);
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty OPEN = BlockStateProperties.field_208193_t;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.field_208142_aq;

    public Shutter(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a(HINGE, (Comparable)DoorHingeSide.LEFT));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader blockReader, BlockPos pos, ISelectionContext selectionContext) {
        DoorHingeSide hinge = (DoorHingeSide)state.func_177229_b(HINGE);
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                if (hinge == DoorHingeSide.RIGHT) {
                    return NORTH_RIGHT;
                }
                return NORTH_LEFT;
            }
            case SOUTH: {
                if (hinge == DoorHingeSide.RIGHT) {
                    return SOUTH_RIGHT;
                }
                return SOUTH_LEFT;
            }
            case WEST: {
                if (hinge == DoorHingeSide.RIGHT) {
                    return WEST_RIGHT;
                }
                return WEST_LEFT;
            }
        }
        if (hinge == DoorHingeSide.RIGHT) {
            return EAST_RIGHT;
        }
        return EAST_LEFT;
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader getter, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (item == this.func_199767_j()) {
            return ActionResultType.PASS;
        }
        this.toggleShutter(level, pos, (Boolean)state.func_177229_b((Property)OPEN) == false, (Direction)state.func_177229_b((Property)FACING), 100);
        level.func_184133_a(null, pos, (SoundEvent)SoundsInit.WINDOW_OPEN.get(), SoundCategory.BLOCKS, 0.5f, level.field_73012_v.nextFloat() * 0.1f + 0.8f);
        state = (BlockState)state.func_235896_a_((Property)OPEN);
        level.func_180501_a(pos, state, 2);
        return ActionResultType.SUCCESS;
    }

    private DoorHingeSide getHinge(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        Direction direction = context.func_195992_f();
        int j = direction.func_82601_c();
        int k = direction.func_82599_e();
        Vector3d vector3d = context.func_221532_j();
        double d0 = vector3d.field_72450_a - (double)blockpos.func_177958_n();
        double d1 = vector3d.field_72449_c - (double)blockpos.func_177952_p();
        return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a(HINGE, (Comparable)this.getHinge(context))).func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176746_e());
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, OPEN, HINGE});
    }

    public BlockState func_196271_a(BlockState state, Direction dir, BlockState statetwo, IWorld access, BlockPos pos, BlockPos postwo) {
        return super.func_196271_a(state, dir, statetwo, access, pos, postwo);
    }

    private void toggleShutter(World world, BlockPos pos, boolean targetOpen, Direction targetDirection, int depth) {
        if (depth <= 0) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return;
        }
        boolean open = (Boolean)state.func_177229_b((Property)OPEN);
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        if (open != targetOpen && direction.equals((Object)targetDirection)) {
            BlockPos[] positions;
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(targetOpen)));
            for (BlockPos newPos : positions = new BlockPos[]{pos.func_177970_e(1), pos.func_177964_d(1), pos.func_177965_g(1), pos.func_177985_f(1), pos.func_177979_c(1), pos.func_177979_c(2), pos.func_177981_b(1)}) {
                this.toggleShutter(world, newPos, targetOpen, targetDirection, depth - 2);
            }
        }
    }
}

