/*
 * Decompiled with CFR 0.152.
 */
package com.mcwwindows.kikoz.objects;

import com.mcwwindows.kikoz.init.SoundsInit;
import com.mcwwindows.kikoz.objects.WindowBase;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class Blinds
extends WindowBase {
    private static final EnumProperty<GaragePart> PART = EnumProperty.func_177709_a((String)"part", GaragePart.class);
    private static final EnumProperty<BlindsState> BLINDSSTATE = EnumProperty.func_177709_a((String)"blindsstate", BlindsState.class);
    String infoname;
    boolean hasTextInfo = true;
    protected static final VoxelShape WEST = VoxelShapes.func_216384_a((VoxelShape)Blinds.func_208617_a((double)12.0, (double)0.0, (double)0.0, (double)15.9, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape SOUTH = VoxelShapes.func_216384_a((VoxelShape)Blinds.func_208617_a((double)0.0, (double)0.0, (double)0.1, (double)16.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape EAST = VoxelShapes.func_216384_a((VoxelShape)Blinds.func_208617_a((double)0.1, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape NORTH = VoxelShapes.func_216384_a((VoxelShape)Blinds.func_208617_a((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)15.9), (VoxelShape[])new VoxelShape[0]);

    public VoxelShape func_220053_a(BlockState state, IBlockReader blockReader, BlockPos pos, ISelectionContext selectionContext) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
        }
        return null;
    }

    public Blinds(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(BLINDSSTATE, (Comparable)((Object)BlindsState.OPEN))).func_206870_a(PART, (Comparable)((Object)GaragePart.BOTTOM)));
    }

    @Override
    protected BlockState WindowState(BlockState state, IWorld level, BlockPos pos) {
        boolean below;
        boolean above = level.func_180495_p(pos.func_177984_a()).func_177230_c() == this;
        boolean bl = below = level.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
        if (above && below) {
            return (BlockState)state.func_206870_a(PART, (Comparable)((Object)GaragePart.BOTTOM));
        }
        if (!above && below) {
            return (BlockState)state.func_206870_a(PART, (Comparable)((Object)GaragePart.TOP));
        }
        if (above && !below) {
            return (BlockState)state.func_206870_a(PART, (Comparable)((Object)GaragePart.BOTTOM));
        }
        return (BlockState)state.func_206870_a(PART, (Comparable)((Object)GaragePart.TOP));
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.WindowState(super.func_196258_a(context), (IWorld)context.func_195991_k(), context.func_195995_a()).func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PART, FACING, BLINDSSTATE});
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemstack = player.func_184586_b(handIn);
        Item item = itemstack.func_77973_b();
        if (item != this.func_199767_j()) {
            BlindsState currentState = (BlindsState)((Object)state.func_177229_b(BLINDSSTATE));
            BlindsState nextState = this.cycleBlindsState(currentState);
            worldIn.func_184133_a(null, pos, (SoundEvent)SoundsInit.BLINDS_CLOSE.get(), SoundCategory.BLOCKS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.8f);
            this.toggleBlinds(worldIn, pos, nextState, (Direction)state.func_177229_b((Property)FACING), 1000);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public BlockState updatePostPlacement(BlockState stateIn, Direction facing, BlockState facingState, World worldIn, BlockPos currentPos, BlockPos facingPos) {
        return super.updatePostPlacement(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public int func_200011_d(BlockState state, IBlockReader reader, BlockPos pos) {
        BlindsState currentState = (BlindsState)((Object)state.func_177229_b(BLINDSSTATE));
        if (currentState == BlindsState.CLOSED) {
            return reader.func_201572_C();
        }
        return 0;
    }

    private void toggleBlinds(World world, BlockPos pos, BlindsState targetState, Direction targetDirection, int depth) {
        if (depth <= 0) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return;
        }
        BlindsState currentState = (BlindsState)((Object)state.func_177229_b(BLINDSSTATE));
        if (currentState != targetState) {
            BlockPos[] positions;
            world.func_175656_a(pos, (BlockState)state.func_206870_a(BLINDSSTATE, (Comparable)((Object)targetState)));
            for (BlockPos newPos : positions = new BlockPos[]{pos.func_177968_d(), pos.func_177978_c(), pos.func_177974_f(), pos.func_177976_e(), pos.func_177977_b(), pos.func_177984_a()}) {
                this.toggleBlinds(world, newPos, targetState, targetDirection, depth - 1);
            }
        }
    }

    private BlindsState cycleBlindsState(BlindsState currentState) {
        switch (currentState) {
            case CLOSED: {
                return BlindsState.OPEN;
            }
            case OPEN: {
                return BlindsState.RAISED;
            }
        }
        return BlindsState.CLOSED;
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity entity) {
        BlindsState raised = (BlindsState)((Object)state.func_177229_b(BLINDSSTATE));
        GaragePart part = (GaragePart)((Object)state.func_177229_b(PART));
        if (raised == BlindsState.RAISED && part == GaragePart.BOTTOM) {
            return;
        }
        world.func_217378_a(entity, 2001, pos, Blinds.func_196246_j((BlockState)state));
    }

    public static enum GaragePart implements IStringSerializable
    {
        TOP("top"),
        BOTTOM("bottom");

        private final String name;

        private GaragePart(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }

    public static enum BlindsState implements IStringSerializable
    {
        CLOSED("closed"),
        OPEN("open"),
        RAISED("raised");

        private final String name;

        private BlindsState(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

