/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.woodcutter.command;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jline.utils.Levenshtein;
import ovh.corail.woodcutter.command.WoodcuttingJsonRecipe;
import ovh.corail.woodcutter.compatibility.SupportMods;
import ovh.corail.woodcutter.helper.LangKey;

@Mod.EventBusSubscriber(modid="corail_woodcutter", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommandWoodcutter {
    private final Set<Item> logs = new HashSet<Item>();
    private final Map<Item, WoodCompo> plankToLog = new HashMap<Item, WoodCompo>();
    private static final String MODID_PARAM = "modid";
    private static final int PACK_FORMAT = 5;
    private static final Predicate<ItemStack> VANILLA_ITEM = stack -> Optional.ofNullable(stack.func_77973_b().getRegistryName()).map(ResourceLocation::func_110624_b).map("minecraft"::equals).orElse(false);
    private static final Predicate<ItemStack> VALID_RESULT = result -> !result.func_190926_b() && !VANILLA_ITEM.test((ItemStack)result);
    private static final Predicate<ItemStack> NON_VANILLA_PLANKS = stack -> VALID_RESULT.test((ItemStack)stack) && (ItemTags.field_199905_b.func_230235_a_((Object)stack.func_77973_b()) || Optional.ofNullable(stack.func_77973_b().getRegistryName()).map(ResourceLocation::func_110623_a).map(e -> e.endsWith("_planks")).orElse(false) != false);
    private static final Predicate<String> INVALID_MODID = modid -> modid == null || "minecraft".equals(modid) || !ModList.get().isLoaded(modid) || SupportMods.hasSupport(modid);
    private static final BiPredicate<String, String> ALMOSTLY_SIMILAR = (s1, s2) -> Levenshtein.distance((CharSequence)s1, (CharSequence)s2, (int)1, (int)0, (int)1, (int)10) <= 3;
    private static final BiFunction<MinecraftServer, String, File> DATAPACK_FOLDER = (server, folder) -> new File(server.func_240776_a_(FolderName.field_237251_g_).toFile(), (String)folder);
    private static final Function<String, File> CONFIG_FOLDER = folder -> new File(FMLPaths.CONFIGDIR.get().toFile(), "corail_woodcutter" + File.separatorChar + folder);
    private static final SuggestionProvider<CommandSource> SUGGESTION_MODID = (ctx, build) -> ISuggestionProvider.func_197013_a(ModList.get().applyForEachModContainer(ModContainer::getModId).filter(SupportMods::noSupport).filter(modid -> !"minecraft".equals(modid)), (SuggestionsBuilder)build);
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();

    private CommandWoodcutter() {
    }

    private int showUsage(CommandContext<CommandSource> context) {
        ((CommandSource)context.getSource()).func_197030_a(LangKey.COMMAND_USAGE.getText(new Object[0]), false);
        return 1;
    }

    private int applyDataPack(CommandContext<CommandSource> context) {
        String modid = StringArgumentType.getString(context, (String)MODID_PARAM);
        if (INVALID_MODID.test(modid)) {
            throw LangKey.INVALID_MODID.asCommandException(new Object[0]);
        }
        String zipName = this.getZipName(modid);
        File configDatapackZip = CONFIG_FOLDER.apply(zipName);
        if (!configDatapackZip.exists()) {
            throw LangKey.DATAPACK_NOT_GENERATED.asCommandException(modid);
        }
        File destination = DATAPACK_FOLDER.apply(((CommandSource)context.getSource()).func_197028_i(), zipName);
        if (destination.exists()) {
            this.disableDataPack((CommandSource)context.getSource(), modid);
            if (!destination.delete()) {
                throw LangKey.DATAPACK_APPLY_FAIL.asCommandException(LangKey.FILE_DELETE_FAIL.getText(destination.getAbsolutePath()));
            }
        }
        try {
            FileUtils.copyFile((File)configDatapackZip, (File)destination);
            this.discoverNewDataPack(((CommandSource)context.getSource()).func_197028_i());
            ((CommandSource)context.getSource()).func_197030_a(LangKey.DATAPACK_APPLY_SUCCESS.getText(new Object[0]), false);
            return 1;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw LangKey.DATAPACK_APPLY_FAIL.asCommandException(LangKey.FILE_COPY_FAIL.getText(destination.getAbsolutePath()));
        }
    }

    private int removeDataPack(CommandContext<CommandSource> context) {
        String modid = StringArgumentType.getString(context, (String)MODID_PARAM);
        if (INVALID_MODID.test(modid)) {
            throw LangKey.INVALID_MODID.asCommandException(new Object[0]);
        }
        File destination = DATAPACK_FOLDER.apply(((CommandSource)context.getSource()).func_197028_i(), this.getZipName(modid));
        if (!destination.exists()) {
            throw LangKey.DATAPACK_REMOVE_ABSENT.asCommandException(new Object[0]);
        }
        this.disableDataPack((CommandSource)context.getSource(), modid);
        if (!destination.delete()) {
            throw LangKey.DATAPACK_REMOVE_FAIL.asCommandException(LangKey.FILE_DELETE_FAIL.getText(destination.getAbsolutePath()));
        }
        ((CommandSource)context.getSource()).func_197030_a(LangKey.DATAPACK_REMOVE_SUCCESS.getText(new Object[0]), false);
        return 1;
    }

    private int generateDataPack(CommandContext<CommandSource> context) {
        String modid = StringArgumentType.getString(context, (String)MODID_PARAM);
        if (INVALID_MODID.test(modid)) {
            throw LangKey.INVALID_MODID.asCommandException(new Object[0]);
        }
        HashMap<String, WoodcuttingJsonRecipe> recipes = new HashMap<String, WoodcuttingJsonRecipe>();
        this.initPlanksToLogs(((CommandSource)context.getSource()).func_197028_i());
        Map entries = ((CommandSource)context.getSource()).func_197028_i().func_199529_aN().func_215366_a(IRecipeType.field_222149_a).entrySet().stream().filter(entry -> modid.equals(((ResourceLocation)entry.getKey()).func_110624_b())).map(Map.Entry::getValue).filter(r -> VALID_RESULT.test(r.func_77571_b())).collect(Collectors.toMap(Function.identity(), this::getWeight));
        for (Map.Entry entry2 : entries.entrySet()) {
            int count;
            WoodCompo compo;
            ItemStack stack;
            double weight = entry2.getValue();
            if (weight == 0.0) continue;
            ItemStack result = ((IRecipe)entry2.getKey()).func_77571_b();
            NonNullList ingredients = ((IRecipe)entry2.getKey()).func_192400_c();
            ResourceLocation outputName = result.func_77973_b().getRegistryName();
            assert (outputName != null);
            if (ingredients.size() == 1 && this.logs.contains((stack = ((Ingredient)ingredients.get(0)).func_193365_a()[0]).func_77973_b()) && (compo = this.plankToLog.get(result.func_77973_b())) != null) {
                this.addLogRecipe(recipes, compo, outputName, result.func_190916_E() / stack.func_190916_E());
                continue;
            }
            WoodCompo compo2 = this.getWoodCompo((NonNullList<Ingredient>)ingredients);
            if (compo2 == null) continue;
            int n = count = weight < 1.0 ? MathHelper.func_76128_c((double)(1.0 / weight)) : 1;
            if (weight < 3.1) {
                this.addPlankRecipe(recipes, compo2, outputName, count);
                this.addLogRecipe(recipes, compo2, outputName, count * 4);
                continue;
            }
            this.addLogRecipe(recipes, compo2, outputName, count);
        }
        if (recipes.isEmpty()) {
            throw LangKey.NO_VALID_RECIPE_FOR_MODID.asCommandException(modid);
        }
        File datapackFolder = CONFIG_FOLDER.apply("corail_woodcutter_" + modid);
        File dataFolder = new File(datapackFolder, "data");
        File recipeFolder = new File(dataFolder, "corail_woodcutter_" + modid + File.separatorChar + "recipes");
        if (recipeFolder.exists()) {
            try {
                FileUtils.cleanDirectory((File)recipeFolder);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!recipeFolder.exists() && !recipeFolder.mkdirs()) {
            throw LangKey.DATAPACK_GENERATE_FAIL.asCommandException(LangKey.FOLDER_CREATE_FAIL.getText(recipeFolder.getAbsolutePath()));
        }
        for (Map.Entry entry3 : recipes.entrySet()) {
            File file = new File(recipeFolder, (String)entry3.getKey() + ".json");
            if (file.exists() && !file.delete()) {
                throw LangKey.DATAPACK_GENERATE_FAIL.asCommandException(LangKey.FILE_DELETE_FAIL.getText(file.getAbsolutePath()));
            }
            if (this.toFile(file, ((WoodcuttingJsonRecipe)entry3.getValue()).withConditions(new WoodcuttingJsonRecipe.ConditionMod(modid), new WoodcuttingJsonRecipe.ConditionMod("corail_woodcutter"), new WoodcuttingJsonRecipe.ConditionItem(((WoodcuttingJsonRecipe)entry3.getValue()).result)))) continue;
            throw LangKey.DATAPACK_GENERATE_FAIL.asCommandException(LangKey.FILE_WRITE_FAIL.getText(file.getAbsolutePath()));
        }
        if (!this.addMcMeta(datapackFolder, modid)) {
            throw LangKey.MCMETA_CREATE_FAIL.asCommandException(new Object[0]);
        }
        try {
            this.toZip(datapackFolder.toPath(), modid);
            ((CommandSource)context.getSource()).func_197030_a(LangKey.DATAPACK_GENERATE_SUCCESS.getText(recipes.size()), false);
            return 1;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw LangKey.ZIP_CREATE_FAIL.asCommandException(new Object[0]);
        }
    }

    @Nullable
    private WoodCompo getWoodCompo(NonNullList<Ingredient> ingredients) {
        HashSet<Item> planks = new HashSet<Item>();
        int vanillaPlanks = 0;
        for (Ingredient ingredient : ingredients) {
            if (ingredient.func_203189_d()) continue;
            for (ItemStack stack : ingredient.func_193365_a()) {
                if (!this.plankToLog.containsKey(stack.func_77973_b()) || !planks.add(stack.func_77973_b()) || !VANILLA_ITEM.test(stack) || ++vanillaPlanks <= 1) continue;
                return WoodCompo.ANY_WOOD;
            }
        }
        return planks.size() == 0 ? WoodCompo.ANY_WOOD : (planks.size() == 1 ? this.plankToLog.get(planks.iterator().next()) : ingredients.stream().filter(ing -> !ing.func_203189_d()).filter(ing -> this.plankToLog.containsKey(ing.func_193365_a()[0].func_77973_b())).findFirst().map(this::getTagForIngredient).filter(Optional::isPresent).map(tag -> new WoodCompo((ResourceLocation)tag.get(), true, null, false)).orElse(this.plankToLog.get(planks.iterator().next())));
    }

    private void initPlanksToLogs(MinecraftServer server) {
        if (!this.plankToLog.isEmpty()) {
            return;
        }
        ForgeRegistries.ITEMS.getEntries().stream().filter(entry -> ItemTags.field_200038_h.func_230235_a_(entry.getValue()) || ((RegistryKey)entry.getKey()).getRegistryName().func_110623_a().endsWith("_log") || ((RegistryKey)entry.getKey()).getRegistryName().func_110623_a().endsWith("_stem")).map(Map.Entry::getValue).forEach(this.logs::add);
        server.func_199529_aN().func_215366_a(IRecipeType.field_222149_a).entrySet().stream().filter(entry -> !"minecraft".equals(((ResourceLocation)entry.getKey()).func_110624_b())).map(Map.Entry::getValue).filter(r -> r.func_192400_c().size() == 1).filter(ShapelessRecipe.class::isInstance).filter(r -> NON_VANILLA_PLANKS.test(r.func_77571_b())).filter(r -> this.isNonVanillaLogIngredient((Ingredient)r.func_192400_c().get(0))).forEach(logRecipe -> this.plankToLog.computeIfAbsent(logRecipe.func_77571_b().func_77973_b(), plank -> {
            ResourceLocation plankName = plank.getRegistryName();
            assert (plankName != null);
            Ingredient ingredient = (Ingredient)logRecipe.func_192400_c().get(0);
            Optional<ResourceLocation> tagName = this.getTagForIngredient(ingredient);
            if (tagName.isPresent()) {
                return new WoodCompo(plankName, false, tagName.get(), true);
            }
            ItemStack[] stacks = ingredient.func_193365_a();
            Set<ResourceLocation> commonTags = this.getCommonTags(stacks, plankName.func_110624_b());
            if (stacks.length == 1) {
                ResourceLocation logName2 = stacks[0].func_77973_b().getRegistryName();
                assert (logName2 != null);
                String logPath = logName2.func_110623_a().replace("stripped_", "");
                return commonTags.stream().filter(rl -> ALMOSTLY_SIMILAR.test(logPath, rl.func_110623_a())).findFirst().map(rl -> new WoodCompo(plankName, false, (ResourceLocation)rl, true)).orElse(new WoodCompo(plankName, false, logName2, false));
            }
            Set logNames = Arrays.stream(stacks).map(ItemStack::func_77973_b).map(ForgeRegistryEntry::getRegistryName).collect(Collectors.toSet());
            for (ResourceLocation tagRL : commonTags) {
                if (!logNames.stream().anyMatch(logName -> ALMOSTLY_SIMILAR.test(logName.func_110623_a().replace("stripped_", ""), tagRL.func_110623_a()))) continue;
                return new WoodCompo(plankName, false, tagRL, true);
            }
            return new WoodCompo(plankName, false, logNames.stream().min(Comparator.comparingInt(rl -> Levenshtein.distance((CharSequence)rl.func_110623_a(), (CharSequence)plankName.func_110623_a()))).orElse(null), false);
        }));
        this.plankToLog.put(Items.field_221590_r, new WoodCompo(Objects.requireNonNull(Items.field_221590_r.getRegistryName()), false, ItemTags.field_203297_q.func_230234_a_(), true));
        this.plankToLog.put(Items.field_221588_p, new WoodCompo(Objects.requireNonNull(Items.field_221588_p.getRegistryName()), false, ItemTags.field_203296_p.func_230234_a_(), true));
        this.plankToLog.put(Items.field_221591_s, new WoodCompo(Objects.requireNonNull(Items.field_221591_s.getRegistryName()), false, ItemTags.field_203294_n.func_230234_a_(), true));
        this.plankToLog.put(Items.field_221589_q, new WoodCompo(Objects.requireNonNull(Items.field_221589_q.getRegistryName()), false, ItemTags.field_203298_r.func_230234_a_(), true));
        this.plankToLog.put(Items.field_221586_n, new WoodCompo(Objects.requireNonNull(Items.field_221586_n.getRegistryName()), false, ItemTags.field_203295_o.func_230234_a_(), true));
        this.plankToLog.put(Items.field_221587_o, new WoodCompo(Objects.requireNonNull(Items.field_221587_o.getRegistryName()), false, ItemTags.field_203299_s.func_230234_a_(), true));
        this.plankToLog.put(Items.field_234798_v_, new WoodCompo(Objects.requireNonNull(Items.field_234798_v_.getRegistryName()), false, ItemTags.field_232913_w_.func_230234_a_(), true));
        this.plankToLog.put(Items.field_234799_w_, new WoodCompo(Objects.requireNonNull(Items.field_234799_w_.getRegistryName()), false, ItemTags.field_232914_x_.func_230234_a_(), true));
        ItemTags.field_199905_b.func_230236_b_().forEach(key -> this.plankToLog.computeIfAbsent((Item)key, item -> new WoodCompo(Objects.requireNonNull(item.getRegistryName()), false, null, false)));
    }

    private Set<ResourceLocation> getCommonTags(ItemStack[] stacks, String namespace) {
        if (stacks.length == 0) {
            return Collections.emptySet();
        }
        HashSet<ResourceLocation> commonTags = new HashSet<ResourceLocation>(stacks[0].func_77973_b().getTags());
        commonTags.removeIf(rl -> !namespace.equals(rl.func_110624_b()));
        if (stacks.length > 1) {
            IntStream.range(1, stacks.length).forEach(i -> commonTags.retainAll(stacks[i].func_77973_b().getTags()));
        }
        return commonTags;
    }

    private Optional<ResourceLocation> getTagForIngredient(Ingredient ingredient) {
        return Arrays.stream(ingredient.field_199807_b).filter(v -> v instanceof Ingredient.TagList).findFirst().map(tagValue -> ((Ingredient.TagList)tagValue).field_199800_a).map(tag -> TagCollectionManager.func_242178_a().func_241836_b().func_232973_a_(tag));
    }

    private boolean isNonVanillaLogIngredient(Ingredient ingredient) {
        return !ingredient.func_203189_d() && VALID_RESULT.test(ingredient.func_193365_a()[0]) && this.logs.contains(ingredient.func_193365_a()[0].func_77973_b()) && Arrays.stream(ingredient.func_193365_a()).noneMatch(VANILLA_ITEM);
    }

    private String getZipName(String modid) {
        return "corail_woodcutter_" + modid + ".zip";
    }

    private void toZip(Path source, String modid) throws IOException {
        try (final ZipOutputStream outputStream = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(CONFIG_FOLDER.apply(this.getZipName(modid)).toPath(), new OpenOption[0])));){
            Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path visitedPath, BasicFileAttributes attributes) {
                    if (!visitedPath.toFile().isDirectory()) {
                        String stringPath = visitedPath.toString();
                        ZipEntry zipentry = new ZipEntry(stringPath.endsWith("pack.mcmeta") ? "pack.mcmeta" : stringPath.substring(stringPath.indexOf("data")).replace('\\', '/'));
                        try {
                            outputStream.putNextEntry(zipentry);
                            com.google.common.io.Files.asByteSource((File)visitedPath.toFile()).copyTo((OutputStream)outputStream);
                            outputStream.closeEntry();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private void disableDataPack(CommandSource source, String modid) {
        ResourcePackList packs = source.func_197028_i().func_195561_aH();
        ResourcePackInfo pack = packs.func_198981_a("file/" + this.getZipName(modid));
        if (pack != null && packs.func_198980_d().contains(pack)) {
            ArrayList selectedPacks = Lists.newArrayList((Iterable)packs.func_198980_d());
            selectedPacks.remove(pack);
            source.func_197028_i().func_240780_a_((Collection)selectedPacks.stream().map(ResourcePackInfo::func_195790_f).collect(Collectors.toList()));
        }
    }

    private void discoverNewDataPack(MinecraftServer server) {
        ResourcePackList packs = server.func_195561_aH();
        ArrayList selectedPackIds = Lists.newArrayList((Iterable)packs.func_232621_d_());
        packs.func_198983_a();
        List disabledPackIds = server.func_240793_aU_().func_230403_C_().func_234887_b_();
        for (String packId : packs.func_232616_b_()) {
            if (disabledPackIds.contains(packId) || selectedPackIds.contains(packId)) continue;
            selectedPackIds.add(packId);
        }
        server.func_240780_a_((Collection)selectedPackIds);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> boolean toFile(File file, T object) {
        try (OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), StandardCharsets.UTF_8);){
            fw.write(GSON.toJson(object));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean addMcMeta(File datapackFolder, String modid) {
        File file = new File(datapackFolder, "pack.mcmeta");
        if (file.exists()) {
            return true;
        }
        JsonObject json = new JsonObject();
        JsonObject pack = new JsonObject();
        json.add("pack", (JsonElement)pack);
        pack.addProperty("description", "Corail Woodcutter " + StringUtils.capitalize((String)modid) + " Resources");
        pack.addProperty("pack_format", (Number)5);
        return this.toFile(file, json);
    }

    private void addRecipe(Map<String, WoodcuttingJsonRecipe> recipes, ResourceLocation input, ResourceLocation output, int count, boolean isTag) {
        recipes.put(output.func_110623_a() + "_from_" + input.func_110623_a().replaceAll("/|\\\\", "_"), new WoodcuttingJsonRecipe(input.toString(), output.toString(), count, isTag));
    }

    private void addPlankRecipe(Map<String, WoodcuttingJsonRecipe> recipes, WoodCompo compo, ResourceLocation output, int count) {
        this.addRecipe(recipes, compo.plankName, output, count, compo.isPlankTag);
    }

    private void addLogRecipe(Map<String, WoodcuttingJsonRecipe> recipes, WoodCompo compo, ResourceLocation output, int count) {
        Optional.ofNullable(compo.logName).ifPresent(logName -> this.addRecipe(recipes, (ResourceLocation)logName, output, count, compo.isLogTag));
    }

    private double getWeight(IRecipe<CraftingInventory> recipe) {
        NonNullList ingredients = recipe.func_192400_c();
        double weight = 0.0;
        double maxWeight = 5.0 * (double)recipe.func_77571_b().func_190916_E();
        for (Ingredient ingredient : ingredients) {
            Predicate<Item> predicate;
            if (ingredient.func_203189_d()) continue;
            ItemStack[] stacks = ingredient.func_193365_a();
            ItemStack stack = stacks[0];
            if (this.logs.contains(stack.func_77973_b())) {
                predicate = this.logs::contains;
                weight += 4.0 * (double)stack.func_190916_E();
            } else if (this.plankToLog.containsKey(stack.func_77973_b())) {
                predicate = this.plankToLog::containsKey;
                weight += 1.0 * (double)stack.func_190916_E();
            } else if (Tags.Items.RODS_WOODEN.func_230235_a_((Object)stack.func_77973_b())) {
                predicate = arg_0 -> ((Tags.IOptionalNamedTag)Tags.Items.RODS_WOODEN).func_230235_a_(arg_0);
                weight += 0.5 * (double)stack.func_190916_E();
            } else if (ItemTags.field_202899_i.func_230235_a_((Object)stack.func_77973_b())) {
                predicate = arg_0 -> ((ITag.INamedTag)ItemTags.field_202899_i).func_230235_a_(arg_0);
                weight += 0.5 * (double)stack.func_190916_E();
            } else {
                return 0.0;
            }
            if (!(weight > maxWeight) && !Arrays.stream(stacks).anyMatch(s -> !predicate.test(s.func_77973_b()))) continue;
            return 0.0;
        }
        return weight / (double)recipe.func_77571_b().func_190916_E();
    }

    private void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralCommandNode command = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"cwc").requires(this::hasPermission)).executes(this::showUsage)).then(BaseAction.INFO.literal().executes(this::showUsage))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)BaseAction.DATAPACK.literal().executes(this::showUsage)).then(((LiteralArgumentBuilder)DataPackAction.GENERATE.literal().executes(this::showUsage)).then(Commands.func_197056_a((String)MODID_PARAM, (ArgumentType)StringArgumentType.word()).suggests(SUGGESTION_MODID).executes(this::generateDataPack)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)DataPackAction.APPLY.literal().requires(this::isSinglePlayerOwner)).executes(this::showUsage)).then(Commands.func_197056_a((String)MODID_PARAM, (ArgumentType)StringArgumentType.word()).suggests(SUGGESTION_MODID).executes(this::applyDataPack)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)DataPackAction.REMOVE.literal().requires(this::isSinglePlayerOwner)).executes(this::showUsage)).then(Commands.func_197056_a((String)MODID_PARAM, (ArgumentType)StringArgumentType.word()).suggests(SUGGESTION_MODID).executes(this::removeDataPack)))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"woodcutter").requires(this::hasPermission)).redirect((CommandNode)command));
    }

    private boolean hasPermission(CommandSource source) {
        return source.func_197034_c(2) || this.isSinglePlayerOwner(source);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSinglePlayerOwner(CommandSource source) {
        if (source.func_197028_i().func_71262_S()) return false;
        if (!source.func_197028_i().func_71264_H()) return false;
        if (Optional.ofNullable(source.func_197022_f()).filter(ServerPlayerEntity.class::isInstance).map(ServerPlayerEntity.class::cast).map(PlayerEntity::func_146103_bH).map(profil -> source.func_197028_i().func_213199_b(profil)).orElse(false) == false) return false;
        return true;
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        new CommandWoodcutter().register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    private static interface IAction
    extends IStringSerializable {
        default public LiteralArgumentBuilder<CommandSource> literal() {
            return Commands.func_197057_a((String)this.func_176610_l());
        }
    }

    private static enum DataPackAction implements IAction
    {
        GENERATE,
        APPLY,
        REMOVE;

        private final String name = this.name().toLowerCase(Locale.US);

        public String func_176610_l() {
            return this.name;
        }
    }

    private static enum BaseAction implements IAction
    {
        INFO,
        DATAPACK;

        private final String name = this.name().toLowerCase(Locale.US);

        public String func_176610_l() {
            return this.name;
        }
    }

    private static class WoodCompo {
        private static final WoodCompo ANY_WOOD = new WoodCompo(ItemTags.field_199905_b.func_230234_a_(), true, ItemTags.field_200038_h.func_230234_a_(), true);
        private final ResourceLocation plankName;
        private final ResourceLocation logName;
        private final boolean isPlankTag;
        private final boolean isLogTag;

        private WoodCompo(ResourceLocation plankName, boolean isPlankTag, @Nullable ResourceLocation logName, boolean isLogTag) {
            this.plankName = plankName;
            this.isPlankTag = isPlankTag;
            this.logName = logName;
            this.isLogTag = isLogTag;
        }
    }
}

