/*
 * Decompiled with CFR 0.152.
 */
package org.villainy.sweetconcrete.tileEntities.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.tileentity.SignTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextProperties;
import org.villainy.sweetconcrete.blocks.ConcreteSignBlock;
import org.villainy.sweetconcrete.client.Atlases;
import org.villainy.sweetconcrete.tileEntities.ConcreteSignTileEntity;

public class ConcreteSignTileEntityRenderer
extends TileEntityRenderer<ConcreteSignTileEntity> {
    private final SignTileEntityRenderer.SignModel model = new SignTileEntityRenderer.SignModel();

    public ConcreteSignTileEntityRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    private RenderMaterial getSignMaterial(Block block) {
        ConcreteSignBlock signBlock = (ConcreteSignBlock)block;
        return Atlases.getConcreteMaterial(signBlock.dyeColor);
    }

    public void render(ConcreteSignTileEntity tileEntity, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float scale = 0.6666667f;
        matrixStackIn.func_227860_a_();
        BlockState state = tileEntity.func_195044_w();
        Direction facing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
        AttachFace face = (AttachFace)state.func_177229_b((Property)BlockStateProperties.field_208158_K);
        int rotAroundY = 0;
        int rotAroundX = 0;
        switch (face) {
            case CEILING: {
                rotAroundX = 90;
                break;
            }
            case FLOOR: {
                rotAroundX = -90;
            }
        }
        switch (facing) {
            case SOUTH: {
                break;
            }
            case NORTH: {
                rotAroundY = 180;
                break;
            }
            case EAST: {
                rotAroundY = 90;
                break;
            }
            case WEST: {
                rotAroundY = -90;
            }
        }
        matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)rotAroundY));
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((float)rotAroundX));
        matrixStackIn.func_227861_a_(0.0, -0.3125, -0.4375);
        this.model.field_78165_b.field_78806_j = false;
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227862_a_(0.6666667f, -0.6666667f, -0.6666667f);
        RenderMaterial material = SignTileEntityRenderer.func_228877_a_((Block)state.func_177230_c());
        IVertexBuilder ivertexbuilder = material.func_229311_a_(bufferIn, RenderType::func_228638_b_);
        this.model.field_78166_a.func_228308_a_(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn);
        this.model.field_78165_b.func_228308_a_(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn);
        IVertexBuilder ivertexbuilder2 = this.getSignMaterial(tileEntity.func_195044_w().func_177230_c()).func_229311_a_(bufferIn, RenderType::func_228638_b_);
        this.model.field_78166_a.func_228308_a_(matrixStackIn, ivertexbuilder2, combinedLightIn, combinedOverlayIn);
        this.model.field_78165_b.func_228308_a_(matrixStackIn, ivertexbuilder2, combinedLightIn, combinedOverlayIn);
        matrixStackIn.func_227865_b_();
        FontRenderer fontrenderer = this.field_228858_b_.func_147548_a();
        matrixStackIn.func_227861_a_(0.0, 0.3333333432674408, 0.046666666865348816);
        matrixStackIn.func_227862_a_(0.010416667f, -0.010416667f, 0.010416667f);
        int color = tileEntity.func_214066_f().func_218388_g();
        int red = (int)((double)NativeImage.func_227791_b_((int)color) * 0.4);
        int green = (int)((double)NativeImage.func_227793_c_((int)color) * 0.4);
        int blue = (int)((double)NativeImage.func_227795_d_((int)color) * 0.4);
        int adjustedColor = NativeImage.func_227787_a_((int)0, (int)blue, (int)green, (int)red);
        for (int line = 0; line < 4; ++line) {
            IReorderingProcessor ireorderingprocessor = tileEntity.func_242686_a(line, text -> {
                List list = fontrenderer.func_238425_b_((ITextProperties)text, 90);
                return list.isEmpty() ? IReorderingProcessor.field_242232_a : (IReorderingProcessor)list.get(0);
            });
            if (ireorderingprocessor == null) continue;
            float f3 = -fontrenderer.func_243245_a(ireorderingprocessor) / 2;
            fontrenderer.func_238416_a_(ireorderingprocessor, f3, (float)(line * 10 - 20), adjustedColor, false, matrixStackIn.func_227866_c_().func_227870_a_(), bufferIn, false, 0, combinedLightIn);
        }
        matrixStackIn.func_227865_b_();
    }
}

