/*
 * Decompiled with CFR 0.152.
 */
package org.villainy.sweetconcrete.config;

import com.google.gson.JsonObject;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import org.villainy.sweetconcrete.config.SweetConcreteConfig;

public class FlagRecipeCondition
implements ICondition {
    private final String flag;
    private final ResourceLocation loc;

    public FlagRecipeCondition(String flag, ResourceLocation loc) {
        this.flag = flag;
        this.loc = loc;
    }

    public ResourceLocation getID() {
        return this.loc;
    }

    public boolean test() {
        if (this.flag.equals("slabs")) {
            return SweetConcreteConfig.enableSlabs;
        }
        if (this.flag.equals("stairs")) {
            return SweetConcreteConfig.enableStairs;
        }
        if (this.flag.equals("walls")) {
            return SweetConcreteConfig.enableWalls;
        }
        if (this.flag.equals("buttons")) {
            return SweetConcreteConfig.enableButtons;
        }
        if (this.flag.equals("pressure_plates")) {
            return SweetConcreteConfig.enablePressurePlates;
        }
        if (this.flag.equals("fences")) {
            return SweetConcreteConfig.enableFences;
        }
        if (this.flag.equals("ladders")) {
            return SweetConcreteConfig.enableLadders;
        }
        if (this.flag.equals("cake")) {
            return SweetConcreteConfig.enableCake;
        }
        if (this.flag.equals("signs")) {
            return SweetConcreteConfig.enableSigns;
        }
        if (this.flag.equals("levers")) {
            return SweetConcreteConfig.enableLevers;
        }
        if (this.flag.equals("vertical_slabs")) {
            return SweetConcreteConfig.enableVerticalSlabs;
        }
        if (this.flag.equals("powder_layers")) {
            return SweetConcreteConfig.enablePowderLayers;
        }
        return true;
    }

    public static class Serializer
    implements IConditionSerializer<FlagRecipeCondition> {
        private final ResourceLocation location;

        public Serializer(ResourceLocation location) {
            this.location = location;
        }

        public void write(JsonObject json, FlagRecipeCondition value) {
            json.addProperty("flag", value.flag);
        }

        public FlagRecipeCondition read(JsonObject json) {
            return new FlagRecipeCondition(json.getAsJsonPrimitive("flag").getAsString(), this.location);
        }

        public ResourceLocation getID() {
            return this.location;
        }
    }
}

