/*
 * Decompiled with CFR 0.152.
 */
package org.villainy.sweetconcrete.blocks;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import org.villainy.sweetconcrete.config.SweetConcreteConfig;
import org.villainy.sweetconcrete.objectholders.ConcretePowderLayerBlocks;

public class ConcretePowderLayerBlock
extends Block {
    public static final IntegerProperty LAYERS = BlockStateProperties.field_208129_ad;
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{VoxelShapes.func_197880_a(), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public ConcretePowderLayerBlock(DyeColor dyeColor) {
        super(AbstractBlock.Properties.func_200952_a((Material)Material.field_151595_p, (DyeColor)dyeColor).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)LAYERS, (Comparable)Integer.valueOf(1)));
        this.setRegistryName(dyeColor.func_176762_d() + "_concrete_powder_layer");
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return (Integer)state.func_177229_b((Property)LAYERS) < 5;
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[(Integer)state.func_177229_b((Property)LAYERS)];
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[(Integer)state.func_177229_b((Property)LAYERS) - 1];
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockState blockstate = worldIn.func_180495_p(pos.func_177977_b());
        Block block = blockstate.func_177230_c();
        if (block != Blocks.field_226907_mc_ && block != Blocks.field_150425_aM) {
            return Block.func_208061_a((VoxelShape)blockstate.func_196952_d((IBlockReader)worldIn, pos.func_177977_b()), (Direction)Direction.UP) || block == this && (Integer)blockstate.func_177229_b((Property)LAYERS) == 8;
        }
        return true;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        int i = (Integer)state.func_177229_b((Property)LAYERS);
        if (useContext.func_195996_i().func_77973_b() == this.func_199767_j() && i < 8) {
            if (useContext.func_196012_c()) {
                return useContext.func_196000_l() == Direction.UP;
            }
            return true;
        }
        return i == 1;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = context.func_195991_k().func_180495_p(context.func_195995_a());
        if (blockstate.func_177230_c() == this) {
            int i = (Integer)blockstate.func_177229_b((Property)LAYERS);
            return (BlockState)blockstate.func_206870_a((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
        }
        return super.func_196258_a(context);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LAYERS});
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (group == ItemGroup.field_78027_g || this.isEnabled()) {
            super.func_149666_a(group, items);
        }
    }

    public static Stream<Block> allBlocks() {
        return Stream.of(new Block[]{ConcretePowderLayerBlocks.WHITE, ConcretePowderLayerBlocks.ORANGE, ConcretePowderLayerBlocks.MAGENTA, ConcretePowderLayerBlocks.LIGHT_BLUE, ConcretePowderLayerBlocks.YELLOW, ConcretePowderLayerBlocks.LIME, ConcretePowderLayerBlocks.PINK, ConcretePowderLayerBlocks.GRAY, ConcretePowderLayerBlocks.LIGHT_GRAY, ConcretePowderLayerBlocks.CYAN, ConcretePowderLayerBlocks.PURPLE, ConcretePowderLayerBlocks.BLUE, ConcretePowderLayerBlocks.BROWN, ConcretePowderLayerBlocks.GREEN, ConcretePowderLayerBlocks.RED, ConcretePowderLayerBlocks.BLACK});
    }

    private boolean isEnabled() {
        return SweetConcreteConfig.enablePowderLayers;
    }
}

