/*
 * Decompiled with CFR 0.152.
 */
package org.villainy.sweetconcrete.blocks;

import java.util.stream.Stream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.villainy.sweetconcrete.config.SweetConcreteConfig;
import org.villainy.sweetconcrete.objectholders.ConcreteCakeBlocks;

public class ConcreteCakeBlock
extends FallingBlock {
    public static final IntegerProperty BITES = BlockStateProperties.field_208173_Z;
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.func_208617_a((double)3.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.func_208617_a((double)5.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.func_208617_a((double)7.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.func_208617_a((double)9.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.func_208617_a((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.func_208617_a((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)};

    private boolean isEnabled() {
        return SweetConcreteConfig.enableCake;
    }

    public ConcreteCakeBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)BITES, (Comparable)Integer.valueOf(0)));
        this.setRegistryName("concrete_cake");
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (group == ItemGroup.field_78027_g || this.isEnabled()) {
            super.func_149666_a(group, items);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[(Integer)state.func_177229_b((Property)BITES)];
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            ItemStack itemStack = player.func_184586_b(handIn);
            if (this.eatCake((IWorld)worldIn, pos, state, player) == ActionResultType.SUCCESS) {
                return ActionResultType.SUCCESS;
            }
            if (itemStack.func_190926_b()) {
                return ActionResultType.CONSUME;
            }
        }
        return this.eatCake((IWorld)worldIn, pos, state, player);
    }

    private ActionResultType eatCake(IWorld worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!player.func_71043_e(false)) {
            return ActionResultType.PASS;
        }
        player.func_195066_a(Stats.field_188076_J);
        player.func_71024_bL().func_75122_a(2, 0.1f);
        int bites = (Integer)state.func_177229_b((Property)BITES);
        if (bites < 6) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
        } else {
            worldIn.func_217377_a(pos, false);
        }
        return ActionResultType.SUCCESS;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BITES});
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return (7 - (Integer)blockState.func_177229_b((Property)BITES)) * 2;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    protected void func_149829_a(FallingBlockEntity fallingEntity) {
        fallingEntity.func_145806_a(true);
    }

    public void onEndFalling(World worldIn, BlockPos pos, BlockState fallingState, BlockState hitState) {
        worldIn.func_217379_c(1031, pos, 0);
    }

    public static Stream<Block> allBlocks() {
        return Stream.of(ConcreteCakeBlocks.CONCRETE_CAKE);
    }
}

