/*
 * Decompiled with CFR 0.152.
 */
package org.villainy.sweetconcrete;

import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.villainy.sweetconcrete.blocks.ConcreteButtonBlock;
import org.villainy.sweetconcrete.blocks.ConcreteCakeBlock;
import org.villainy.sweetconcrete.blocks.ConcreteFenceBlock;
import org.villainy.sweetconcrete.blocks.ConcreteFenceGateBlock;
import org.villainy.sweetconcrete.blocks.ConcreteLadderBlock;
import org.villainy.sweetconcrete.blocks.ConcreteLeverBlock;
import org.villainy.sweetconcrete.blocks.ConcretePowderLayerBlock;
import org.villainy.sweetconcrete.blocks.ConcretePressurePlateBlock;
import org.villainy.sweetconcrete.blocks.ConcreteSignBlock;
import org.villainy.sweetconcrete.blocks.ConcreteSlabBlock;
import org.villainy.sweetconcrete.blocks.ConcreteStairsBlock;
import org.villainy.sweetconcrete.blocks.ConcreteVerticalSlabBlock;
import org.villainy.sweetconcrete.blocks.ConcreteWallBlock;
import org.villainy.sweetconcrete.config.ConfigHelper;
import org.villainy.sweetconcrete.config.ConfigHolder;
import org.villainy.sweetconcrete.config.FlagRecipeCondition;
import org.villainy.sweetconcrete.items.ConcreteSignItem;
import org.villainy.sweetconcrete.items.helper.BlockItemHelper;
import org.villainy.sweetconcrete.network.OpenConcreteSignEditor;
import org.villainy.sweetconcrete.objectholders.ConcreteSignBlocks;
import org.villainy.sweetconcrete.proxy.ClientProxy;
import org.villainy.sweetconcrete.proxy.CommonProxy;
import org.villainy.sweetconcrete.proxy.IProxy;
import org.villainy.sweetconcrete.tileEntities.ConcreteSignTileEntity;

@Mod(value="sweetconcrete")
public class SweetConcrete {
    public static final String MODID = "sweetconcrete";
    public static final String CHANNEL = "sweetconcrete";
    private static final String PROTOCOL_VERSION = "1.0";
    public static SimpleChannel channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("sweetconcrete", "sweetconcrete")).clientAcceptedVersions("1.0"::equals).serverAcceptedVersions("1.0"::equals).networkProtocolVersion(() -> "1.0").simpleChannel();
    public static IProxy proxy = (IProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    private static final Logger LOG = LogManager.getLogger();

    public SweetConcrete() {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        modLoadingContext.registerConfig(ModConfig.Type.COMMON, ConfigHolder.COMMON_SPEC);
        CraftingHelper.register((IConditionSerializer)new FlagRecipeCondition.Serializer(new ResourceLocation("sweetconcrete", "flag")));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(proxy::onFMLClientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(proxy::onFMLCommonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadComplete);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        int messageNumber = 0;
        channel.registerMessage(messageNumber++, OpenConcreteSignEditor.class, OpenConcreteSignEditor::encode, OpenConcreteSignEditor::new, OpenConcreteSignEditor::handle);
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        proxy.init();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> event) {
            IForgeRegistry blockRegistry = event.getRegistry();
            Stream.of(DyeColor.values()).forEach(dyeColor -> {
                ConcreteSlabBlock slab = new ConcreteSlabBlock((DyeColor)dyeColor);
                blockRegistry.register((IForgeRegistryEntry)slab);
                blockRegistry.register((IForgeRegistryEntry)new ConcreteStairsBlock((DyeColor)dyeColor, slab.func_176223_P()));
                blockRegistry.register((IForgeRegistryEntry)new ConcreteWallBlock((DyeColor)dyeColor));
                blockRegistry.register((IForgeRegistryEntry)new ConcreteButtonBlock((DyeColor)dyeColor));
                blockRegistry.register((IForgeRegistryEntry)new ConcretePressurePlateBlock((DyeColor)dyeColor));
                blockRegistry.register((IForgeRegistryEntry)new ConcreteFenceBlock((DyeColor)dyeColor));
                blockRegistry.register((IForgeRegistryEntry)new ConcreteFenceGateBlock((DyeColor)dyeColor));
                blockRegistry.register((IForgeRegistryEntry)new ConcreteLadderBlock((DyeColor)dyeColor));
                blockRegistry.register((IForgeRegistryEntry)new ConcreteSignBlock((DyeColor)dyeColor));
                blockRegistry.register((IForgeRegistryEntry)new ConcreteLeverBlock((DyeColor)dyeColor));
                blockRegistry.register((IForgeRegistryEntry)new ConcreteVerticalSlabBlock((DyeColor)dyeColor));
                blockRegistry.register((IForgeRegistryEntry)new ConcretePowderLayerBlock((DyeColor)dyeColor));
            });
            blockRegistry.register((IForgeRegistryEntry)new ConcreteCakeBlock());
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> event) {
            IForgeRegistry itemRegistry = event.getRegistry();
            ConcreteSlabBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, ItemGroup.field_78030_b)));
            ConcreteStairsBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, ItemGroup.field_78030_b)));
            ConcreteWallBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, ItemGroup.field_78031_c)));
            ConcreteButtonBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, ItemGroup.field_78028_d)));
            ConcretePressurePlateBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, ItemGroup.field_78028_d)));
            ConcreteFenceBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, ItemGroup.field_78031_c)));
            ConcreteFenceGateBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, ItemGroup.field_78031_c)));
            ConcreteLadderBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, ItemGroup.field_78031_c)));
            ConcreteSignBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)new ConcreteSignItem((Block)block)));
            ConcreteCakeBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, ItemGroup.field_78039_h)));
            ConcreteLeverBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, ItemGroup.field_78028_d)));
            ConcreteVerticalSlabBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, ItemGroup.field_78030_b)));
            ConcretePowderLayerBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, ItemGroup.field_78030_b)));
        }

        @SubscribeEvent
        public static void onTileEntityRegistry(RegistryEvent.Register<TileEntityType<?>> event) {
            TileEntityType concreteSignType = TileEntityType.Builder.func_223042_a(ConcreteSignTileEntity::new, (Block[])new Block[]{ConcreteSignBlocks.WHITE, ConcreteSignBlocks.ORANGE, ConcreteSignBlocks.MAGENTA, ConcreteSignBlocks.LIGHT_BLUE, ConcreteSignBlocks.YELLOW, ConcreteSignBlocks.LIME, ConcreteSignBlocks.PINK, ConcreteSignBlocks.GRAY, ConcreteSignBlocks.LIGHT_GRAY, ConcreteSignBlocks.CYAN, ConcreteSignBlocks.PURPLE, ConcreteSignBlocks.BLUE, ConcreteSignBlocks.BROWN, ConcreteSignBlocks.GREEN, ConcreteSignBlocks.RED, ConcreteSignBlocks.BLACK}).func_206865_a(null);
            concreteSignType.setRegistryName("sweetconcrete", "concrete_sign");
            event.getRegistry().register((IForgeRegistryEntry)concreteSignType);
        }

        @SubscribeEvent
        public static void onModConfigEvent(ModConfig.ModConfigEvent event) {
            ModConfig config = event.getConfig();
            if (config.getSpec() == ConfigHolder.COMMON_SPEC) {
                ConfigHelper.bakeCommon(config);
            }
        }
    }
}

