/*
 * Decompiled with CFR 0.152.
 */
package annabeth.coremod.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.ai.brain.task.GiveHeroGiftsTask;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.LegacySingleJigsawPiece;
import net.minecraft.world.gen.feature.template.ProcessorLists;
import net.minecraft.world.gen.feature.template.StructureProcessorList;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class VillagerHelper {
    private static Map<VillagerProfession, ResourceLocation> GIFTS;

    private VillagerHelper() {
    }

    public static void setHOTVGifts(VillagerProfession profession) {
        ResourceLocation name = profession.getRegistryName();
        GIFTS.put(profession, new ResourceLocation(name.func_110624_b(), "gameplay/hero_of_the_village/" + name.func_110623_a()));
    }

    public static PointOfInterestType makePOI(ResourceLocation name, Set<BlockState> states) {
        PointOfInterestType type = new PointOfInterestType(name.toString(), (Set)ImmutableSet.copyOf(states), 1, 1);
        return type;
    }

    public static PointOfInterestType makePOI(ResourceLocation name, Block block) {
        return VillagerHelper.makePOI(name, PointOfInterestType.func_221042_a((Block)block));
    }

    public static VillagerProfession makeProfession(ResourceLocation name, PointOfInterestType poi, SoundEvent workSound) {
        return new VillagerProfession(name.toString(), poi, ImmutableSet.builder().build(), ImmutableSet.builder().build(), workSound);
    }

    public static VillagerProfession makeProfession(ResourceLocation name, PointOfInterestType poi, ImmutableSet<Item> items, ImmutableSet<Block> blocks, SoundEvent workSound) {
        return new VillagerProfession(name.toString(), poi, items, blocks, workSound);
    }

    public static void addVillagerHouse(ResourceLocation pool, ResourceLocation newHouse, int wheight) {
        JigsawPattern old = (JigsawPattern)WorldGenRegistries.field_243656_h.func_82594_a(pool);
        Object shuffled = old != null ? old.func_214943_b(new Random(0L)) : ImmutableList.of();
        ArrayList newPieces = Lists.newArrayList();
        for (JigsawPiece piece : shuffled) {
            newPieces.add(new Pair((Object)piece, (Object)1));
        }
        newPieces.add(Pair.of((Object)((Object)new LegacySingleJigsawPieceHelper((Either<ResourceLocation, Template>)Either.left((Object)newHouse), () -> ProcessorLists.field_244101_a, JigsawPattern.PlacementBehaviour.RIGID)), (Object)wheight));
        ResourceLocation name = old.func_214947_b();
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243656_h, (ResourceLocation)pool, (Object)new JigsawPattern(pool, name, (List)newPieces));
    }

    public static void addVillagerHouse(ResourceLocation pool, ResourceLocation newHouse) {
        VillagerHelper.addVillagerHouse(pool, newHouse, 1);
    }

    static {
        try {
            GIFTS = (Map)ObfuscationReflectionHelper.findField(GiveHeroGiftsTask.class, (String)"field_220403_a").get(Maps.newHashMap());
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    private static class LegacySingleJigsawPieceHelper
    extends LegacySingleJigsawPiece {
        protected LegacySingleJigsawPieceHelper(Either<ResourceLocation, Template> p_i242007_1_, Supplier<StructureProcessorList> p_i242007_2_, JigsawPattern.PlacementBehaviour p_i242007_3_) {
            super(p_i242007_1_, p_i242007_2_, p_i242007_3_);
        }
    }
}

