/*
 * Decompiled with CFR 0.152.
 */
package annabeth.coremod.util;

import annabeth.coremod.crafting.BlockStateConverting;
import annabeth.coremod.crafting.ClickRecipe;
import annabeth.coremod.crafting.RecipeVars;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="annabethscore", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventHandler {
    @SubscribeEvent
    public static void onLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        EventHandler.processClickRecipe((PlayerInteractEvent)event, ClickRecipe.ClickType.LEFT);
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        EventHandler.processClickRecipe((PlayerInteractEvent)event, ClickRecipe.ClickType.RIGHT);
    }

    private static void processClickRecipe(PlayerInteractEvent event, ClickRecipe.ClickType click) {
        World world = event.getWorld();
        ItemStack stack = event.getItemStack();
        BlockState state = world.func_180495_p(event.getPos());
        PlayerEntity player = event.getPlayer();
        BlockPos pos = event.getPos();
        List recipes = world.func_199532_z().func_241447_a_(RecipeVars.CLICK_RECIPE);
        for (ClickRecipe recipe : recipes) {
            Block blockOut;
            if (recipe.getClick() != click && recipe.getClick() != ClickRecipe.ClickType.BOTH || !recipe.getInputBlocks().contains(state.func_177230_c()) || !recipe.getInputItem().test(stack)) continue;
            Block blockIn = state.func_177230_c();
            BlockState newState = BlockStateConverting.convert(state, blockIn, blockOut = recipe.getOutputBlock());
            if (newState.func_235901_b_((Property)HorizontalBlock.field_185512_D) && !state.func_235901_b_((Property)HorizontalBlock.field_185512_D)) {
                Direction dir = event.getFace();
                if (dir == Direction.UP || dir == Direction.DOWN) {
                    dir = player.func_174811_aO();
                }
                newState = (BlockState)newState.func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)dir);
            }
            recipe.playSound(world, player, pos);
            if (!world.field_72995_K) {
                Item result;
                world.func_180501_a(pos, newState, 11);
                ClickRecipe.ConsumeType consume = recipe.getConsume();
                if (consume != ClickRecipe.ConsumeType.KEEP) {
                    if (consume == ClickRecipe.ConsumeType.WEAK_CONSUME && stack.func_77984_f()) {
                        stack.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(event.getHand()));
                    } else {
                        stack.func_190918_g(1);
                    }
                }
                if ((result = recipe.getOutputItem()) != Items.field_190931_a) {
                    world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), recipe.func_77571_b()));
                }
                player.func_195065_a((Collection)Lists.newArrayList((Object[])new IRecipe[]{recipe}));
            }
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.func_233537_a_((boolean)world.field_72995_K));
            event.setResult(Event.Result.DENY);
        }
    }
}

