/*
 * Decompiled with CFR 0.152.
 */
package annabeth.coremod.crafting;

import annabeth.coremod.crafting.RecipeVars;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ClickRecipe
implements IRecipe<IInventory> {
    private final ResourceLocation id;
    private final Item outputItem;
    private final Ingredient inputItem;
    private final Set<Block> startBlocks;
    private final Block endBlock;
    private final SoundEvent soundToPlay;
    private final ClickType click;
    private final ConsumeType consume;
    private final int outputItemCount;
    private final ItemStack result;

    public ClickRecipe(ResourceLocation id, Set<Block> b1, Ingredient i1, Block b2, Item i2, int n, SoundEvent s, ClickType cl, ConsumeType con) {
        this.id = id;
        this.startBlocks = b1;
        this.inputItem = i1;
        this.endBlock = b2;
        this.outputItem = i2;
        this.outputItemCount = n;
        this.soundToPlay = s;
        this.click = cl;
        this.consume = con;
        this.result = i2 == Items.field_190931_a ? new ItemStack((IItemProvider)b2) : new ItemStack((IItemProvider)i2, n);
    }

    public ItemStack func_222128_h() {
        return this.inputItem.func_193365_a()[0];
    }

    public void playSound(World world, PlayerEntity player, BlockPos pos) {
        if (this.soundToPlay != null) {
            world.func_184133_a(player, pos, this.soundToPlay, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public Set<Block> getInputBlocks() {
        return this.startBlocks;
    }

    public Block getOutputBlock() {
        return this.endBlock;
    }

    public Ingredient getInputItem() {
        return this.inputItem;
    }

    public Item getOutputItem() {
        return this.outputItem;
    }

    public int getOutputCount() {
        return this.outputItemCount;
    }

    public ClickType getClick() {
        return this.click;
    }

    public ConsumeType getConsume() {
        return this.consume;
    }

    public boolean func_77569_a(IInventory inv, World world) {
        return this.inputItem.test(inv.func_70301_a(0));
    }

    public ItemStack func_77572_b(IInventory inv) {
        if (this.outputItem != Items.field_190931_a) {
            return new ItemStack((IItemProvider)this.outputItem, this.outputItemCount);
        }
        return new ItemStack((IItemProvider)this.endBlock);
    }

    public boolean func_194133_a(int i1, int i2) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return RecipeVars.CLICK_SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return RecipeVars.CLICK_RECIPE;
    }

    public static enum ConsumeType {
        WEAK_CONSUME("weak_consume"),
        STRONG_CONSUME("strong_consume"),
        KEEP("keep");

        private final String name;

        private ConsumeType(String s) {
            this.name = s;
        }

        public String toString() {
            return this.name;
        }

        public static ConsumeType getConsumeTypeFor(String s) {
            return ConsumeType.valueOf(s.toUpperCase());
        }
    }

    public static enum ClickType {
        RIGHT("right"),
        LEFT("left"),
        BOTH("both");

        private final String name;

        private ClickType(String s) {
            this.name = s;
        }

        public String toString() {
            return this.name;
        }

        public static ClickType getClickTypeFor(String s) {
            return ClickType.valueOf(s.toUpperCase());
        }
    }

    public static class ClickSerializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ClickRecipe> {
        public ClickRecipe fromJson(ResourceLocation id, JsonObject json) {
            int i;
            Item resultItem;
            HashSet inBlocks = Sets.newHashSet();
            if (JSONUtils.func_151202_d((JsonObject)json, (String)"inblock")) {
                for (JsonElement je : JSONUtils.func_151214_t((JsonObject)json, (String)"inblock")) {
                    inBlocks.add(ForgeRegistries.BLOCKS.getValue(new ResourceLocation(je.getAsString())));
                }
            } else {
                JsonObject inBlock = JSONUtils.func_152754_s((JsonObject)json, (String)"inblock");
                if (JSONUtils.func_151204_g((JsonObject)inBlock, (String)"block")) {
                    inBlocks.add(ForgeRegistries.BLOCKS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)inBlock, (String)"block"))));
                }
                if (JSONUtils.func_151204_g((JsonObject)inBlock, (String)"tag")) {
                    ResourceLocation rl = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)inBlock, (String)"tag"));
                    ITag tag = TagCollectionManager.func_242178_a().func_241835_a().func_199910_a(rl);
                    if (tag == null) {
                        throw new JsonSyntaxException("Unknown block tag " + rl + ".");
                    }
                    inBlocks.addAll(tag.func_230236_b_());
                }
            }
            Ingredient ingredient = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? Ingredient.func_199802_a((JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient")) : Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient"));
            Block outBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"outblock")));
            if (JSONUtils.func_151204_g((JsonObject)json, (String)"result")) {
                JsonObject result = JSONUtils.func_152754_s((JsonObject)json, (String)"result");
                resultItem = JSONUtils.func_188180_i((JsonObject)result, (String)"item");
                i = JSONUtils.func_151203_m((JsonObject)result, (String)"count");
            } else {
                resultItem = Items.field_190931_a;
                i = 0;
            }
            ClickType click = ClickType.getClickTypeFor(JSONUtils.func_151219_a((JsonObject)json, (String)"click", (String)"right"));
            ConsumeType consume = ConsumeType.getConsumeTypeFor(JSONUtils.func_151219_a((JsonObject)json, (String)"consume", (String)"weak_consume"));
            SoundEvent sound = null;
            if (JSONUtils.func_151204_g((JsonObject)json, (String)"sound")) {
                sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"sound")));
            }
            return new ClickRecipe(id, inBlocks, ingredient, outBlock, resultItem, i, sound, click, consume);
        }

        public ClickRecipe fromNetwork(ResourceLocation id, PacketBuffer buffer) {
            HashSet inBlocks = Sets.newHashSet();
            int n = buffer.readInt();
            for (int i = 0; i < n; ++i) {
                inBlocks.add(ForgeRegistries.BLOCKS.getValue(new ResourceLocation(buffer.func_150789_c(Short.MAX_VALUE))));
            }
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            Block outBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(buffer.func_150789_c(Short.MAX_VALUE)));
            ItemStack stack = buffer.func_150791_c();
            Item resultItem = stack.func_77973_b();
            int i = stack.func_190916_E();
            SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(buffer.func_150789_c(Short.MAX_VALUE)));
            ClickType click = ClickType.getClickTypeFor(buffer.func_150789_c(Short.MAX_VALUE));
            ConsumeType consume = ConsumeType.getConsumeTypeFor(buffer.func_150789_c(Short.MAX_VALUE));
            return new ClickRecipe(id, inBlocks, ingredient, outBlock, resultItem, i, sound, click, consume);
        }

        public void toNetwork(PacketBuffer buffer, ClickRecipe recipe) {
            buffer.writeInt(recipe.getInputBlocks().size());
            for (Block block : recipe.getInputBlocks()) {
                buffer.func_211400_a(block.getRegistryName().toString(), Short.MAX_VALUE);
            }
            recipe.getInputItem().func_199564_a(buffer);
            buffer.func_211400_a(recipe.getOutputBlock().getRegistryName().toString(), Short.MAX_VALUE);
            buffer.func_150788_a(recipe.func_77571_b());
            buffer.func_211400_a(recipe.soundToPlay.getRegistryName().toString(), Short.MAX_VALUE);
            buffer.func_211400_a(recipe.getClick().toString(), Short.MAX_VALUE);
            buffer.func_211400_a(recipe.getConsume().toString(), Short.MAX_VALUE);
        }
    }
}

