/*
 * Decompiled with CFR 0.152.
 */
package dev.sam.keys_and_leds_core.world.gen.feature;

import dev.falsegamemaster.ihatecores.registration.features.configs.CustomTreeConfig;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;

public class GenericTreeFeatureConfig
extends CustomTreeConfig {
    protected int maxExtraHeight = 0;
    protected Supplier<BlockState> logBlock = () -> Blocks.field_196617_K.getBlock().func_176223_P();

    public GenericTreeFeatureConfig(List<ResourceLocation> schematic) {
        super(schematic);
    }

    public GenericTreeFeatureConfig extraHeight(int maxExtraHeight) {
        this.maxExtraHeight = maxExtraHeight;
        return this;
    }

    public GenericTreeFeatureConfig log(Supplier<BlockState> logBlock) {
        this.logBlock = logBlock;
        return this;
    }

    protected int getExtraHeight(Random random) {
        if (this.maxExtraHeight == 0) {
            return 0;
        }
        return (int)((float)(this.maxExtraHeight + 1) * random.nextFloat());
    }

    @Override
    public List<PlacementSettings> getPlacementSettings(ISeedReader reader, ChunkGenerator generator, Random random, BlockPos original, BlockPos.Mutable mutable, List<Template> template, CompoundNBT nbt) {
        Rotation rotation = Rotation.func_222466_a((Random)random);
        nbt.func_74778_a("rotation", rotation.name());
        List<PlacementSettings> placementSettings = super.getPlacementSettings(reader, generator, random, original, mutable, template, nbt);
        placementSettings.forEach(s -> s.func_186220_a(rotation));
        return placementSettings;
    }

    @Override
    public boolean configureSchematics(ISeedReader reader, ChunkGenerator generator, Random random, BlockPos original, BlockPos.Mutable mutable, List<Template> templates, List<PlacementSettings> settings, CompoundNBT nbt) {
        int extraHeight = this.getExtraHeight(random);
        nbt.func_74768_a("extraHeight", extraHeight);
        if (!this.isClearVertically(reader, original, templates.get(0).func_186259_a().func_177956_o() + extraHeight)) {
            return false;
        }
        mutable.func_196234_d(0, extraHeight, 0);
        for (int i = 0; i < extraHeight; ++i) {
            reader.func_180501_a(original.func_177981_b(i), this.logBlock.get(), 18);
        }
        return true;
    }

    @Override
    public boolean decorateSchematics(ISeedReader reader, ChunkGenerator generator, Random random, BlockPos pos, List<Template> templates, CompoundNBT nbt) {
        if (reader.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_196658_i) {
            reader.func_180501_a(pos.func_177977_b(), Blocks.field_150346_d.getBlock().func_176223_P(), 19);
        }
        return this.decorator.decorateSchematics(reader, generator, random, pos, templates, nbt);
    }
}

