/*
 * Decompiled with CFR 0.152.
 */
package dev.sam.keys_and_leds_core.item;

import java.util.function.Supplier;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
public enum ModArmorMaterial implements IArmorMaterial
{
    HAZMAT("hazmat", 5, new int[]{1, 2, 3, 1}, 15, SoundEvents.field_187728_s, 0.0f, 0.0f, () -> Ingredient.func_199805_a((ITag)ItemTags.createOptional((ResourceLocation)new ResourceLocation("forge", "ingots/aluminum")))),
    LEAD("lead", 15, new int[]{2, 5, 6, 2}, 9, SoundEvents.field_187725_r, 0.0f, 0.0f, () -> Ingredient.func_199805_a((ITag)ItemTags.createOptional((ResourceLocation)new ResourceLocation("forge", "ingots/lead"))));

    private static final int[] HEALTH_PER_SLOT;
    private final String name;
    private final int durabilityMultiplier;
    private final int[] slotProtections;
    private final int enchantmentValue;
    private final SoundEvent sound;
    private final float toughness;
    private final float knockbackResistance;
    private final LazyValue<Ingredient> repairIngredient;

    private ModArmorMaterial(String name, int durabilityMultiplier, int[] slotProtections, int enchantmentValue, SoundEvent sound, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngredient) {
        this.name = name;
        this.durabilityMultiplier = durabilityMultiplier;
        this.slotProtections = slotProtections;
        this.enchantmentValue = enchantmentValue;
        this.sound = sound;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairIngredient = new LazyValue(repairIngredient);
    }

    public int func_200896_a(EquipmentSlotType slotType) {
        return HEALTH_PER_SLOT[slotType.func_188454_b()] * this.durabilityMultiplier;
    }

    public int func_200902_b(EquipmentSlotType slotType) {
        return this.slotProtections[slotType.func_188454_b()];
    }

    public int func_200900_a() {
        return this.enchantmentValue;
    }

    public SoundEvent func_200899_b() {
        return this.sound;
    }

    public Ingredient func_200898_c() {
        return (Ingredient)this.repairIngredient.func_179281_c();
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_200897_d() {
        return "keys_and_leds_core:" + this.name;
    }

    public float func_200901_e() {
        return this.toughness;
    }

    public float func_230304_f_() {
        return this.knockbackResistance;
    }

    static {
        HEALTH_PER_SLOT = new int[]{13, 15, 16, 11};
    }
}

