/*
 * Decompiled with CFR 0.152.
 */
package dev.sam.keys_and_leds_core.item;

import dev.sam.keys_and_leds_core.KeysAndLedsCore;
import dev.sam.keys_and_leds_core.block.interfaces.IExclusiveLockable;
import dev.sam.keys_and_leds_core.block.interfaces.ILockable;
import dev.sam.keys_and_leds_core.state.properties.LockTypes;
import dev.sam.keys_and_leds_core.state.properties.ModBlockStateProperties;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.IVanishable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class KeyItem
extends Item
implements IVanishable {
    protected final LockTypes lockTypes;

    public KeyItem(Item.Properties properties, LockTypes lockTypes) {
        super(properties);
        this.lockTypes = lockTypes;
    }

    public ActionResultType func_195939_a(ItemUseContext use) {
        World world = use.func_195991_k();
        BlockPos pos = use.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        PlayerEntity player = use.func_195999_j();
        Item itemInHand = use.func_195996_i().func_77973_b();
        LockTypes itemType = ((KeyItem)itemInHand).lockTypes;
        if (!(player != null && (block instanceof ILockable || block instanceof IExclusiveLockable && ((Boolean)state.func_177229_b((Property)ModBlockStateProperties.IS_LOCKABLE)).booleanValue()))) {
            return ActionResultType.FAIL;
        }
        if (state.func_177229_b(ModBlockStateProperties.LOCK_TYPES) == LockTypes.NONE) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a(ModBlockStateProperties.LOCK_TYPES, (Comparable)((Object)itemType)));
            world.func_184133_a(null, pos, (SoundEvent)KeysAndLedsCore.SOUNDS.get("item.lock_util.lock"), SoundCategory.BLOCKS, 3.0f, 0.7f);
        } else if (this == KeysAndLedsCore.ITEMS.get("debug_key") || this == ((LockTypes)((Object)state.func_177229_b(ModBlockStateProperties.LOCK_TYPES))).getKey()) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a(ModBlockStateProperties.LOCK_TYPES, (Comparable)((Object)LockTypes.NONE)));
            world.func_184133_a(null, pos, (SoundEvent)KeysAndLedsCore.SOUNDS.get("item.lock_util.unlock"), SoundCategory.BLOCKS, 3.0f, 0.7f);
        }
        return ActionResultType.FAIL;
    }

    @Mod.EventBusSubscriber(modid="keys_and_leds_core", bus=Mod.EventBusSubscriber.Bus.FORGE)
    protected static class ClientOnly {
        protected ClientOnly() {
        }

        @SubscribeEvent
        protected static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
            if (event.getItemStack().func_77973_b() instanceof KeyItem) {
                event.setCanceled(true);
            }
        }
    }
}

