/*
 * Decompiled with CFR 0.152.
 */
package dev.sam.keys_and_leds_core.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import dev.falsegamemaster.ihatecores.registration.events.InGameEventHandler;
import dev.sam.keys_and_leds_core.block.interfaces.ISmashable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.IVanishable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.TieredItem;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class HammerItem
extends TieredItem
implements IVanishable {
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public HammerItem(IItemTier itemTier, float damageModifier, float speedModifier, Item.Properties properties) {
        super(itemTier, properties);
        float attackDamage = damageModifier + itemTier.func_200929_c();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)speedModifier, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public ItemStack getContainerItem(ItemStack stack) {
        ItemStack remainingStack = stack.func_77946_l();
        return remainingStack.func_96631_a(1, field_77697_d, null) ? ItemStack.field_190927_a : remainingStack;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity enemy, LivingEntity player) {
        stack.func_222118_a(2, player, item -> item.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity player) {
        Block block = player.field_70170_p.func_180495_p(pos).func_177230_c();
        if (block instanceof ISmashable && (double)state.func_185887_b((IBlockReader)world, pos) != 0.0) {
            stack.func_222118_a(1, player, item -> item.func_213361_c(EquipmentSlotType.MAINHAND));
        } else {
            stack.func_222118_a(2, player, item -> item.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public boolean func_150897_b(BlockState state) {
        return state.func_177230_c() instanceof ISmashable;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        return state.func_177230_c() instanceof ISmashable ? (super.func_150893_a(stack, state) + 4.0f) * 2.0f - 4.0f : 1.0f;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        Block block = player.field_70170_p.func_180495_p(pos).func_177230_c();
        if (!(block instanceof ISmashable)) {
            return false;
        }
        return ((ISmashable)block).smash(player, pos);
    }

    @SubscribeEvent
    protected void onSetSmashSpeed(PlayerEvent.BreakSpeed breakSpeed) {
        PlayerEntity player = breakSpeed.getPlayer();
        Item heldItem = player.func_184586_b(Hand.MAIN_HAND).func_77973_b();
        if (!(heldItem instanceof HammerItem)) {
            return;
        }
        World world = player.field_70170_p;
        BlockPos pos = breakSpeed.getPos();
        Block block = world.func_180495_p(pos).func_177230_c();
        if (!(block instanceof ISmashable)) {
            return;
        }
        breakSpeed.setNewSpeed(((ISmashable)block).getSmashSpeed(breakSpeed));
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType slot) {
        return slot == EquipmentSlotType.MAINHAND ? this.defaultModifiers : super.func_111205_h(slot);
    }

    public int func_77619_b() {
        return 1;
    }

    public static class SpeedEvent
    implements InGameEventHandler {
        @SubscribeEvent
        protected static void onSetSmashSpeed(PlayerEvent.BreakSpeed breakSpeed) {
            PlayerEntity player = breakSpeed.getPlayer();
            Item heldItem = player.func_184586_b(Hand.MAIN_HAND).func_77973_b();
            if (!(heldItem instanceof HammerItem)) {
                return;
            }
            World world = player.field_70170_p;
            BlockPos pos = breakSpeed.getPos();
            Block block = world.func_180495_p(pos).func_177230_c();
            if (!(block instanceof ISmashable)) {
                return;
            }
            breakSpeed.setNewSpeed(((ISmashable)block).getSmashSpeed(breakSpeed));
        }
    }
}

