/*
 * Decompiled with CFR 0.152.
 */
package dev.sam.keys_and_leds_core.block.util;

import dev.falsegamemaster.ihatecores.registration.blocks.PropertyCyclerMap;
import dev.falsegamemaster.ihatecores.util.data_structures.WrappedList;
import dev.sam.keys_and_leds_core.block.interfaces.IPropertyCycler;
import dev.sam.keys_and_leds_core.block.interfaces.IWrench;
import dev.sam.keys_and_leds_core.block.interfaces.IWrenchable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;

public class WrenchUtil {
    public static void selectProperty(World world, BlockPos pos, PlayerEntity player, ItemStack stack, PropertyCyclerMap cyclerMap, List<Property<?>> validProperties) {
        if (!(stack.func_77973_b() instanceof IWrench)) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        IWrenchable wrenchable = IWrenchable.getWrenchableFor(block, cyclerMap, validProperties);
        if (wrenchable == null) {
            return;
        }
        WrappedList properties = wrenchable.getCyclers().stream().map(IPropertyCycler::getProperty).collect(WrappedList::new, ArrayList::add, ArrayList::addAll);
        if (properties.isEmpty()) {
            return;
        }
        CompoundNBT nbt = stack.func_196082_o();
        Property property = block.func_176194_O().func_185920_a(nbt.func_74779_i("property"));
        Property cycled = property == null || !properties.contains(property) ? (Property)properties.get(false) : (player.func_226563_dT_() ? properties.getPrevious(property) : properties.getNext(property));
        nbt.func_74778_a("property", cycled.func_177701_a());
        WrenchUtil.message(player, (ITextComponent)new TranslationTextComponent(Items.field_196180_eI.func_77658_a() + ".select", new Object[]{cycled.func_177701_a(), WrenchUtil.getPropertyValueName(state, cycled)}));
    }

    public static void selectProperty(PlayerInteractEvent.LeftClickBlock event, PropertyCyclerMap cyclerMap, List<Property<?>> validProperties) {
        WrenchUtil.selectProperty(event.getWorld(), event.getPos(), event.getPlayer(), event.getItemStack(), cyclerMap, validProperties);
        if (event.getItemStack().func_77973_b() instanceof IWrench) {
            event.setCanceled(true);
        }
    }

    public static ActionResultType cycleProperty(ItemUseContext context, PropertyCyclerMap cyclerMap, List<Property<?>> validProperties) {
        ItemStack stack = context.func_195996_i();
        if (!(stack.func_77973_b() instanceof IWrench)) {
            return ActionResultType.FAIL;
        }
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        IWrenchable wrenchable = IWrenchable.getWrenchableFor(block, cyclerMap, validProperties);
        PlayerEntity player = context.func_195999_j();
        if (wrenchable == null) {
            return ActionResultType.FAIL;
        }
        WrappedList properties = wrenchable.getCyclers().stream().map(IPropertyCycler::getProperty).collect(WrappedList::new, ArrayList::add, ArrayList::addAll);
        CompoundNBT nbt = stack.func_196082_o();
        Property property = block.func_176194_O().func_185920_a(nbt.func_74779_i("property"));
        if (property == null || !properties.contains(property)) {
            WrenchUtil.selectProperty(world, pos, context.func_195999_j(), stack, cyclerMap, validProperties);
            String propertyString = stack.func_196082_o().func_74779_i("property");
            property = block.func_176194_O().func_185920_a(propertyString);
        }
        return WrenchUtil.cycleProperty(world, pos, state, player, wrenchable, property, context.func_225518_g_());
    }

    static <T extends Comparable<T>> ActionResultType cycleProperty(World world, BlockPos pos, BlockState state, PlayerEntity player, IWrenchable wrenchable, Property<T> property, boolean reverse) {
        IPropertyCycler<Comparable> cycler = wrenchable.getCyclerFor(property);
        if (cycler == null) {
            return ActionResultType.FAIL;
        }
        Comparable current = state.func_177229_b(property);
        Comparable cycled = reverse ? cycler.getPrevious(world, pos, property, current) : cycler.getNext(world, pos, property, current);
        BlockState updated = (BlockState)state.func_206870_a(property, cycled);
        if (cycler.shouldUpdateBlocks(world, pos)) {
            WrenchUtil.setBlockAndUpdateNeighbors(world, pos, updated);
        } else {
            world.func_180501_a(pos, updated, 18);
        }
        WrenchUtil.message(player, (ITextComponent)new TranslationTextComponent(Items.field_196180_eI.func_77658_a() + ".update", new Object[]{property.func_177701_a(), property.func_177702_a(cycled)}));
        return ActionResultType.SUCCESS;
    }

    public static void cancelBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        Item item = event.getItemStack().func_77973_b();
        if (item instanceof IWrench) {
            event.setUseBlock(Event.Result.DENY);
        }
    }

    protected static void setBlockAndUpdateNeighbors(World world, BlockPos pos, BlockState state) {
        BlockState neighborState;
        BlockPos neighborPos;
        for (Direction direction : Direction.values()) {
            neighborPos = pos.func_177972_a(direction);
            neighborState = world.func_180495_p(neighborPos);
            BlockState updatedState = state.func_196956_a(direction, neighborState, (IWorld)world, pos, neighborPos);
            world.func_175656_a(pos, updatedState);
        }
        for (Direction direction : Direction.values()) {
            neighborPos = pos.func_177972_a(direction);
            neighborState = world.func_180495_p(neighborPos);
            BlockState updatedNeighborState = neighborState.func_196956_a(direction.func_176734_d(), state, (IWorld)world, neighborPos, pos);
            world.func_175656_a(neighborPos, updatedNeighborState);
        }
    }

    protected static void message(PlayerEntity player, ITextComponent text) {
        if (!(player instanceof ServerPlayerEntity)) {
            return;
        }
        ((ServerPlayerEntity)player).func_241151_a_(text, ChatType.GAME_INFO, Util.field_240973_b_);
    }

    protected static <T extends Comparable<T>> String getPropertyValueName(BlockState state, Property<T> property) {
        return property.func_177702_a(state.func_177229_b(property));
    }
}

