/*
 * Decompiled with CFR 0.152.
 */
package dev.sam.keys_and_leds_core.block.interfaces;

import dev.falsegamemaster.ihatecores.registration.features.configs.CustomTreeConfig;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public interface ISaplingBlock
extends IGrowable {
    @Nullable
    public ConfiguredFeature<? extends CustomTreeConfig, ?> getConfiguredFeature(Random var1, boolean var2);

    default public boolean growTree(ServerWorld world, ChunkGenerator generator, BlockPos pos, BlockState state, Random random) {
        ConfiguredFeature<? extends CustomTreeConfig, ?> configuredfeature = this.getConfiguredFeature(random, this.hasFlowers((IWorld)world, pos));
        if (configuredfeature == null) {
            return false;
        }
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 4);
        ((CustomTreeConfig)configuredfeature.field_222738_b).setFromSapling();
        if (configuredfeature.func_242765_a((ISeedReader)world, generator, random, pos)) {
            return true;
        }
        world.func_180501_a(pos, state, 4);
        return false;
    }

    default public boolean hasFlowers(IWorld world, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.Mutable.func_218278_a((BlockPos)pos.func_177977_b().func_177964_d(2).func_177985_f(2), (BlockPos)pos.func_177984_a().func_177970_e(2).func_177965_g(2))) {
            if (!world.func_180495_p(blockpos).func_235714_a_((ITag)BlockTags.field_226149_I_)) continue;
            return true;
        }
        return false;
    }

    default public void advanceTree(ServerWorld world, BlockPos pos, BlockState state, Random random) {
        if ((Integer)state.func_177229_b((Property)BlockStateProperties.field_208137_al) == 0) {
            world.func_180501_a(pos, (BlockState)state.func_235896_a_((Property)BlockStateProperties.field_208137_al), 4);
        } else {
            if (!ForgeEventFactory.saplingGrowTree((IWorld)world, (Random)random, (BlockPos)pos)) {
                return;
            }
            this.growTree(world, world.func_72863_F().func_201711_g(), pos, state, random);
        }
    }

    default public float bonemealSuccessChance() {
        return 0.45f;
    }

    @ParametersAreNonnullByDefault
    default public boolean func_176473_a(IBlockReader reader, BlockPos pos, BlockState state, boolean wtf) {
        return true;
    }

    @ParametersAreNonnullByDefault
    default public boolean func_180670_a(World world, Random random, BlockPos pos, BlockState state) {
        return world.field_73012_v.nextFloat() < this.bonemealSuccessChance();
    }

    @ParametersAreNonnullByDefault
    default public void func_225535_a_(ServerWorld world, Random random, BlockPos pos, BlockState state) {
        this.advanceTree(world, pos, state, random);
    }
}

