/*
 * Decompiled with CFR 0.152.
 */
package dev.sam.keys_and_leds_core.block.interfaces;

import dev.falsegamemaster.ihatecores.registration.blocks.PropertyCyclerMap;
import dev.falsegamemaster.ihatecores.util.data_structures.WrappedList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface IPropertyCycler<T extends Comparable<T>> {
    public static <T extends Comparable<T>> IPropertyCycler<T> getCyclerFor(Property<T> property, PropertyCyclerMap cyclerMap) {
        IPropertyCycler<T> cycler = cyclerMap.get(property);
        return cycler == null ? IPropertyCycler.of(property) : cycler;
    }

    public static <T extends Comparable<T>> IPropertyCycler<T> of(final Property<T> property) {
        final WrappedList values = new WrappedList(property.func_177700_c());
        return new IPropertyCycler<T>(){

            @Override
            public Property<T> getProperty() {
                return property;
            }

            @Override
            public T getNext(World world, BlockPos pos, Property<T> property2, T current) {
                return (Comparable)values.getNext(current);
            }

            @Override
            public T getPrevious(World world, BlockPos pos, Property<T> property2, T current) {
                return (Comparable)values.getPrevious(current);
            }
        };
    }

    public static <T extends Comparable<T>> IPropertyCycler<T> of(final Property<T> property, final Cycler<T> next, final Cycler<T> previous) {
        return new IPropertyCycler<T>(){

            @Override
            public Property<T> getProperty() {
                return property;
            }

            @Override
            public T getNext(World world, BlockPos pos, Property<T> property2, T current) {
                return next.cycle(world, pos, property2, current);
            }

            @Override
            public T getPrevious(World world, BlockPos pos, Property<T> property2, T current) {
                return previous.cycle(world, pos, property2, current);
            }
        };
    }

    public static <T extends Comparable<T>> IPropertyCycler<T> of(final Property<T> property, final Cycler<T> next, final Cycler<T> previous, final BiPredicate<World, BlockPos> shouldUpdateBlocks, final Supplier<List<Block>> blacklistedBlocks) {
        return new IPropertyCycler<T>(){

            @Override
            public Property<T> getProperty() {
                return property;
            }

            @Override
            public T getNext(World world, BlockPos pos, Property<T> property2, T current) {
                return next.cycle(world, pos, property2, current);
            }

            @Override
            public T getPrevious(World world, BlockPos pos, Property<T> property2, T current) {
                return previous.cycle(world, pos, property2, current);
            }

            @Override
            public boolean shouldUpdateBlocks(World world, BlockPos pos) {
                return shouldUpdateBlocks.test(world, pos);
            }

            @Override
            public List<Block> getBlacklistedBlocks() {
                return (List)blacklistedBlocks.get();
            }
        };
    }

    public Property<T> getProperty();

    public T getNext(World var1, BlockPos var2, Property<T> var3, T var4);

    public T getPrevious(World var1, BlockPos var2, Property<T> var3, T var4);

    default public boolean shouldUpdateBlocks(World world, BlockPos pos) {
        return true;
    }

    default public List<Block> getBlacklistedBlocks() {
        return new ArrayList<Block>();
    }

    public static class Builder<T extends Comparable<T>> {
        protected final Property<T> property;
        protected Cycler<T> next;
        protected Cycler<T> previous;
        protected BiPredicate<World, BlockPos> shouldUpdateBlocks;
        protected List<Supplier<List<Block>>> blacklistedBlockLists;

        public static <T extends Comparable<T>> Builder<T> of(Property<T> property) {
            return new Builder<T>(property);
        }

        public static <T extends Comparable<T>> Builder<T> of(IPropertyCycler<T> cycler) {
            return new Builder<T>(cycler);
        }

        protected Builder(Property<T> property) {
            this.property = property;
            WrappedList values = new WrappedList(this.property.func_177700_c());
            this.next = (w, p, s, t) -> values.getNext(t);
            this.previous = (w, p, s, t) -> values.getPrevious(t);
            this.shouldUpdateBlocks = (w, p) -> true;
            this.blacklistedBlockLists = new ArrayList<Supplier<List<Block>>>();
        }

        protected Builder(IPropertyCycler<T> cycler) {
            this.property = cycler.getProperty();
            this.next = cycler::getNext;
            this.previous = cycler::getPrevious;
            this.shouldUpdateBlocks = cycler::shouldUpdateBlocks;
            this.blacklistedBlockLists = new ArrayList<Supplier<List>>(Collections.singletonList(cycler::getBlacklistedBlocks));
        }

        public Builder<T> next(Cycler<T> next) {
            this.next = next;
            return this;
        }

        public Builder<T> previous(Cycler<T> previous) {
            this.previous = previous;
            return this;
        }

        public Builder<T> shouldUpdateBlocks(BiPredicate<World, BlockPos> shouldUpdateBlocks) {
            this.shouldUpdateBlocks = shouldUpdateBlocks;
            return this;
        }

        public Builder<T> blacklistedBlocks(Supplier<List<Block>> blacklistedBlocks) {
            this.blacklistedBlockLists.add(blacklistedBlocks);
            return this;
        }

        @SafeVarargs
        public final Builder<T> blacklistedBlocks(Supplier<Block> ... blacklistedBlocks) {
            this.blacklistedBlockLists.add(() -> Arrays.stream(blacklistedBlocks).map(Supplier::get).collect(Collectors.toList()));
            return this;
        }

        @Deprecated
        public Builder<T> blacklistedBlocks(List<Block> blacklistedBlocks) {
            this.blacklistedBlockLists.add(() -> blacklistedBlocks);
            return this;
        }

        @Deprecated
        public Builder<T> blacklistedBlocks(Block ... blacklistedBlocks) {
            return this.blacklistedBlocks(Arrays.asList(blacklistedBlocks));
        }

        @SafeVarargs
        public final Builder<T> blacklistedTags(ITag<Block> ... blacklistedTags) {
            this.blacklistedBlockLists.add(() -> {
                ArrayList blacklistedBlocks = new ArrayList();
                for (ITag tag : blacklistedTags) {
                    blacklistedBlocks.addAll(tag.func_230236_b_());
                }
                return blacklistedBlocks;
            });
            return this;
        }

        protected static Supplier<List<Block>> mergeBlacklistedBlockLists(List<Supplier<List<Block>>> blacklistedBlockLists) {
            return () -> {
                ArrayList blacklistedBlocks = new ArrayList();
                for (Supplier listSupplier : blacklistedBlockLists) {
                    blacklistedBlocks.addAll((Collection)listSupplier.get());
                }
                return blacklistedBlocks;
            };
        }

        public IPropertyCycler<T> build() {
            return IPropertyCycler.of(this.property, this.next, this.previous, this.shouldUpdateBlocks, Builder.mergeBlacklistedBlockLists(this.blacklistedBlockLists));
        }
    }

    public static interface Cycler<T extends Comparable<T>> {
        public T cycle(World var1, BlockPos var2, Property<T> var3, T var4);
    }
}

