/*
 * Decompiled with CFR 0.152.
 */
package dev.sam.keys_and_leds_core.block;

import com.google.common.collect.Lists;
import dev.falsegamemaster.ihatecores.registration.events.StartupEventHandler;
import dev.sam.keys_and_leds_core.block.interfaces.IScrewable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RedstoneTorchBlock;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@ParametersAreNonnullByDefault
public class SmartRedstoneTorchBlock
extends RedstoneTorchBlock
implements IScrewable,
StartupEventHandler {
    private static final Map<IBlockReader, List<Toggle>> RECENT_TOGGLES = new WeakHashMap<IBlockReader, List<Toggle>>();

    SmartRedstoneTorchBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208188_o, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BlockStateProperties.field_208136_ak, (Comparable)Integer.valueOf(15))).func_206870_a((Property)field_196528_a, (Comparable)Boolean.valueOf(true)));
    }

    @SubscribeEvent
    public void onClientSetup(FMLClientSetupEvent clientSetupEvent) {
        ((Minecraft)clientSetupEvent.getMinecraftSupplier().get()).func_184125_al().func_186722_a((state, reader, pos, color) -> {
            int power = (Integer)state.func_177229_b((Property)BlockStateProperties.field_208136_ak);
            return RedstoneWireBlock.func_235550_b_((int)power);
        }, new Block[]{this});
    }

    protected void func_206840_a(@Nullable StateContainer.Builder<Block, BlockState> state) {
        if (state == null) {
            return;
        }
        state.func_206894_a(new Property[]{BlockStateProperties.field_208188_o, BlockStateProperties.field_208136_ak, field_196528_a});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = this.func_176223_P();
        int signal = this.getTorchSignal(state, world, pos);
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_196528_a, (Comparable)Boolean.valueOf(signal > 0))).func_206870_a((Property)BlockStateProperties.field_208136_ak, (Comparable)Integer.valueOf(signal));
    }

    protected int getTorchSignal(BlockState state, World world, BlockPos pos) {
        int signal = this.getNeighborSignal(state, world, pos);
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208188_o) != false ? signal : 15 - signal;
    }

    protected int getNeighborSignal(@Nullable BlockState state, @Nullable World world, @Nullable BlockPos pos) {
        if (state == null || world == null || pos == null) {
            return 0;
        }
        int signal = 0;
        ArrayList<Direction> dirs = new ArrayList<Direction>(Arrays.asList(Direction.values()));
        dirs.remove(Direction.UP);
        BlockPos attachPos = pos.func_177977_b();
        for (Direction dir : dirs) {
            signal = Math.max(signal, world.func_175651_c(attachPos, dir));
        }
        return signal;
    }

    public int func_180656_a(BlockState state, IBlockReader reader, BlockPos pos, Direction direction) {
        return direction != Direction.UP ? (Integer)state.func_177229_b((Property)BlockStateProperties.field_208136_ak) : 0;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos neighborPos, boolean why) {
        if (((Integer)state.func_177229_b((Property)BlockStateProperties.field_208136_ak)).intValue() != this.getTorchSignal(state, world, pos) && !world.func_205220_G_().func_205361_b(pos, (Object)this)) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, 2);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        int signal = world.func_175687_A(pos);
        List<Toggle> list = RECENT_TOGGLES.get(world);
        while (list != null && !list.isEmpty() && world.func_82737_E() - list.get(0).when > 60L) {
            list.remove(0);
        }
        int torchSignal = this.getTorchSignal(state, (World)world, pos);
        if (signal > 0) {
            world.func_175656_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)field_196528_a, (Comparable)Boolean.valueOf(torchSignal > 0))).func_206870_a((Property)BlockStateProperties.field_208136_ak, (Comparable)Integer.valueOf(torchSignal)));
            if (SmartRedstoneTorchBlock.isToggledTooFrequently((World)world, pos, true)) {
                world.func_217379_c(1502, pos, 0);
                world.func_205220_G_().func_205360_a(pos, (Object)world.func_180495_p(pos).func_177230_c(), 160);
            }
        } else if (signal == 0 && !SmartRedstoneTorchBlock.isToggledTooFrequently((World)world, pos, false)) {
            world.func_175656_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)field_196528_a, (Comparable)Boolean.valueOf(torchSignal > 0))).func_206870_a((Property)BlockStateProperties.field_208136_ak, (Comparable)Integer.valueOf(torchSignal)));
        }
    }

    protected static boolean isToggledTooFrequently(World world, BlockPos pos, boolean toggle) {
        List list = RECENT_TOGGLES.computeIfAbsent((IBlockReader)world, reader -> Lists.newArrayList());
        if (toggle) {
            list.add(new Toggle(pos.func_185334_h(), world.func_82737_E()));
        }
        int i = 0;
        for (Toggle redstonetorchblock$toggle : list) {
            if (!redstonetorchblock$toggle.pos.equals((Object)pos) || ++i < 8) continue;
            return true;
        }
        return false;
    }

    @Override
    public void screw(ItemUseContext use) {
        World world = use.func_195991_k();
        BlockPos pos = use.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        BlockState updated = (BlockState)state.func_235896_a_((Property)BlockStateProperties.field_208188_o);
        updated = (BlockState)((BlockState)updated.func_206870_a((Property)BlockStateProperties.field_208136_ak, (Comparable)Integer.valueOf(this.getTorchSignal(updated, world, pos)))).func_206870_a((Property)field_196528_a, (Comparable)Boolean.valueOf(this.getTorchSignal(updated, world, pos) != 0));
        world.func_175656_a(pos, updated);
    }

    public static class Toggle {
        private final BlockPos pos;
        private final long when;

        public Toggle(BlockPos pos, long when) {
            this.pos = pos;
            this.when = when;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public long getWhen() {
            return this.when;
        }
    }
}

