/*
 * Decompiled with CFR 0.152.
 */
package dev.sam.keys_and_leds_core.block;

import dev.falsegamemaster.ihatecores.registration.blocks.BlockMap;
import dev.falsegamemaster.ihatecores.registration.blocks.ModSaplingBlock;
import dev.falsegamemaster.ihatecores.registration.blocks.ModSignBlock;
import dev.sam.keys_and_leds_core.KeysAndLedsCore;
import dev.sam.keys_and_leds_core.block.ControlCabinetBlock;
import dev.sam.keys_and_leds_core.block.ExposedUraniumOreBlock;
import dev.sam.keys_and_leds_core.block.FlammableLeavesBlock;
import dev.sam.keys_and_leds_core.block.FlammableLogBlock;
import dev.sam.keys_and_leds_core.block.GenericMetalTableBlock;
import dev.sam.keys_and_leds_core.block.JunctionBoxBlock;
import dev.sam.keys_and_leds_core.block.RedstoneLampBlock;
import dev.sam.keys_and_leds_core.block.SmartRedstoneTorchBlock;
import dev.sam.keys_and_leds_core.block.SmartRedstoneWallTorchBlock;
import dev.sam.keys_and_leds_core.block.StrippableFlammableLogBlock;
import dev.sam.keys_and_leds_core.block.StrippedTappableLogBlock;
import dev.sam.keys_and_leds_core.block.TappableLogBlock;
import dev.sam.keys_and_leds_core.block.UraniumBlock;
import dev.sam.keys_and_leds_core.block.UraniumOreBlock;
import dev.sam.keys_and_leds_core.item.ModItemGroup;
import dev.sam.keys_and_leds_core.util.SafeBlockState;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WoodButtonBlock;
import net.minecraft.block.WoodType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraftforge.common.ToolType;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ModBlocks {
    public static void create(BlockMap blocks) {
        Supplier<Item.Properties> materialItem = () -> new Item.Properties().func_200916_a(ModItemGroup.MOD_KEY_LED_MATERIAL);
        Supplier<Item.Properties> electricalItem = () -> new Item.Properties().func_200916_a(ModItemGroup.MOD_KEY_LED_ELECTRICAL);
        Supplier<AbstractBlock.Properties> ore = () -> AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(3.0f, 3.0f).harvestTool(ToolType.PICKAXE).harvestLevel(1).func_235861_h_();
        Supplier<AbstractBlock.Properties> storageBlock = () -> AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(5.0f, 6.0f).harvestTool(ToolType.PICKAXE).harvestLevel(1).func_235861_h_().func_200947_a(SoundType.field_185852_e);
        Supplier<AbstractBlock.Properties> woodDirt = () -> AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151664_l);
        Supplier<AbstractBlock.Properties> woodenPlanks = () -> ((AbstractBlock.Properties)woodDirt.get()).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a);
        Supplier<AbstractBlock.Properties> woodenButton = () -> AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a).harvestTool(ToolType.AXE);
        Supplier<AbstractBlock.Properties> woodenSign = () -> ((AbstractBlock.Properties)woodDirt.get()).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a);
        Supplier<AbstractBlock.Properties> smartTorch = () -> AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200946_b().func_235838_a_(ModBlocks.litBlockEmission(7, 0)).func_200947_a(SoundType.field_185848_a);
        Supplier<AbstractBlock.Properties> metalBlock = () -> AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(5.0f, 6.0f).harvestTool(ToolType.PICKAXE).harvestLevel(1).func_235861_h_().func_200947_a(SoundType.field_185852_e);
        Supplier<WoodType> rubberWoodType = () -> KeysAndLedsCore.WOODTYPES.get("rubber");
        Supplier<TileEntityType<?>> rubberBlockEntity = () -> (TileEntityType)KeysAndLedsCore.BLOCK_ENTITIES.get("rubber_sign");
        blocks.put("bauxite_ore", new Block(ore.get()), materialItem.get());
        blocks.put("copper_ore", new Block(ore.get()), materialItem.get());
        blocks.put("galena_ore", new Block(ore.get()), materialItem.get());
        blocks.put("garnierite_ore", new Block(ore.get()), materialItem.get());
        blocks.put("silver_ore", new Block(ore.get()), materialItem.get());
        blocks.put("uranium_ore", new UraniumOreBlock(ore.get().func_235838_a_(state -> 2).func_235827_a_((state, reader, pos, type) -> false)));
        blocks.put("exposed_uranium_ore", new ExposedUraniumOreBlock(ore.get().func_235838_a_(state -> 4).func_235827_a_((state, reader, pos, type) -> false).func_222379_b((Block)KeysAndLedsCore.BLOCKS.get("uranium_ore"))));
        blocks.put("sphalerite_ore", new Block(ore.get()), materialItem.get());
        blocks.put("aluminum_block", new Block(storageBlock.get()), materialItem.get());
        blocks.put("brass_block", new Block(storageBlock.get()), materialItem.get());
        blocks.put("constantan_block", new Block(storageBlock.get()), materialItem.get());
        blocks.put("copper_block", new Block(storageBlock.get()), materialItem.get());
        blocks.put("lead_block", new Block(storageBlock.get()), materialItem.get());
        blocks.put("nickel_block", new Block(storageBlock.get()), materialItem.get());
        blocks.put("steel_block", new Block(storageBlock.get()), materialItem.get());
        blocks.put("silver_block", new Block(storageBlock.get()), materialItem.get());
        blocks.put("uranium_block", (Block)new UraniumBlock(storageBlock.get().func_235838_a_(state -> 5)), materialItem.get());
        blocks.put("zinc_block", new Block(storageBlock.get()), materialItem.get());
        blocks.put("rubber_sapling", (Block)new ModSaplingBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185850_c), () -> (ConfiguredFeature)KeysAndLedsCore.FEATURES.get("rubber_tree_common")), materialItem.get());
        blocks.put("potted_rubber_sapling", (Block)new FlowerPotBlock((Block)KeysAndLedsCore.BLOCKS.get("rubber_sapling"), AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200946_b().func_226896_b_()));
        blocks.put("rubber_leaves", (Block)new FlammableLeavesBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151584_j).func_200943_b(0.2f).func_200944_c().func_200947_a(SoundType.field_185850_c).func_226896_b_().func_235827_a_((state, reader, pos, type) -> type == EntityType.field_200781_U || type == EntityType.field_200783_W).func_235842_b_((state, reader, pos) -> false).func_235847_c_((state, reader, pos) -> false)), materialItem.get());
        blocks.put("rubber_log", (Block)new TappableLogBlock(AbstractBlock.Properties.func_235836_a_((Material)Material.field_151575_d, state -> state.func_177229_b((Property)RotatedPillarBlock.field_176298_M) == Direction.Axis.Y ? MaterialColor.field_151676_q : MaterialColor.field_151654_J).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a), () -> (Block)KeysAndLedsCore.BLOCKS.get("stripped_rubber_log")), materialItem.get());
        blocks.put("rubber_wood", (Block)new StrippableFlammableLogBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151650_B).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a), () -> (Block)KeysAndLedsCore.BLOCKS.get("stripped_rubber_wood")), materialItem.get());
        blocks.put("stripped_rubber_log", (Block)new StrippedTappableLogBlock(woodDirt.get().func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a), () -> (Item)KeysAndLedsCore.ITEMS.get("latex_sap_pan")), materialItem.get());
        blocks.put("stripped_rubber_wood", (Block)new FlammableLogBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151676_q).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)), materialItem.get());
        blocks.put("rubber_planks", new Block(woodenPlanks.get()), materialItem.get());
        blocks.put("rubber_stairs", (Block)new StairsBlock(((Block)KeysAndLedsCore.BLOCKS.get("rubber_planks")).func_176223_P(), AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)KeysAndLedsCore.BLOCKS.get("rubber_planks")))), materialItem.get());
        blocks.put("rubber_slab", (Block)new SlabBlock(woodenPlanks.get()), materialItem.get());
        blocks.put("rubber_fence", (Block)new FenceBlock(woodenPlanks.get()), materialItem.get());
        blocks.put("rubber_fence_gate", (Block)new FenceGateBlock(woodenPlanks.get()), materialItem.get());
        blocks.put("rubber_door", (Block)new DoorBlock(woodDirt.get().func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_()), materialItem.get());
        blocks.put("rubber_trapdoor", (Block)new TrapDoorBlock(woodDirt.get().func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_().func_235827_a_((state, reader, pos, type) -> false)), materialItem.get());
        blocks.put("rubber_pressure_plate", (Block)new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, woodDirt.get().func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)), materialItem.get());
        blocks.put("rubber_button", (Block)new WoodButtonBlock(woodenButton.get()), materialItem.get());
        blocks.put("rubber_sign", (Block)new ModSignBlock.Standing(woodenSign.get(), rubberWoodType, rubberBlockEntity));
        blocks.put("rubber_wall_sign", (Block)new ModSignBlock.Wall(woodenSign.get().func_222379_b((Block)KeysAndLedsCore.BLOCKS.get("rubber_sign")), rubberWoodType, rubberBlockEntity));
        blocks.put("smart_redstone_torch", (Block)new SmartRedstoneTorchBlock(smartTorch.get()));
        blocks.put("smart_redstone_wall_torch", (Block)new SmartRedstoneWallTorchBlock(smartTorch.get().func_222379_b((Block)KeysAndLedsCore.BLOCKS.get("smart_redstone_torch"))));
        blocks.put("junction_box", (Block)new JunctionBoxBlock(metalBlock.get()), electricalItem.get());
        blocks.put("control_cabinet", (Block)new ControlCabinetBlock(metalBlock.get()), electricalItem.get());
        blocks.put("redstone_lamp", new RedstoneLampBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151591_t).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f).func_235838_a_(state -> 15)));
        blocks.put("metal_table", (Block)new GenericMetalTableBlock(metalBlock.get()), materialItem.get());
    }

    private static ToIntFunction<BlockState> litBlockEmission(int on, int off) {
        return state -> SafeBlockState.of(state).getValue(BlockStateProperties.field_208190_q).orElse(false) != false ? on : off;
    }
}

