/*
 * Decompiled with CFR 0.152.
 */
package dev.sam.keys_and_leds_core;

import dev.falsegamemaster.ihatecores.api.IHateCoresIntegration;
import dev.falsegamemaster.ihatecores.registration.RegistryCreators;
import dev.falsegamemaster.ihatecores.registration.RegistryMaps;
import dev.falsegamemaster.ihatecores.registration.block_entities.BlockEntityMap;
import dev.falsegamemaster.ihatecores.registration.blocks.BlockMap;
import dev.falsegamemaster.ihatecores.registration.blocks.PropertyCyclerMap;
import dev.falsegamemaster.ihatecores.registration.blocks.WoodTypeMap;
import dev.falsegamemaster.ihatecores.registration.config.Config;
import dev.falsegamemaster.ihatecores.registration.config.ConfigMaps;
import dev.falsegamemaster.ihatecores.registration.containers.ContainerMap;
import dev.falsegamemaster.ihatecores.registration.effects.EffectMap;
import dev.falsegamemaster.ihatecores.registration.entities.EntityMap;
import dev.falsegamemaster.ihatecores.registration.events.EventHandlers;
import dev.falsegamemaster.ihatecores.registration.features.FeatureMap;
import dev.falsegamemaster.ihatecores.registration.features.categories.FeatureCategoryMap;
import dev.falsegamemaster.ihatecores.registration.features.old.ores.FeatureMapOLD;
import dev.falsegamemaster.ihatecores.registration.items.ItemMap;
import dev.falsegamemaster.ihatecores.registration.recipes.RecipeMap;
import dev.falsegamemaster.ihatecores.registration.sounds.SoundEventMap;
import dev.sam.keys_and_leds_core.block.ModBlocks;
import dev.sam.keys_and_leds_core.block.ModPropertyCyclers;
import dev.sam.keys_and_leds_core.block.ModWoodType;
import dev.sam.keys_and_leds_core.block_entities.ModBlockEntities;
import dev.sam.keys_and_leds_core.config.BuildConfig;
import dev.sam.keys_and_leds_core.entity.ModEntities;
import dev.sam.keys_and_leds_core.event.ModClientEvents;
import dev.sam.keys_and_leds_core.event.ModEvents;
import dev.sam.keys_and_leds_core.inventory.container.ModContainers;
import dev.sam.keys_and_leds_core.item.Compostables;
import dev.sam.keys_and_leds_core.item.HammerItem;
import dev.sam.keys_and_leds_core.item.ModBlockItems;
import dev.sam.keys_and_leds_core.item.ModItems;
import dev.sam.keys_and_leds_core.potion.ModEffects;
import dev.sam.keys_and_leds_core.recipe.ModRecipes;
import dev.sam.keys_and_leds_core.util.ModSoundEvents;
import dev.sam.keys_and_leds_core.world.gen.feature.ModFeatureCategories;
import dev.sam.keys_and_leds_core.world.gen.feature.ModFeatures;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="keys_and_leds_core")
public class KeysAndLedsCore
extends IHateCoresIntegration {
    public static final String MOD_ID = "keys_and_leds_core";
    public static final Config.Common COMMON_CONFIG = new Config.Common();
    public static final ItemMap ITEMS = new ItemMap();
    public static final BlockMap BLOCKS = new BlockMap(ITEMS);
    public static final WoodTypeMap WOODTYPES = new WoodTypeMap("keys_and_leds_core");
    public static final RecipeMap RECIPES = new RecipeMap();
    public static final ContainerMap CONTAINERS = new ContainerMap(RECIPES);
    public static final BlockEntityMap BLOCK_ENTITIES = new BlockEntityMap(BLOCKS, CONTAINERS, RECIPES);
    public static final EntityMap ENTITIES = new EntityMap();
    public static final SoundEventMap SOUNDS = new SoundEventMap();
    public static final EffectMap EFFECTS = new EffectMap();
    public static final FeatureCategoryMap FEATURE_CATEGORIES = new FeatureCategoryMap();
    public static final FeatureMap FEATURES = new FeatureMap(COMMON_CONFIG, FEATURE_CATEGORIES);
    public static final FeatureMapOLD OLD_FEATURES = new FeatureMapOLD(BLOCKS, COMMON_CONFIG);
    public static final PropertyCyclerMap PROPERTY_CYCLERS = new PropertyCyclerMap();

    public KeysAndLedsCore() {
        Compostables.create();
        ModWoodType.create(WOODTYPES);
        ModPropertyCyclers.create(PROPERTY_CYCLERS);
    }

    @Override
    public String getModId() {
        return MOD_ID;
    }

    @Override
    public void addEventHandlers(EventHandlers handlers) {
        handlers.addIfOn(Dist.CLIENT, () -> ModClientEvents.class);
        handlers.add(ModEvents.class);
        handlers.add(HammerItem.SpeedEvent.class);
        handlers.add(WOODTYPES);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
            modBus.addListener(ENTITIES::bindRenderers);
        });
    }

    @Override
    public void populateMaps(RegistryCreators registryCreators) {
        registryCreators.add(ITEMS, ModItems::create);
        registryCreators.add(BLOCKS, ModBlocks::create);
        registryCreators.add(ITEMS, ModBlockItems::create);
        registryCreators.add(RECIPES, ModRecipes::create);
        registryCreators.add(CONTAINERS, ModContainers::create);
        registryCreators.add(BLOCK_ENTITIES, ModBlockEntities::create);
        registryCreators.add(ENTITIES, ModEntities::create);
        registryCreators.add(SOUNDS, ModSoundEvents::create);
        registryCreators.add(EFFECTS, ModEffects::create);
        registryCreators.add(FEATURE_CATEGORIES, ModFeatureCategories::create);
        registryCreators.add(FEATURES, ModFeatures::create);
        registryCreators.add(OLD_FEATURES, ModFeatures::create);
    }

    @Override
    public void buildConfigs() {
        BuildConfig.build(COMMON_CONFIG);
    }

    @Override
    public void registerMaps(RegistryMaps maps) {
        maps.add(ITEMS, BLOCKS, RECIPES, CONTAINERS, BLOCK_ENTITIES, ENTITIES, SOUNDS, EFFECTS, FEATURE_CATEGORIES, FEATURES, OLD_FEATURES);
    }

    @Override
    public void registerConfigs(ConfigMaps configs) {
        configs.add((Config)COMMON_CONFIG);
    }
}

