/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.util.serialization;

import dev.falsegamemaster.ihatecores.util.serialization.SerializableRunnable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.function.Function;

public class ObjectSerializer {
    public static byte[] encodeByteArray(Object object) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            new ObjectOutputStream(baos).writeObject(object);
            return baos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T decodeByteArray(Class<T> clazz, byte[] array) {
        ByteArrayInputStream bais = new ByteArrayInputStream(array);
        try {
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object object = ois.readObject();
            if (!clazz.isAssignableFrom(object.getClass())) {
                return null;
            }
            return clazz.cast(object);
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encodeString(Object object) {
        return Base64.getEncoder().encodeToString(ObjectSerializer.encodeByteArray(object));
    }

    public static <T> T decodeString(Class<T> clazz, String string) {
        return ObjectSerializer.decodeByteArray(clazz, Base64.getDecoder().decode(string));
    }

    public static ByteBuffer encodeByteBuffer(Object object) {
        byte[] array = ObjectSerializer.encodeByteArray(object);
        if (array == null) {
            return null;
        }
        return ByteBuffer.wrap(array);
    }

    public static <T> T decodeByteBuffer(Class<T> clazz, ByteBuffer buffer) {
        return ObjectSerializer.decodeByteArray(clazz, buffer.array());
    }

    public static void main(String[] args) {
        SerializableRunnable runnable = () -> {
            Function<Integer, Integer> function = x -> x * x;
            System.out.println(function.apply(5));
        };
        runnable.run();
        byte[] array = ObjectSerializer.encodeByteArray(runnable);
        SerializableRunnable runnable1 = ObjectSerializer.decodeByteArray(SerializableRunnable.class, array);
        if (runnable1 == null) {
            return;
        }
        runnable1.run();
    }
}

