/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.util.json;

import com.google.common.collect.ImmutableList;
import dev.falsegamemaster.ihatecores.util.json.CodeBuilder;
import dev.falsegamemaster.ihatecores.util.json.JsonArray;
import dev.falsegamemaster.ihatecores.util.json.JsonCollection;
import dev.falsegamemaster.ihatecores.util.json.JsonElement;
import dev.falsegamemaster.ihatecores.util.json.JsonFormat;
import dev.falsegamemaster.ihatecores.util.json.JsonPrimitive;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;

public class JsonObject
extends JsonCollection {
    protected final Map<String, JsonElement> elements = new LinkedHashMap<String, JsonElement>();
    protected final Map<String, JsonObject> objects = new LinkedHashMap<String, JsonObject>();
    protected final Map<String, JsonArray> arrays = new LinkedHashMap<String, JsonArray>();
    protected final Map<String, Number> numbers = new LinkedHashMap<String, Number>();
    protected final Map<String, String> strings = new LinkedHashMap<String, String>();
    protected final Map<String, Boolean> booleans = new LinkedHashMap<String, Boolean>();
    protected final Map<String, Character> characters = new LinkedHashMap<String, Character>();

    @Override
    public Collection<JsonElement> elements() {
        return ImmutableList.copyOf(this.elements.values());
    }

    public Map<String, JsonElement> elementMap() {
        return this.elements;
    }

    public Map<String, JsonObject> objects() {
        return this.objects;
    }

    public Map<String, JsonArray> arrays() {
        return this.arrays;
    }

    public Map<String, Number> numbers() {
        return this.numbers;
    }

    public Map<String, String> strings() {
        return this.strings;
    }

    public Map<String, Boolean> booleans() {
        return this.booleans;
    }

    public Map<String, Character> characters() {
        return this.characters;
    }

    public JsonObject add(String property, JsonElement element) {
        this.elements.put(property, element.setParent(this));
        return this;
    }

    public JsonObject add(String property, Serializable primitive) {
        this.add(property, new JsonPrimitive<Serializable>(primitive));
        if (primitive instanceof Number) {
            this.numbers.put(property, (Number)primitive);
        } else if (primitive instanceof String) {
            this.strings.put(property, (String)((Object)primitive));
        } else if (primitive instanceof Boolean) {
            this.booleans.put(property, (Boolean)primitive);
        } else if (primitive instanceof Character) {
            this.characters.put(property, (Character)primitive);
        }
        return this;
    }

    public JsonObject add(String property, Number number) {
        this.add(property, new JsonPrimitive<Number>(number));
        this.numbers.put(property, number);
        return this;
    }

    public JsonObject add(String property, String string) {
        this.add(property, new JsonPrimitive<String>(string));
        this.strings.put(property, string);
        return this;
    }

    public JsonObject add(String property, Boolean bool) {
        this.add(property, new JsonPrimitive<Boolean>(bool));
        this.booleans.put(property, bool);
        return this;
    }

    public JsonObject add(String property, Character character) {
        this.add(property, new JsonPrimitive<Character>(character));
        this.characters.put(property, character);
        return this;
    }

    public JsonObject add(String property, JsonObject object) {
        this.add(property, (JsonElement)object);
        this.objects.put(property, object);
        return this;
    }

    public JsonObject add(String property, Consumer<JsonObject> consumer) {
        JsonObject object = new JsonObject();
        object.setParent(this);
        consumer.accept(object);
        return this.add(property, object);
    }

    public JsonObject addList(String property, Serializable ... array) {
        JsonArray jsonArray = new JsonArray().add(array);
        this.add(property, jsonArray);
        this.arrays.put(property, jsonArray);
        return this;
    }

    public JsonObject addList(String property, JsonObject ... array) {
        JsonArray jsonArray = new JsonArray();
        for (JsonObject o : array) {
            jsonArray.add((JsonElement)o);
        }
        this.add(property, jsonArray);
        this.arrays.put(property, jsonArray);
        return this;
    }

    @SafeVarargs
    public final JsonObject addList(String property, Consumer<JsonObject> ... array) {
        JsonArray jsonArray = new JsonArray();
        for (Consumer<JsonObject> c : array) {
            JsonObject object = new JsonObject();
            c.accept(object);
            jsonArray.add((JsonElement)object);
        }
        this.add(property, jsonArray);
        this.arrays.put(property, jsonArray);
        return this;
    }

    @Override
    public void addTo(CodeBuilder builder) {
        JsonFormat format = new JsonFormat();
        this.formatter.accept(format, this);
        boolean expands = format.doesExpand(this);
        builder.add("{").newLineIf(expands, 1);
        Iterator<Map.Entry<String, JsonElement>> iterator = this.elements.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, JsonElement> e = iterator.next();
            if (e instanceof JsonCollection) {
                ((JsonCollection)((Object)e)).setFormat(this.formatter);
            }
            builder.add("\"" + e.getKey() + "\"" + format.get(":", this));
            e.getValue().addTo(builder);
            if (iterator.hasNext()) {
                builder.add(format.get(",", this)).newLineIf(expands, 0);
                continue;
            }
            builder.newLineIf(expands, -1);
        }
        builder.add("}");
    }
}

